/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.DescribedNode;
import lombok.ast.Expression;
import lombok.ast.ExpressionMixin;
import lombok.ast.Literal;
import lombok.ast.Node;
import lombok.ast.Position;
import lombok.ast.StringLiteralTemplate;

public class StringLiteral
extends AbstractNode
implements Literal,
Expression,
DescribedNode {
    private List<Position> parensPositions = new ArrayList<Position>();
    private String value = null;
    private String rawValue;
    private String errorReasonForValue = "missing value";

    @Override
    public List<Position> astParensPositions() {
        return this.parensPositions;
    }

    public String astValue() {
        if (this.errorReasonForValue != null) {
            return null;
        }
        return this.value;
    }

    public StringLiteral astValue(String value) {
        if (value == null) {
            throw new NullPointerException("value is mandatory");
        }
        this.errorReasonForValue = null;
        this.value = value;
        this.rawValue = StringLiteralTemplate.generateString(value);
        return this;
    }

    @Override
    public String rawValue() {
        return this.rawValue;
    }

    public String getErrorReasonForValue() {
        return this.errorReasonForValue;
    }

    public StringLiteral rawValue(String value) {
        this.rawValue = value;
        this.value = null;
        this.errorReasonForValue = null;
        try {
            this.value = StringLiteralTemplate.parseString(value);
        }
        catch (IllegalArgumentException e) {
            this.errorReasonForValue = e.getMessage() == null ? e.toString() : e.getMessage();
        }
        catch (Exception e) {
            this.errorReasonForValue = e.toString();
        }
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        return false;
    }

    @Override
    public boolean detach(Node child) {
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitStringLiteral(this)) {
            return;
        }
        visitor.afterVisitStringLiteral(this);
        visitor.endVisit(this);
    }

    @Override
    public StringLiteral copy() {
        StringLiteral result = new StringLiteral();
        result.parensPositions = new ArrayList<Position>(this.parensPositions);
        result.value = this.value;
        result.rawValue = this.rawValue;
        result.errorReasonForValue = this.errorReasonForValue;
        return result;
    }

    @Override
    public String getDescription() {
        return StringLiteralTemplate.getDescription(this);
    }

    @Override
    public int getParens() {
        return ExpressionMixin.getParens(this);
    }

    @Override
    public int getIntendedParens() {
        return ExpressionMixin.getIntendedParens(this);
    }

    @Override
    public boolean needsParentheses() {
        return ExpressionMixin.needsParentheses(this);
    }

    @Override
    public boolean isStatementExpression() {
        return ExpressionMixin.isStatementExpression(this);
    }
}

