/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.fileTypes.FileNameMatcherFactory;

public class IgnoredPatternSet {
    private final Set<String> myMasks = new LinkedHashSet<String>();
    private final FileTypeAssocTable<Boolean> myIgnorePatterns = new FileTypeAssocTable().copy();

    @NotNull
    Set<String> getIgnoreMasks() {
        Set<String> set = Collections.unmodifiableSet(this.myMasks);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/IgnoredPatternSet", "getIgnoreMasks"));
        }
        return set;
    }

    public void setIgnoreMasks(@NotNull String list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/fileTypes/impl/IgnoredPatternSet", "setIgnoreMasks"));
        }
        this.clearPatterns();
        StringTokenizer tokenizer = new StringTokenizer(list, ";");
        while (tokenizer.hasMoreTokens()) {
            String ignoredFile = tokenizer.nextToken();
            this.addIgnoreMask(ignoredFile);
        }
    }

    void addIgnoreMask(@NotNull String ignoredFile) {
        if (ignoredFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoredFile", "com/intellij/openapi/fileTypes/impl/IgnoredPatternSet", "addIgnoreMask"));
        }
        if (this.myIgnorePatterns.findAssociatedFileType(ignoredFile) == null) {
            this.myMasks.add(ignoredFile);
            this.myIgnorePatterns.addAssociation(FileNameMatcherFactory.getInstance().createMatcher(ignoredFile), Boolean.TRUE);
        }
    }

    public boolean isIgnored(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/fileTypes/impl/IgnoredPatternSet", "isIgnored"));
        }
        if (this.myIgnorePatterns.findAssociatedFileType(fileName) == Boolean.TRUE) {
            return true;
        }
        return fileName.endsWith(".__del__");
    }

    void clearPatterns() {
        this.myMasks.clear();
        this.myIgnorePatterns.removeAllAssociations(Boolean.TRUE);
    }
}

