/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.indices.MavenArtifactSearchDialog;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;

public class AddMavenDependencyQuickFix
implements IntentionAction,
LowPriorityAction {
    private static final Pattern CLASSNAME_PATTERN = Pattern.compile("(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{Lu}\\p{javaJavaIdentifierPart}+");
    private final PsiJavaCodeReferenceElement myRef;

    public AddMavenDependencyQuickFix(PsiJavaCodeReferenceElement ref) {
        this.myRef = ref;
    }

    @NotNull
    public String getText() {
        if ("Add Maven Dependency..." == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/intentions/AddMavenDependencyQuickFix", "getText"));
        }
        return "Add Maven Dependency...";
    }

    @NotNull
    public String getFamilyName() {
        String string = MavenDomBundle.message("inspection.group", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/intentions/AddMavenDependencyQuickFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/dom/intentions/AddMavenDependencyQuickFix", "isAvailable"));
        }
        return this.myRef.isValid() && MavenDomUtil.findContainingProject((PsiElement)file) != null && AddMavenDependencyQuickFix.looksLikeClassName(this.getReferenceText());
    }

    private static boolean looksLikeClassName(@Nullable String text) {
        if (text == null) {
            return false;
        }
        return CLASSNAME_PATTERN.matcher(text).matches();
    }

    public void invoke(final @NotNull Project project, Editor editor, final PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/dom/intentions/AddMavenDependencyQuickFix", "invoke"));
        }
        if (!this.myRef.isValid()) {
            return;
        }
        MavenProject mavenProject = MavenDomUtil.findContainingProject((PsiElement)file);
        if (mavenProject == null) {
            return;
        }
        final List<MavenId> ids = MavenArtifactSearchDialog.searchForClass(project, this.getReferenceText());
        if (ids.isEmpty()) {
            return;
        }
        final MavenDomProjectModel model = MavenDomUtil.getMavenDomProjectModel(project, mavenProject.getFile());
        if (model == null) {
            return;
        }
        new WriteCommandAction(project, "Add Maven Dependency", new PsiFile[]{DomUtil.getFile((DomElement)model)}){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/maven/dom/intentions/AddMavenDependencyQuickFix$1", "run"));
                }
                boolean isTestSource = false;
                VirtualFile virtualFile = file.getOriginalFile().getVirtualFile();
                if (virtualFile != null) {
                    isTestSource = ProjectRootManager.getInstance((Project)project).getFileIndex().isInTestSourceContent(virtualFile);
                }
                for (MavenId each : ids) {
                    MavenDomDependency dependency = MavenDomUtil.createDomDependency(model, null, each);
                    if (!isTestSource) continue;
                    dependency.getScope().setStringValue("test");
                }
            }
        }.execute();
    }

    public String getReferenceText() {
        PsiElement parent;
        PsiJavaCodeReferenceElement result = this.myRef;
        while ((parent = result.getParent()) instanceof PsiJavaCodeReferenceElement) {
            result = (PsiJavaCodeReferenceElement)parent;
        }
        return result.getQualifiedName();
    }

    public boolean startInWriteAction() {
        return false;
    }
}

