/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleExtension;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.project.model.impl.module.JpsRootModel;
import com.intellij.project.model.impl.module.content.JpsContentEntry;
import com.intellij.project.model.impl.module.content.JpsSourceFolder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.Url;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaModuleType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleType;

public class MavenSourceFoldersModuleExtension
extends ModuleExtension<MavenSourceFoldersModuleExtension> {
    private ModifiableRootModel myRootModel;
    private JpsModule myDummyJpsModule;
    private JpsRootModel myDummyJpsRootModel;
    private final Set<JpsSourceFolder> myJpsSourceFolders = new TreeSet<ContentFolder>(ContentFolderComparator.INSTANCE);
    private boolean isJpsSourceFoldersChanged;

    public void init(@NotNull Module module, @NotNull ModifiableRootModel modifiableRootModel) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/maven/importing/MavenSourceFoldersModuleExtension", "init"));
        }
        if (modifiableRootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiableRootModel", "org/jetbrains/idea/maven/importing/MavenSourceFoldersModuleExtension", "init"));
        }
        this.myRootModel = modifiableRootModel;
        this.myDummyJpsModule = JpsElementFactory.getInstance().createModule(module.getName(), (JpsModuleType)JpsJavaModuleType.INSTANCE, (JpsElement)JpsElementFactory.getInstance().createDummyElement());
        this.myDummyJpsRootModel = new JpsRootModel(module, this.myDummyJpsModule);
        for (JpsSourceFolder folder : this.myJpsSourceFolders) {
            Disposer.dispose((Disposable)folder);
        }
        this.myJpsSourceFolders.clear();
        for (ContentEntry eachEntry : modifiableRootModel.getContentEntries()) {
            for (SourceFolder eachFolder : eachEntry.getSourceFolders()) {
                JpsModuleSourceRoot jpsModuleSourceRoot = JpsElementFactory.getInstance().createModuleSourceRoot(eachFolder.getUrl(), eachFolder.getRootType(), eachFolder.getJpsElement().getProperties().getBulkModificationSupport().createCopy());
                this.addJspSourceFolder(jpsModuleSourceRoot, eachFolder.getUrl());
            }
        }
    }

    public ModuleExtension getModifiableModel(boolean writable) {
        return new MavenSourceFoldersModuleExtension();
    }

    public void commit() {
        if (!this.isJpsSourceFoldersChanged) {
            return;
        }
        for (ContentEntry eachEntry : this.myRootModel.getContentEntries()) {
            for (SourceFolder eachFolder : eachEntry.getSourceFolders()) {
                boolean found = false;
                for (JpsSourceFolder jpsSourceFolder : this.myJpsSourceFolders) {
                    if (!StringUtil.equals((CharSequence)jpsSourceFolder.getUrl(), (CharSequence)eachFolder.getUrl()) || !eachFolder.getRootType().equals(jpsSourceFolder.getRootType())) continue;
                    found = true;
                    if (eachFolder.getRootType() instanceof JavaSourceRootType) {
                        JavaSourceRootProperties jpsJavaSourceRootProperties = (JavaSourceRootProperties)jpsSourceFolder.getJpsElement().getProperties((JpsModuleSourceRootType)((JavaSourceRootType)eachFolder.getRootType()));
                        JavaSourceRootProperties javaSourceRootProperties = (JavaSourceRootProperties)eachFolder.getJpsElement().getProperties((JpsModuleSourceRootType)((JavaSourceRootType)eachFolder.getRootType()));
                        if (javaSourceRootProperties != null && jpsJavaSourceRootProperties != null) {
                            javaSourceRootProperties.applyChanges(jpsJavaSourceRootProperties);
                        }
                    }
                    this.myJpsSourceFolders.remove(jpsSourceFolder);
                    Disposer.dispose((Disposable)jpsSourceFolder);
                    break;
                }
                if (found) continue;
                eachEntry.removeSourceFolder(eachFolder);
            }
        }
        for (JpsSourceFolder jpsSourceFolder : this.myJpsSourceFolders) {
            Url url = new Url(jpsSourceFolder.getUrl());
            ContentEntry e = this.getContentRootFor(url);
            if (e == null) continue;
            JpsModuleSourceRootType sourceRootType = jpsSourceFolder.getRootType();
            JpsElementBase properties = (JpsElementBase)jpsSourceFolder.getSourceRoot().getProperties();
            properties.setParent(null);
            e.addSourceFolder(url.getUrl(), sourceRootType, (JpsElement)properties);
        }
        this.isJpsSourceFoldersChanged = false;
    }

    public boolean isChanged() {
        return this.isJpsSourceFoldersChanged;
    }

    public void dispose() {
        for (JpsSourceFolder folder : this.myJpsSourceFolders) {
            Disposer.dispose((Disposable)folder);
        }
        this.myJpsSourceFolders.clear();
    }

    public void readExternal(Element element) throws InvalidDataException {
    }

    public void writeExternal(Element element) throws WriteExternalException {
    }

    public void clearSourceFolders() {
        for (JpsSourceFolder folder : this.myJpsSourceFolders) {
            Disposer.dispose((Disposable)folder);
        }
        this.myJpsSourceFolders.clear();
        this.isJpsSourceFoldersChanged = true;
    }

    public <P extends JpsElement> void addSourceFolder(@NotNull Url url, @NotNull JpsModuleSourceRootType<P> rootType, @NotNull P properties) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/maven/importing/MavenSourceFoldersModuleExtension", "addSourceFolder"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "org/jetbrains/idea/maven/importing/MavenSourceFoldersModuleExtension", "addSourceFolder"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/idea/maven/importing/MavenSourceFoldersModuleExtension", "addSourceFolder"));
        }
        Iterator<JpsSourceFolder> iterator = this.myJpsSourceFolders.iterator();
        while (iterator.hasNext()) {
            JpsSourceFolder eachFolder = iterator.next();
            if (!VfsUtilCore.isEqualOrAncestor((String)url.getUrl(), (String)eachFolder.getUrl()) && !VfsUtilCore.isEqualOrAncestor((String)eachFolder.getUrl(), (String)url.getUrl())) continue;
            iterator.remove();
            Disposer.dispose((Disposable)eachFolder);
        }
        JpsModuleSourceRoot jpsModuleSourceRoot = JpsElementFactory.getInstance().createModuleSourceRoot(url.getUrl(), rootType, properties);
        this.addJspSourceFolder(jpsModuleSourceRoot, url.getUrl());
        this.isJpsSourceFoldersChanged = true;
    }

    public boolean hasRegisteredSourceSubfolder(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/maven/importing/MavenSourceFoldersModuleExtension", "hasRegisteredSourceSubfolder"));
        }
        for (JpsSourceFolder eachFolder : this.myJpsSourceFolders) {
            if (!VfsUtilCore.isEqualOrAncestor((String)url, (String)eachFolder.getUrl())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public SourceFolder getSourceFolder(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/maven/importing/MavenSourceFoldersModuleExtension", "getSourceFolder"));
        }
        for (JpsSourceFolder eachFolder : this.myJpsSourceFolders) {
            if (!eachFolder.getUrl().equals(url)) continue;
            return eachFolder;
        }
        return null;
    }

    @NotNull
    public String[] getSourceRootUrls(boolean includingTests) {
        SmartList result = new SmartList();
        for (JpsSourceFolder eachFolder : this.myJpsSourceFolders) {
            if (!includingTests && eachFolder.isTestSource()) continue;
            result.add(eachFolder.getUrl());
        }
        String[] stringArray = ArrayUtil.toStringArray((Collection)result);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/importing/MavenSourceFoldersModuleExtension", "getSourceRootUrls"));
        }
        return stringArray;
    }

    @Nullable
    private ContentEntry getContentRootFor(@NotNull Url url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/maven/importing/MavenSourceFoldersModuleExtension", "getContentRootFor"));
        }
        for (ContentEntry e : this.myRootModel.getContentEntries()) {
            if (!VfsUtilCore.isEqualOrAncestor((String)e.getUrl(), (String)url.getUrl())) continue;
            return e;
        }
        return null;
    }

    public void unregisterAll(@NotNull Url url, boolean under) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/maven/importing/MavenSourceFoldersModuleExtension", "unregisterAll"));
        }
        Iterator<JpsSourceFolder> iterator = this.myJpsSourceFolders.iterator();
        while (iterator.hasNext()) {
            String child;
            JpsSourceFolder eachFolder = iterator.next();
            String ancestor = under ? url.getUrl() : eachFolder.getUrl();
            if (!VfsUtilCore.isEqualOrAncestor((String)ancestor, (String)(child = under ? eachFolder.getUrl() : url.getUrl()))) continue;
            iterator.remove();
            Disposer.dispose((Disposable)eachFolder);
        }
    }

    private void addJspSourceFolder(@NotNull JpsModuleSourceRoot jpsModuleSourceRoot, @NotNull String url) {
        if (jpsModuleSourceRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jpsModuleSourceRoot", "org/jetbrains/idea/maven/importing/MavenSourceFoldersModuleExtension", "addJspSourceFolder"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/maven/importing/MavenSourceFoldersModuleExtension", "addJspSourceFolder"));
        }
        JpsContentEntry dummyJpsContentEntry = new JpsContentEntry(this.myDummyJpsModule, this.myDummyJpsRootModel, url);
        JpsSourceFolder jpsSourceFolder = new JpsSourceFolder(jpsModuleSourceRoot, dummyJpsContentEntry);
        this.myJpsSourceFolders.add(jpsSourceFolder);
        Disposer.register((Disposable)jpsSourceFolder, (Disposable)dummyJpsContentEntry);
    }

    private static final class ContentFolderComparator
    implements Comparator<ContentFolder> {
        public static final ContentFolderComparator INSTANCE = new ContentFolderComparator();

        private ContentFolderComparator() {
        }

        @Override
        public int compare(@NotNull ContentFolder o1, @NotNull ContentFolder o2) {
            if (o1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "org/jetbrains/idea/maven/importing/MavenSourceFoldersModuleExtension$ContentFolderComparator", "compare"));
            }
            if (o2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "org/jetbrains/idea/maven/importing/MavenSourceFoldersModuleExtension$ContentFolderComparator", "compare"));
            }
            return StringUtil.naturalCompare((String)o1.getUrl(), (String)o2.getUrl());
        }
    }
}

