/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.DependencyConflictId;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;

public class MavenArtifactIndex {
    private static final MavenArtifactIndex EMPTY_INDEX = new MavenArtifactIndex(Collections.emptyMap());
    private final Map<String, Map<String, List<MavenArtifact>>> myData;

    private MavenArtifactIndex(Map<String, Map<String, List<MavenArtifact>>> data) {
        this.myData = data;
    }

    public Map<String, Map<String, List<MavenArtifact>>> getData() {
        return this.myData;
    }

    @NotNull
    public List<MavenArtifact> findArtifacts(@Nullable String groupId, @Nullable String artifactId) {
        Map<String, List<MavenArtifact>> groupMap = this.myData.get(groupId);
        if (groupMap == null) {
            List<MavenArtifact> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenArtifactIndex", "findArtifacts"));
            }
            return list;
        }
        List<MavenArtifact> res = groupMap.get(artifactId);
        List<Object> list = res == null ? Collections.emptyList() : res;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenArtifactIndex", "findArtifacts"));
        }
        return list;
    }

    @NotNull
    public List<MavenArtifact> findArtifacts(@Nullable MavenId mavenId) {
        if (mavenId == null) {
            List<MavenArtifact> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenArtifactIndex", "findArtifacts"));
            }
            return list;
        }
        List<MavenArtifact> list = this.findArtifacts(mavenId.getGroupId(), mavenId.getArtifactId(), mavenId.getVersion());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenArtifactIndex", "findArtifacts"));
        }
        return list;
    }

    @Nullable
    public MavenArtifact findArtifacts(@NotNull DependencyConflictId id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/idea/maven/project/MavenArtifactIndex", "findArtifacts"));
        }
        for (MavenArtifact artifact : this.findArtifacts(id.getGroupId(), id.getArtifactId())) {
            if (!id.equals(DependencyConflictId.create(artifact))) continue;
            return artifact;
        }
        return null;
    }

    @NotNull
    public List<MavenArtifact> findArtifacts(@Nullable String groupId, @Nullable String artifactId, @Nullable String version) {
        Map<String, List<MavenArtifact>> groupMap = this.myData.get(groupId);
        if (groupMap == null) {
            List<MavenArtifact> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenArtifactIndex", "findArtifacts"));
            }
            return list;
        }
        List<MavenArtifact> artifacts = groupMap.get(artifactId);
        if (artifacts == null) {
            List<MavenArtifact> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenArtifactIndex", "findArtifacts"));
            }
            return list;
        }
        SmartList res = new SmartList();
        for (MavenArtifact artifact : artifacts) {
            if (!Comparing.equal((String)version, (String)artifact.getVersion())) continue;
            res.add(artifact);
        }
        SmartList smartList = res;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenArtifactIndex", "findArtifacts"));
        }
        return smartList;
    }

    public static MavenArtifactIndex build(@NotNull List<MavenArtifact> dependencies) {
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "org/jetbrains/idea/maven/project/MavenArtifactIndex", "build"));
        }
        if (dependencies.isEmpty()) {
            return EMPTY_INDEX;
        }
        HashMap<String, Map<String, List<MavenArtifact>>> map = new HashMap<String, Map<String, List<MavenArtifact>>>();
        for (MavenArtifact dep : dependencies) {
            List artifactList;
            String artifactId;
            String groupId = dep.getGroupId();
            if (groupId == null || (artifactId = dep.getArtifactId()) == null) continue;
            HashMap<String, List> groupMap = (HashMap<String, List>)map.get(groupId);
            if (groupMap == null) {
                groupMap = new HashMap<String, List>();
                map.put(groupId, groupMap);
            }
            if ((artifactList = (List)groupMap.get(artifactId)) == null) {
                artifactList = new SmartList();
                groupMap.put(artifactId, artifactList);
            }
            artifactList.add(dep);
        }
        return new MavenArtifactIndex(map);
    }
}

