/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library.remote;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.utils.library.RepositoryAttachHandler;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.RepositoryUtils;
import org.jetbrains.idea.maven.utils.library.remote.MavenRemoteManager;
import org.jetbrains.idea.maven.utils.library.remote.MavenRemoteTask;

public class MavenDependenciesRemoteManager
extends MavenRemoteManager<List<OrderRoot>, Argument, MavenDependenciesRemoteManager>
implements MavenRemoteTask<List<OrderRoot>, Argument> {
    public MavenDependenciesRemoteManager(Project project) {
        super(project);
    }

    public static MavenDependenciesRemoteManager getInstance(Project project) {
        return (MavenDependenciesRemoteManager)project.getComponent(MavenDependenciesRemoteManager.class);
    }

    public void downloadDependenciesAsync(RepositoryLibraryProperties libraryProperties, boolean downloadSources, boolean downloadJavaDocs, String copyTo, MavenRemoteTask.ResultProcessor<List<OrderRoot>> resultProcessor) {
        this.schedule(this, new Argument(libraryProperties, downloadSources, downloadJavaDocs, copyTo), resultProcessor, false);
    }

    @Nullable
    public List<OrderRoot> downloadDependencies(RepositoryLibraryProperties libraryProperties, boolean downloadSources, boolean downloadJavaDocs, String copyTo) {
        return (List)this.getSynchronously(this, new Argument(libraryProperties, downloadSources, downloadJavaDocs, copyTo));
    }

    @Nullable
    public List<OrderRoot> downloadDependenciesModal(RepositoryLibraryProperties libraryProperties, boolean downloadSources, boolean downloadJavaDocs, String copyTo) {
        return (List)this.getSynchronouslyWithModal(this, new Argument(libraryProperties, downloadSources, downloadJavaDocs, copyTo), ProjectBundle.message("maven.resolving", new Object[0]));
    }

    @Override
    @NotNull
    public List<OrderRoot> execute(@NotNull Argument arg, ProgressIndicator indicator) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "org/jetbrains/idea/maven/utils/library/remote/MavenDependenciesRemoteManager", "execute"));
        }
        String coordinates = arg.libraryProperties.getGroupId() + ":" + arg.libraryProperties.getArtifactId() + ":" + RepositoryUtils.resolveEffectiveVersion(this.myProject, arg.libraryProperties);
        List<OrderRoot> list = RepositoryAttachHandler.resolveAndDownloadImpl(this.myProject, coordinates, arg.downloadJavaDocs, arg.downloadSources, arg.copyTo, RepositoryLibraryDescription.findDescription(arg.libraryProperties).getRemoteRepositories(), indicator);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/remote/MavenDependenciesRemoteManager", "execute"));
        }
        return list;
    }

    @Override
    public String getName(@NotNull Argument arg) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "org/jetbrains/idea/maven/utils/library/remote/MavenDependenciesRemoteManager", "getName"));
        }
        RepositoryLibraryDescription libraryDescription = RepositoryLibraryDescription.findDescription(arg.libraryProperties);
        return ProjectBundle.message("maven.loading.library.hint", libraryDescription.getDisplayName());
    }

    public static class Argument {
        public RepositoryLibraryProperties libraryProperties;
        public boolean downloadSources;
        public boolean downloadJavaDocs;
        @Nullable
        public String copyTo;

        public Argument(RepositoryLibraryProperties libraryProperties, boolean downloadSources, boolean downloadJavaDocs, @Nullable String copyTo) {
            this.libraryProperties = libraryProperties;
            this.downloadSources = downloadSources;
            this.downloadJavaDocs = downloadJavaDocs;
            this.copyTo = copyTo;
        }
    }
}

