/*
 * Decompiled with CFR 0.152.
 */
package org.markdown4j;

import com.github.rjeschke.txtmark.DefaultDecorator;
import java.util.Map;
import org.markdown4j.HtmlAttributes;

public class ExtDecorator
extends DefaultDecorator {
    private HtmlAttributes attributes = new HtmlAttributes();

    public ExtDecorator addHtmlAttribute(String name, String value, String ... tags) {
        for (String tag : tags) {
            this.attributes.put(tag, name, value);
        }
        return this;
    }

    public ExtDecorator addStyleClass(String styleClass, String ... tags) {
        for (String tag : tags) {
            this.attributes.put(tag, "class", styleClass);
        }
        return this;
    }

    public ExtDecorator useCompactStyle() {
        this.attributes.put("p", "style", "font-size:100%; padding:0px; margin:0px;");
        this.attributes.put("a", "style", "font-size:100%; padding:0px; margin:0px;");
        this.attributes.put("h1", "style", "font-size:100%; padding:0px; margin:0px;");
        this.attributes.put("h2", "style", "font-size:100%; padding:0px; margin:0px;");
        this.attributes.put("h3", "style", "font-size:100%; padding:0px; margin:0px;");
        this.attributes.put("h4", "style", "font-size:100%; padding:0px; margin:0px;");
        this.attributes.put("h5", "style", "font-size:100%; padding:0px; margin:0px;");
        this.attributes.put("h6", "style", "font-size:100%; padding:0px; margin:0px;");
        this.attributes.put("ul", "style", "font-size:100%; padding:0px; margin:0px;");
        this.attributes.put("ol", "style", "font-size:100%; padding:0px; margin:0px;");
        this.attributes.put("li", "style", "font-size:100%; padding:0px; margin:0px;");
        return this;
    }

    private boolean open(StringBuilder out, String tagName) {
        return this.open(out, tagName, true);
    }

    private boolean open(StringBuilder out, String tagName, boolean closed) {
        Map<String, String> atts = this.attributes.get(tagName);
        if (atts != null) {
            out.append("<");
            out.append(tagName);
            for (String key : atts.keySet()) {
                String value = atts.get(key);
                out.append(" ");
                out.append(key);
                out.append("=\"");
                out.append(value);
                out.append("\"");
                out.append(" ");
            }
            if (closed) {
                out.append(">");
            }
            return true;
        }
        return false;
    }

    public void openParagraph(StringBuilder out) {
        if (!this.open(out, "p")) {
            super.openParagraph(out);
        }
    }

    public void openBlockquote(StringBuilder out) {
        if (!this.open(out, "blockquote")) {
            super.openBlockquote(out);
        }
    }

    public void openCodeBlock(StringBuilder out) {
        if (!this.open(out, "pre")) {
            super.openCodeBlock(out);
        }
    }

    public void openCodeSpan(StringBuilder out) {
        if (!this.open(out, "code")) {
            super.openCodeSpan(out);
        }
    }

    public void openHeadline(StringBuilder out, int level) {
        if (!this.open(out, "h" + level, false)) {
            super.openHeadline(out, level);
        }
    }

    public void openStrong(StringBuilder out) {
        if (!this.open(out, "strong")) {
            super.openStrong(out);
        }
    }

    public void openStrike(StringBuilder out) {
        if (!this.open(out, "s")) {
            super.openStrike(out);
        }
    }

    public void openEmphasis(StringBuilder out) {
        if (!this.open(out, "em")) {
            super.openEmphasis(out);
        }
    }

    public void openSuper(StringBuilder out) {
        if (!this.open(out, "super")) {
            super.openSuper(out);
        }
    }

    public void openOrderedList(StringBuilder out) {
        if (!this.open(out, "ol")) {
            super.openOrderedList(out);
        }
    }

    public void openUnorderedList(StringBuilder out) {
        if (!this.open(out, "ul")) {
            super.openUnorderedList(out);
        }
    }

    public void openListItem(StringBuilder out) {
        if (!this.open(out, "li", false)) {
            super.openListItem(out);
        }
    }

    public void horizontalRuler(StringBuilder out) {
        if (this.open(out, "hr", false)) {
            out.append("/>");
        } else {
            super.horizontalRuler(out);
        }
    }

    public void openLink(StringBuilder out) {
        if (!this.open(out, "a", false)) {
            super.openLink(out);
        }
    }

    public void openImage(StringBuilder out) {
        if (!this.open(out, "img", false)) {
            super.openImage(out);
        }
    }
}

