/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Processor;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.EclipseXml;

public class EclipseProjectFinder
implements EclipseXml {
    public static void findModuleRoots(List<String> paths, String rootPath, @Nullable Processor<String> progressUpdater) {
        File[] files;
        File root;
        String project;
        if (progressUpdater != null) {
            progressUpdater.process((Object)rootPath);
        }
        if ((project = EclipseProjectFinder.findProjectName(rootPath)) != null) {
            paths.add(rootPath);
        }
        if ((root = new File(rootPath)).isDirectory() && (files = root.listFiles()) != null) {
            for (File file : files) {
                EclipseProjectFinder.findModuleRoots(paths, file.getPath(), progressUpdater);
            }
        }
    }

    @Nullable
    public static String findProjectName(String rootPath) {
        String name = null;
        File file = new File(rootPath, ".project");
        if (file.isFile()) {
            try {
                name = JDOMUtil.loadDocument((File)file).getRootElement().getChildText("name");
                if (StringUtil.isEmptyOrSpaces((String)name)) {
                    return null;
                }
                name = name.replace("\n", " ").trim();
            }
            catch (JDOMException e) {
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        return name;
    }

    @Nullable
    public static LinkedResource findLinkedResource(@NotNull String projectPath, @NotNull String relativePath) {
        File file;
        String independentPath;
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "org/jetbrains/idea/eclipse/EclipseProjectFinder", "findLinkedResource"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "org/jetbrains/idea/eclipse/EclipseProjectFinder", "findLinkedResource"));
        }
        String resourceName = independentPath = FileUtil.toSystemIndependentName((String)relativePath);
        int idx = independentPath.indexOf(47);
        if (idx != -1) {
            resourceName = independentPath.substring(0, idx);
        }
        if ((file = new File(projectPath, ".project")).isFile()) {
            try {
                for (Object o : JDOMUtil.loadDocument((File)file).getRootElement().getChildren("linkedResources")) {
                    for (Object l : ((Element)o).getChildren("link")) {
                        Element location;
                        if (!Comparing.strEqual((String)((Element)l).getChildText("name"), (String)resourceName)) continue;
                        LinkedResource linkedResource = new LinkedResource();
                        String relativeToLinkedResourcePath = independentPath.length() > resourceName.length() ? independentPath.substring(resourceName.length()) : "";
                        Element locationURI = ((Element)l).getChild("locationURI");
                        if (locationURI != null) {
                            linkedResource.setURI(FileUtil.toSystemIndependentName((String)locationURI.getText()) + relativeToLinkedResourcePath);
                        }
                        if ((location = ((Element)l).getChild("location")) != null) {
                            linkedResource.setLocation(FileUtil.toSystemIndependentName((String)location.getText()) + relativeToLinkedResourcePath);
                        }
                        return linkedResource;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static class LinkedResource {
        private String myURI;
        private String myLocation;

        public String getVariableName() {
            int idx = this.myURI.indexOf(47);
            return idx > -1 ? this.myURI.substring(0, idx) : this.myURI;
        }

        @Nullable
        public String getRelativeToVariablePath() {
            int idx = this.myURI.indexOf(47);
            return idx > -1 && idx + 1 < this.myURI.length() ? this.myURI.substring(idx + 1) : null;
        }

        public boolean containsPathVariable() {
            return this.myURI != null;
        }

        public void setURI(String URI2) {
            this.myURI = URI2;
        }

        public String getLocation() {
            return this.myLocation;
        }

        public void setLocation(String location) {
            this.myLocation = location;
        }
    }
}

