/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gradle.model.impl;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.pattern.PatternMatcherFactory;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.gradle.model.impl.FilePattern;

public class GradleResourceFileFilter
implements FileFilter {
    private FilePattern myFilePattern;
    private File myRoot;
    private final Spec<RelativePath> myFileFilterSpec;

    public GradleResourceFileFilter(@NotNull File rootFile, @NotNull FilePattern filePattern) {
        if (rootFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootFile", "org/jetbrains/jps/gradle/model/impl/GradleResourceFileFilter", "<init>"));
        }
        if (filePattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePattern", "org/jetbrains/jps/gradle/model/impl/GradleResourceFileFilter", "<init>"));
        }
        this.myFilePattern = filePattern;
        this.myRoot = rootFile;
        this.myFileFilterSpec = this.getAsSpec();
    }

    @Override
    public boolean accept(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/gradle/model/impl/GradleResourceFileFilter", "accept"));
        }
        String relPath = FileUtil.getRelativePath((File)this.myRoot, (File)file);
        return relPath != null && this.isIncluded(relPath);
    }

    private boolean isIncluded(@NotNull String relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "org/jetbrains/jps/gradle/model/impl/GradleResourceFileFilter", "isIncluded"));
        }
        RelativePath path = new RelativePath(true, relativePath.split(Pattern.quote(File.separator)));
        return this.myFileFilterSpec.isSatisfiedBy((Object)path);
    }

    private Spec<RelativePath> getAsSpec() {
        return Specs.and((Spec[])new Spec[]{this.getAsIncludeSpec(true), Specs.not(this.getAsExcludeSpec(true))});
    }

    private Spec<RelativePath> getAsExcludeSpec(boolean caseSensitive) {
        LinkedHashSet<String> allExcludes = new LinkedHashSet<String>(this.myFilePattern.excludes);
        ArrayList<Spec> matchers = new ArrayList<Spec>();
        for (String exclude : allExcludes) {
            Spec patternMatcher = PatternMatcherFactory.getPatternMatcher((boolean)false, (boolean)caseSensitive, (String)exclude);
            matchers.add(patternMatcher);
        }
        return Specs.or((boolean)false, matchers);
    }

    private Spec<RelativePath> getAsIncludeSpec(boolean caseSensitive) {
        ArrayList<Spec> matchers = new ArrayList<Spec>();
        for (String include : this.myFilePattern.includes) {
            Spec patternMatcher = PatternMatcherFactory.getPatternMatcher((boolean)true, (boolean)caseSensitive, (String)include);
            matchers.add(patternMatcher);
        }
        return Specs.or((boolean)true, matchers);
    }
}

