/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira.jql.psi.impl;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.tasks.jira.jql.psi.JqlElement;
import com.intellij.tasks.jira.jql.psi.JqlElementVisitor;
import org.jetbrains.annotations.NotNull;

public abstract class JqlElementImpl
extends ASTWrapperPsiElement
implements JqlElement {
    protected JqlElementImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/tasks/jira/jql/psi/impl/JqlElementImpl", "<init>"));
        }
        super(node);
    }

    public String toString() {
        String className = this.getClass().getSimpleName();
        className = StringUtil.trimEnd((String)className, (String)"Impl");
        return String.format("%s(%s)", className, this.getText());
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/tasks/jira/jql/psi/impl/JqlElementImpl", "accept"));
        }
        if (visitor instanceof JqlElementVisitor) {
            this.accept((JqlElementVisitor)visitor);
        } else {
            super.accept(visitor);
        }
    }

    protected static String unescape(String s) {
        if (s.length() >= 2 && (s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'' || s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"')) {
            s = s.substring(1, s.length() - 1);
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c1 = s.charAt(i);
            if (c1 == '\\') {
                assert (i != s.length() - 1) : "Trailing backslash";
                char c2 = s.charAt(++i);
                switch (c2) {
                    case ' ': 
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        builder.append(c2);
                        break;
                    }
                    case 'n': {
                        builder.append('\n');
                        break;
                    }
                    case 't': {
                        builder.append('\t');
                        break;
                    }
                    case '\r': {
                        builder.append('\r');
                        break;
                    }
                    case 'u': {
                        assert (i < s.length() - 4) : "Incomplete unicode escape sequence: " + s.substring(i - 1);
                        builder.append((char)Integer.parseInt(s.substring(i + 1, i + 5), 16));
                        i += 4;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Illegal escape at " + s.substring(i)));
                    }
                }
                continue;
            }
            builder.append(c1);
        }
        return builder.toString();
    }

    public abstract void accept(JqlElementVisitor var1);
}

