/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira.soap;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Comment;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.jira.JiraTask;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JiraSoapTask
extends JiraTask {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
    private final String myKey;
    private final String mySummary;
    private final String myDescription;
    private final String myIconUrl;
    private final Date myUpdated;
    private final Date myCreated;
    private final TaskState myState;
    private final TaskType myType;
    private final List<Comment> myComments;

    public JiraSoapTask(@NotNull Element element, @NotNull TaskRepository repository) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/tasks/jira/soap/JiraSoapTask", "<init>"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/tasks/jira/soap/JiraSoapTask", "<init>"));
        }
        super(repository);
        this.myKey = element.getChildText("key");
        this.mySummary = element.getChildText("summary");
        this.myDescription = element.getChildText("description");
        this.myIconUrl = JiraSoapTask.getChildAttribute(element, "type", "iconUrl");
        this.myType = this.getTypeByName(element.getChildText("type"));
        String statusIdText = JiraSoapTask.getChildAttribute(element, "status", "id");
        this.myState = this.getStateById(StringUtil.isEmpty((String)statusIdText) ? 0 : Integer.parseInt(statusIdText));
        this.myCreated = JiraSoapTask.parseDate(element.getChildText("created"));
        this.myUpdated = JiraSoapTask.parseDate(element.getChildText("updated"));
        Element comments = element.getChild("comments");
        this.myComments = comments != null ? ContainerUtil.map((Collection)comments.getChildren("comment"), (Function)new Function<Element, Comment>(){

            public Comment fun(final Element element) {
                return new Comment(){

                    public String getText() {
                        return element.getText();
                    }

                    @Nullable
                    public String getAuthor() {
                        return element.getAttributeValue("author");
                    }

                    @Nullable
                    public Date getDate() {
                        return JiraSoapTask.parseDate(element.getAttributeValue("created"));
                    }
                };
            }
        }) : ContainerUtil.emptyList();
    }

    @Override
    @NotNull
    public String getId() {
        String string = this.myKey;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/soap/JiraSoapTask", "getId"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getSummary() {
        String string = this.mySummary;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/soap/JiraSoapTask", "getSummary"));
        }
        return string;
    }

    @Override
    public String getDescription() {
        return this.myDescription;
    }

    @Override
    @NotNull
    public Comment[] getComments() {
        Comment[] commentArray = this.myComments.toArray(new Comment[this.myComments.size()]);
        if (commentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/soap/JiraSoapTask", "getComments"));
        }
        return commentArray;
    }

    @Override
    @Nullable
    protected String getIconUrl() {
        return this.myIconUrl;
    }

    @Override
    @NotNull
    public TaskType getType() {
        TaskType taskType = this.myType;
        if (taskType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/soap/JiraSoapTask", "getType"));
        }
        return taskType;
    }

    @Override
    public TaskState getState() {
        return this.myState;
    }

    @Override
    @Nullable
    public Date getUpdated() {
        return this.myUpdated;
    }

    @Override
    public Date getCreated() {
        return this.myCreated;
    }

    @Nullable
    private static Date parseDate(@NotNull String date) {
        if (date == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "date", "com/intellij/tasks/jira/soap/JiraSoapTask", "parseDate"));
        }
        try {
            return DATE_FORMAT.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Nullable
    private static String getChildAttribute(@NotNull Element parent, @NotNull String childName, @NotNull String attributeName) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/tasks/jira/soap/JiraSoapTask", "getChildAttribute"));
        }
        if (childName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childName", "com/intellij/tasks/jira/soap/JiraSoapTask", "getChildAttribute"));
        }
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "com/intellij/tasks/jira/soap/JiraSoapTask", "getChildAttribute"));
        }
        Element child = parent.getChild(childName);
        if (child == null) {
            return null;
        }
        return child.getAttributeValue(attributeName);
    }
}

