/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.res2.MergeConsumer;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.ResourceUrl;
import com.android.ide.common.resources.configuration.Configurable;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.ResourceType;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilderFactory;

public abstract class AbstractResourceRepository {
    private final boolean mFramework;
    protected static final Object ITEM_MAP_LOCK = new Object();

    public AbstractResourceRepository(boolean isFramework) {
        this.mFramework = isFramework;
    }

    public boolean isFramework() {
        return this.mFramework;
    }

    public MergeConsumer<ResourceItem> createMergeConsumer() {
        return new RepositoryMerger();
    }

    protected abstract Map<ResourceType, ListMultimap<String, ResourceItem>> getMap();

    protected abstract ListMultimap<String, ResourceItem> getMap(ResourceType var1, boolean var2);

    protected ListMultimap<String, ResourceItem> getMap(ResourceType type) {
        return this.getMap(type, true);
    }

    public Map<ResourceType, ListMultimap<String, ResourceItem>> getItems() {
        return this.getMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResourceItem> getResourceItem(ResourceType resourceType, String resourceName) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            ListMultimap<String, ResourceItem> map = this.getMap(resourceType, false);
            if (map != null) {
                return map.get((Object)resourceName);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getItemsOfType(ResourceType type) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            ListMultimap<String, ResourceItem> map = this.getMap(type, false);
            if (map == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableCollection(map.keySet());
        }
    }

    public boolean hasResourceItem(String url) {
        if (url.startsWith("?")) {
            String remainder = url.substring("?".length());
            if (url.startsWith("?attr/")) {
                url = "@" + url.substring("?".length());
                return this.hasResourceItem(url);
            }
            int colon = url.indexOf(58);
            if (colon != -1) {
                if (remainder.indexOf(47, colon) == -1) {
                    remainder = remainder.substring(0, colon) + "attr" + '/' + remainder.substring(colon);
                }
                url = "@" + remainder;
                return this.hasResourceItem(url);
            }
            int slash = url.indexOf(47);
            if (slash == -1) {
                url = "@attr/" + remainder;
                return this.hasResourceItem(url);
            }
        }
        if (!url.startsWith("@")) {
            return false;
        }
        assert (url.startsWith("@") || url.startsWith("?")) : url;
        int typeEnd = url.indexOf(47, 1);
        if (typeEnd != -1) {
            String typeName;
            ResourceType type;
            int nameBegin = typeEnd + 1;
            int typeBegin = url.startsWith("@+") ? 2 : 1;
            int colon = url.lastIndexOf(58, typeEnd);
            if (colon != -1) {
                typeBegin = colon + 1;
            }
            if ((type = ResourceType.getEnum((String)(typeName = url.substring(typeBegin, typeEnd)))) != null) {
                String name = url.substring(nameBegin);
                return this.hasResourceItem(type, name);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasResourceItem(ResourceType resourceType, String resourceName) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            ListMultimap<String, ResourceItem> map = this.getMap(resourceType, false);
            if (map != null) {
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl6 : MonitorExitStatement: MONITOREXIT : var3_3
                List itemList = map.get((Object)resourceName);
                return itemList != null && !itemList.isEmpty();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasResourcesOfType(ResourceType resourceType) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            ListMultimap<String, ResourceItem> map = this.getMap(resourceType, false);
            return map != null && !map.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResourceType> getAvailableResourceTypes() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return Lists.newArrayList(this.getMap().keySet());
        }
    }

    public ResourceFile getMatchingFile(String name, ResourceType type, FolderConfiguration config) {
        List<ResourceFile> matchingFiles = this.getMatchingFiles(name, type, config);
        return matchingFiles.isEmpty() ? null : matchingFiles.get(0);
    }

    public List<ResourceFile> getMatchingFiles(String name, ResourceType type, FolderConfiguration config) {
        return this.getMatchingFiles(name, type, config, new HashSet<String>(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ResourceFile> getMatchingFiles(String name, ResourceType type, FolderConfiguration config, Set<String> seenNames, int depth) {
        ArrayList<ResourceFile> output;
        assert (!seenNames.contains(name));
        if (depth >= 50) {
            return Collections.emptyList();
        }
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            ListMultimap<String, ResourceItem> typeItems = this.getMap(type, false);
            if (typeItems == null) {
                return Collections.emptyList();
            }
            seenNames.add(name);
            output = new ArrayList<ResourceFile>();
            List matchingItems = typeItems.get((Object)name);
            List<Configurable> matches = config.findMatchingConfigurables(matchingItems);
            for (Configurable conf : matches) {
                ResourceUrl url;
                String value;
                ResourceItem match = (ResourceItem)conf;
                ResourceValue resourceValue = match.getResourceValue(this.isFramework());
                if (resourceValue != null && (value = resourceValue.getValue()) != null && value.startsWith("@") && (url = ResourceUrl.parse(value)) != null && url.type == type && url.framework == this.isFramework()) {
                    if (seenNames.contains(url.name)) continue;
                    output.addAll(this.getMatchingFiles(url.name, type, config, seenNames, depth + 1));
                    continue;
                }
                output.add((ResourceFile)match.getSource());
            }
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ResourceType, Map<String, ResourceValue>> getConfiguredResources(FolderConfiguration referenceConfig) {
        EnumMap map = Maps.newEnumMap(ResourceType.class);
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            Map<ResourceType, ListMultimap<String, ResourceItem>> itemMap = this.getMap();
            for (ResourceType key : ResourceType.values()) {
                map.put(key, this.getConfiguredResources(itemMap, key, referenceConfig));
            }
        }
        return map;
    }

    public Map<String, ResourceValue> getConfiguredResources(ResourceType type, FolderConfiguration referenceConfig) {
        return this.getConfiguredResources(this.getMap(), type, referenceConfig);
    }

    public Map<String, ResourceValue> getConfiguredResources(Map<ResourceType, ListMultimap<String, ResourceItem>> itemMap, ResourceType type, FolderConfiguration referenceConfig) {
        ListMultimap<String, ResourceItem> items = itemMap.get(type);
        if (items == null) {
            return Maps.newHashMap();
        }
        Set keys = items.keySet();
        HashMap map = Maps.newHashMapWithExpectedSize((int)keys.size());
        for (String key : keys) {
            ResourceValue value;
            List keyItems = items.get((Object)key);
            ResourceItem match = (ResourceItem)referenceConfig.findMatchingConfigurable(keyItems);
            if (match == null || (value = match.getResourceValue(this.mFramework)) == null) continue;
            map.put(match.getName(), value);
        }
        return map;
    }

    public ResourceValue getConfiguredValue(ResourceType type, String name, FolderConfiguration referenceConfig) {
        ListMultimap<String, ResourceItem> items = this.getMap(type, false);
        if (items == null) {
            return null;
        }
        List keyItems = items.get((Object)name);
        if (keyItems == null) {
            return null;
        }
        ResourceItem match = (ResourceItem)referenceConfig.findMatchingConfigurable(keyItems);
        return match != null ? match.getResourceValue(this.mFramework) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addItem(ResourceItem item) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            ListMultimap<String, ResourceItem> map = this.getMap(item.getType());
            if (!map.containsValue((Object)item)) {
                map.put((Object)item.getName(), (Object)item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeItem(ResourceItem removedItem) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            ListMultimap<String, ResourceItem> map = this.getMap(removedItem.getType(), false);
            if (map != null) {
                map.remove((Object)removedItem.getName(), (Object)removedItem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<String> getLanguages() {
        TreeSet<String> set = new TreeSet<String>();
        HashSet qualifiers = Sets.newHashSet();
        Iterator iterator = ITEM_MAP_LOCK;
        synchronized (iterator) {
            for (ListMultimap<String, ResourceItem> map : this.getMap().values()) {
                for (ResourceItem item : map.values()) {
                    qualifiers.add(item.getQualifiers());
                }
            }
        }
        for (String s : qualifiers) {
            LocaleQualifier locale;
            FolderConfiguration configuration = FolderConfiguration.getConfigForQualifierString(s);
            if (configuration == null || (locale = configuration.getLocaleQualifier()) == null) continue;
            set.add(locale.getLanguage());
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<LocaleQualifier> getLocales() {
        TreeSet<LocaleQualifier> set = new TreeSet<LocaleQualifier>();
        HashSet qualifiers = Sets.newHashSet();
        Iterator iterator = ITEM_MAP_LOCK;
        synchronized (iterator) {
            for (ListMultimap<String, ResourceItem> map : this.getMap().values()) {
                for (ResourceItem item : map.values()) {
                    qualifiers.add(item.getQualifiers());
                }
            }
        }
        for (String s : qualifiers) {
            LocaleQualifier locale;
            FolderConfiguration configuration = FolderConfiguration.getConfigForQualifierString(s);
            if (configuration == null || (locale = configuration.getLocaleQualifier()) == null) continue;
            set.add(locale);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<String> getRegions(String currentLanguage) {
        TreeSet<String> set = new TreeSet<String>();
        HashSet qualifiers = Sets.newHashSet();
        Iterator iterator = ITEM_MAP_LOCK;
        synchronized (iterator) {
            for (ListMultimap<String, ResourceItem> map : this.getMap().values()) {
                for (ResourceItem item : map.values()) {
                    qualifiers.add(item.getQualifiers());
                }
            }
        }
        for (String s : qualifiers) {
            LocaleQualifier locale;
            FolderConfiguration configuration = FolderConfiguration.getConfigForQualifierString(s);
            if (configuration == null || (locale = configuration.getLocaleQualifier()) == null || locale.getRegion() == null || !locale.getLanguage().equals(currentLanguage)) continue;
            set.add(locale.getRegion());
        }
        return set;
    }

    public void clear() {
        this.getMap().clear();
    }

    private class RepositoryMerger
    implements MergeConsumer<ResourceItem> {
        private RepositoryMerger() {
        }

        @Override
        public void start(DocumentBuilderFactory factory) throws MergeConsumer.ConsumerException {
        }

        @Override
        public void end() throws MergeConsumer.ConsumerException {
        }

        @Override
        public void addItem(ResourceItem item) throws MergeConsumer.ConsumerException {
            if (item.isTouched()) {
                AbstractResourceRepository.this.addItem(item);
            }
        }

        @Override
        public void removeItem(ResourceItem removedItem, ResourceItem replacedBy) throws MergeConsumer.ConsumerException {
            AbstractResourceRepository.this.removeItem(removedItem);
        }

        @Override
        public boolean ignoreItemInMerge(ResourceItem item) {
            return false;
        }
    }
}

