/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OutputReader
extends BaseOutputReader {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.OutputReader");
    private static final int READ_FULLY_TIMEOUT = 10;
    private final Semaphore myReadFullySemaphore;

    @Deprecated
    public OutputReader(@NotNull InputStream inputStream, @Nullable Charset charset) {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/util/io/OutputReader", "<init>"));
        }
        this(inputStream, charset, "");
    }

    @Deprecated
    public OutputReader(@NotNull InputStream inputStream, @Nullable Charset charset, @Nullable BaseDataReader.SleepingPolicy sleepingPolicy) {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/util/io/OutputReader", "<init>"));
        }
        this(inputStream, charset, sleepingPolicy, "");
    }

    public OutputReader(@NotNull InputStream inputStream, @Nullable Charset charset, @NotNull String presentableName) {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/util/io/OutputReader", "<init>"));
        }
        if (presentableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "com/intellij/util/io/OutputReader", "<init>"));
        }
        super(inputStream, charset);
        this.myReadFullySemaphore = new Semaphore();
        this.start(presentableName);
    }

    public OutputReader(@NotNull InputStream inputStream, @Nullable Charset charset, @Nullable BaseDataReader.SleepingPolicy sleepingPolicy, @NotNull String presentableName) {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/util/io/OutputReader", "<init>"));
        }
        if (presentableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "com/intellij/util/io/OutputReader", "<init>"));
        }
        super(inputStream, charset, sleepingPolicy);
        this.myReadFullySemaphore = new Semaphore();
        this.start(presentableName);
    }

    @Deprecated
    public OutputReader(@NotNull Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/util/io/OutputReader", "<init>"));
        }
        super(reader);
        this.myReadFullySemaphore = new Semaphore();
        this.start("");
    }

    @Override
    protected void doRun() {
        try {
            while (true) {
                boolean read;
                if (!(read = this.readAvailable())) {
                    this.myReadFullySemaphore.up();
                }
                if (this.isStopped) {
                    break;
                }
                TimeoutUtil.sleep(this.mySleepingPolicy.getTimeToSleep(read));
            }
        }
        catch (IOException e) {
            LOG.info(e);
        }
        catch (Exception e) {
            LOG.error(e);
        }
        finally {
            try {
                this.myReader.close();
            }
            catch (IOException e) {
                LOG.warn("Can't close reader", e);
            }
        }
    }

    @Override
    protected void onBufferExhaustion() {
        if (this.mySleepingPolicy == BaseDataReader.SleepingPolicy.BLOCKING) {
            this.myReadFullySemaphore.up();
        }
    }

    public void readFully() throws InterruptedException {
        if (this.mySleepingPolicy != BaseDataReader.SleepingPolicy.BLOCKING) {
            this.myReadFullySemaphore.down();
            while (!this.myReadFullySemaphore.waitForUnsafe(10L)) {
                if (!this.isStopped) continue;
                this.waitFor();
                return;
            }
        } else {
            do {
                this.myReadFullySemaphore.down();
            } while (this.myReadFullySemaphore.waitForUnsafe(10L));
            this.myReadFullySemaphore.up();
            if (this.isStopped) {
                this.waitFor();
            }
        }
    }
}

