/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command;

import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.file.AbstractFileObject;
import org.netbeans.lib.cvsclient.file.DirectoryObject;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.util.BugLog;

final class CvsFile {
    private final AbstractFileObject fileObject;
    private final Entry entry;
    private final boolean directory;
    private final boolean exists;

    public static CvsFile createCvsFileForEntry(FileObject fileObject, Entry entry, boolean exists) {
        BugLog.getInstance().assertNotNull(fileObject);
        BugLog.getInstance().assertNotNull(entry);
        return new CvsFile(fileObject, exists, entry, false);
    }

    public static CvsFile createCvsFileForExistingFile(FileObject fileObject) {
        BugLog.getInstance().assertNotNull(fileObject);
        return new CvsFile(fileObject, true, null, false);
    }

    public static CvsFile createCvsDirectory(DirectoryObject directoryObject) {
        BugLog.getInstance().assertNotNull(directoryObject);
        return new CvsFile(directoryObject, true, null, true);
    }

    private CvsFile(AbstractFileObject fileObject, boolean exists, Entry entry, boolean directory) {
        BugLog.getInstance().assertNotNull(fileObject);
        this.fileObject = fileObject;
        this.exists = exists;
        this.entry = entry;
        this.directory = directory;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public Entry getEntry() {
        return this.entry;
    }

    public AbstractFileObject getFileObject() {
        return this.fileObject;
    }

    public boolean exists() {
        return this.exists;
    }

    public String toString() {
        return "fileObject='" + this.fileObject + "', entry=" + (this.entry != null ? "'" + this.entry + "'" : null);
    }
}

