/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateMethodFromUsageFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesProvider;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

public class CreateGetterFromUsageFix
extends CreateMethodFromUsageFix
implements LowPriorityAction {
    public CreateGetterFromUsageFix(@NotNull GrReferenceExpression refExpression, @NotNull PsiClass targetClass) {
        if (refExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refExpression", "org/jetbrains/plugins/groovy/annotator/intentions/CreateGetterFromUsageFix", "<init>"));
        }
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "org/jetbrains/plugins/groovy/annotator/intentions/CreateGetterFromUsageFix", "<init>"));
        }
        super(refExpression);
    }

    @Override
    @NotNull
    protected TypeConstraint[] getReturnTypeConstraints() {
        TypeConstraint[] typeConstraintArray = GroovyExpectedTypesProvider.calculateTypeConstraints(this.getRefExpr());
        if (typeConstraintArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/CreateGetterFromUsageFix", "getReturnTypeConstraints"));
        }
        return typeConstraintArray;
    }

    @Override
    protected PsiType[] getArgumentTypes() {
        return PsiType.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    protected String getMethodName() {
        String string = GroovyPropertyUtils.getGetterNameNonBoolean(this.getRefExpr().getReferenceName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/CreateGetterFromUsageFix", "getMethodName"));
        }
        return string;
    }
}

