/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.griffon;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.checkers.CustomAnnotationChecker;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public class GriffonPropertyListenerAnnotationChecker
extends CustomAnnotationChecker {
    @Override
    public boolean checkArgumentList(@NotNull AnnotationHolder holder, @NotNull GrAnnotation annotation) {
        PsiElement resolved;
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/groovy/griffon/GriffonPropertyListenerAnnotationChecker", "checkArgumentList"));
        }
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/griffon/GriffonPropertyListenerAnnotationChecker", "checkArgumentList"));
        }
        if (!"griffon.transform.PropertyListener".equals(annotation.getQualifiedName())) {
            return false;
        }
        GrAnnotationNameValuePair[] attributes = annotation.getParameterList().getAttributes();
        if (attributes.length != 1) {
            return false;
        }
        GrAnnotationNameValuePair attribute = attributes[0];
        GrAnnotationMemberValue value = attribute.getValue();
        PsiAnnotationOwner owner = annotation.getOwner();
        if (owner instanceof GrField) {
            if (value instanceof GrClosableBlock) {
                return true;
            }
        } else if (owner instanceof GrTypeDefinition && value instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)value).resolve()) instanceof GrField) {
            PsiClass containingClass = ((GrField)resolved).getContainingClass();
            if (annotation.getManager().areElementsEquivalent((PsiElement)owner, (PsiElement)containingClass)) {
                return true;
            }
        }
        return false;
    }
}

