/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.control.SplitElseIfPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;

public class SplitElseIfIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        SplitElseIfPredicate splitElseIfPredicate = new SplitElseIfPredicate();
        if (splitElseIfPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/control/SplitElseIfIntention", "getElementPredicate"));
        }
        return splitElseIfPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/control/SplitElseIfIntention", "processIntention"));
        }
        GrIfStatement parentStatement = (GrIfStatement)element;
        GrStatement elseBranch = parentStatement.getElseBranch();
        GrIfStatement ifStatement = (GrIfStatement)parentStatement.copy();
        GrBlockStatement blockStatement = GroovyPsiElementFactory.getInstance(project).createBlockStatementFromText("{\nabc()\n}", null);
        GrBlockStatement newBlock = ifStatement.replaceElseBranch(blockStatement);
        newBlock.getBlock().getStatements()[0].replace(elseBranch);
        parentStatement.replaceWithStatement(ifStatement);
    }
}

