/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.typeDefinitions;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.Separators;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.typeDefinitions.ClassType;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.typeDefinitions.ReferenceElement;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.typeDefinitions.members.EnumConstant;
import org.jetbrains.plugins.groovy.lang.parser.parsing.types.TypeParameters;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class TypeDefinition {
    public static IElementType parseAfterModifiers(PsiBuilder builder, GroovyParser parser) {
        if (builder.getTokenType() == GroovyTokenTypes.kCLASS) {
            builder.advanceLexer();
            if (TypeDefinition.parseAfterKeyword(builder, parser, ClassType.CLASS)) {
                return GroovyElementTypes.CLASS_DEFINITION;
            }
        }
        if (builder.getTokenType() == GroovyTokenTypes.kINTERFACE) {
            builder.advanceLexer();
            if (TypeDefinition.parseAfterKeyword(builder, parser, ClassType.INTERFACE)) {
                return GroovyElementTypes.INTERFACE_DEFINITION;
            }
        }
        if (builder.getTokenType() == GroovyTokenTypes.kENUM) {
            builder.advanceLexer();
            if (TypeDefinition.parseAfterKeyword(builder, parser, ClassType.ENUM)) {
                return GroovyElementTypes.ENUM_DEFINITION;
            }
        }
        if (builder.getTokenType() == GroovyTokenTypes.kTRAIT) {
            builder.advanceLexer();
            if (TypeDefinition.parseAfterKeyword(builder, parser, ClassType.TRAIT)) {
                return GroovyElementTypes.TRAIT_DEFINITION;
            }
        }
        if (builder.getTokenType() == GroovyTokenTypes.mAT) {
            builder.advanceLexer();
            if (builder.getTokenType() == GroovyTokenTypes.kINTERFACE) {
                builder.advanceLexer();
                if (TypeDefinition.parseAfterKeyword(builder, parser, ClassType.ANNOTATION)) {
                    return GroovyElementTypes.ANNOTATION_DEFINITION;
                }
            }
        }
        return GroovyElementTypes.WRONGWAY;
    }

    private static boolean parseAfterKeyword(PsiBuilder builder, GroovyParser parser, ClassType type) {
        if (builder.getTokenType() != GroovyTokenTypes.mIDENT) {
            builder.error(GroovyBundle.message("identifier.expected", new Object[0]));
            return false;
        }
        String name = builder.getTokenText();
        assert (name != null);
        builder.advanceLexer();
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        TypeParameters.parse(builder);
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        ReferenceElement.parseReferenceList(builder, GroovyTokenTypes.kEXTENDS, GroovyElementTypes.EXTENDS_CLAUSE, type);
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        ReferenceElement.parseReferenceList(builder, GroovyTokenTypes.kIMPLEMENTS, GroovyElementTypes.IMPLEMENTS_CLAUSE, type);
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        if (builder.getTokenType() == GroovyTokenTypes.mLCURLY) {
            if (type == ClassType.ENUM) {
                TypeDefinition.parseEnumBody(builder, name, parser);
            } else {
                TypeDefinition.parseBody(builder, name, parser, type == ClassType.ANNOTATION);
            }
        } else {
            builder.error(GroovyBundle.message("lcurly.expected", new Object[0]));
        }
        return true;
    }

    public static IElementType parseBody(@NotNull PsiBuilder builder, @Nullable String className, @NotNull GroovyParser parser, boolean isInAnnotation) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/TypeDefinition", "parseBody"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/TypeDefinition", "parseBody"));
        }
        PsiBuilder.Marker cbMarker = builder.mark();
        if (!ParserUtils.getToken(builder, GroovyTokenTypes.mLCURLY)) {
            builder.error(GroovyBundle.message("lcurly.expected", new Object[0]));
            cbMarker.rollbackTo();
            return GroovyElementTypes.WRONGWAY;
        }
        TypeDefinition.parseMembers(builder, className, parser, isInAnnotation);
        ParserUtils.getToken(builder, GroovyTokenTypes.mRCURLY, GroovyBundle.message("rcurly.expected", new Object[0]));
        cbMarker.done(GroovyElementTypes.CLASS_BODY);
        return GroovyElementTypes.CLASS_BODY;
    }

    private static void parseMembers(@NotNull PsiBuilder builder, @Nullable String className, @NotNull GroovyParser parser, boolean isInAnnotation) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/TypeDefinition", "parseMembers"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/TypeDefinition", "parseMembers"));
        }
        Separators.parse(builder);
        while (!builder.eof() && builder.getTokenType() != GroovyTokenTypes.mRCURLY) {
            if (!parser.parseDeclaration(builder, true, isInAnnotation, className)) {
                builder.advanceLexer();
                builder.error(GroovyBundle.message("separator.or.rcurly.expected", new Object[0]));
            }
            if (builder.getTokenType() == GroovyTokenTypes.mRCURLY) break;
            if (Separators.parse(builder)) continue;
            builder.error(GroovyBundle.message("separator.or.rcurly.expected", new Object[0]));
        }
    }

    private static IElementType parseEnumBody(@NotNull PsiBuilder builder, @NotNull String enumName, @NotNull GroovyParser parser) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/TypeDefinition", "parseEnumBody"));
        }
        if (enumName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumName", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/TypeDefinition", "parseEnumBody"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/TypeDefinition", "parseEnumBody"));
        }
        PsiBuilder.Marker ebMarker = builder.mark();
        if (!ParserUtils.getToken(builder, GroovyTokenTypes.mLCURLY)) {
            ebMarker.rollbackTo();
            return GroovyElementTypes.WRONGWAY;
        }
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        if (EnumConstant.parseConstantList(builder, parser) && !ParserUtils.lookAhead(builder, GroovyTokenTypes.mRCURLY)) {
            ParserUtils.getToken(builder, TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mNLS, GroovyTokenTypes.mSEMI}), GroovyBundle.message("separator.or.rcurly.expected", new Object[0]));
        }
        TypeDefinition.parseMembers(builder, enumName, parser, false);
        ParserUtils.getToken(builder, GroovyTokenTypes.mRCURLY, GroovyBundle.message("rcurly.expected", new Object[0]));
        ebMarker.done(GroovyElementTypes.ENUM_BODY);
        return GroovyElementTypes.ENUM_BODY;
    }
}

