/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.annotation;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.light.LightClassReference;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairFunction;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrAnnotationStub;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GrAnnotationImpl
extends GrStubElementBase<GrAnnotationStub>
implements GrAnnotation,
StubBasedPsiElement<GrAnnotationStub> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.annotation.GrAnnotationImpl");
    private static final PairFunction<Project, String, PsiAnnotation> ANNOTATION_CREATOR = new PairFunction<Project, String, PsiAnnotation>(){

        public PsiAnnotation fun(Project project, String text) {
            return GroovyPsiElementFactory.getInstance(project).createAnnotationFromText(text);
        }
    };

    public GrAnnotationImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationImpl", "<init>"));
        }
        super(node);
    }

    public GrAnnotationImpl(GrAnnotationStub stub) {
        super(stub, GroovyElementTypes.ANNOTATION);
    }

    @Override
    public PsiElement getParent() {
        return this.getParentByStub();
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitAnnotation(this);
    }

    public String toString() {
        return "Annotation";
    }

    @Override
    @NotNull
    public GrAnnotationArgumentList getParameterList() {
        GrAnnotationArgumentList grAnnotationArgumentList = (GrAnnotationArgumentList)this.findNotNullChildByClass(GrAnnotationArgumentList.class);
        if (grAnnotationArgumentList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationImpl", "getParameterList"));
        }
        return grAnnotationArgumentList;
    }

    @Nullable
    @NonNls
    public String getQualifiedName() {
        GrAnnotationStub stub = (GrAnnotationStub)this.getStub();
        if (stub != null) {
            return stub.getPsiElement().getQualifiedName();
        }
        GrCodeReferenceElement nameRef = this.getClassReference();
        PsiElement resolved = nameRef.resolve();
        if (resolved instanceof PsiClass) {
            return ((PsiClass)resolved).getQualifiedName();
        }
        return null;
    }

    @Nullable
    public PsiJavaCodeReferenceElement getNameReferenceElement() {
        GroovyResolveResult resolveResult = this.resolveWithStub();
        PsiElement resolved = resolveResult.getElement();
        if (!(resolved instanceof PsiClass)) {
            return null;
        }
        return new LightClassReference((PsiManager)this.getManager(), this.getClassReference().getText(), (PsiClass)resolved, resolveResult.getSubstitutor());
    }

    @NotNull
    private GroovyResolveResult resolveWithStub() {
        GrAnnotationStub stub = (GrAnnotationStub)this.getStub();
        GrCodeReferenceElement reference = stub != null ? stub.getPsiElement().getClassReference() : this.getClassReference();
        GroovyResolveResult groovyResolveResult = reference.advancedResolve();
        if (groovyResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationImpl", "resolveWithStub"));
        }
        return groovyResolveResult;
    }

    @Nullable
    public PsiAnnotationMemberValue findAttributeValue(@Nullable String attributeName) {
        GrAnnotation stubbedPsi;
        PsiAnnotationMemberValue value;
        GrAnnotationStub stub = (GrAnnotationStub)this.getStub();
        if (!(stub == null || (value = PsiImplUtil.findAttributeValue((PsiAnnotation)(stubbedPsi = stub.getPsiElement()), (String)attributeName)) != null && PsiTreeUtil.isAncestor((PsiElement)stubbedPsi, (PsiElement)value, (boolean)true))) {
            return value;
        }
        return PsiImplUtil.findAttributeValue((PsiAnnotation)this, (String)attributeName);
    }

    @Nullable
    public PsiAnnotationMemberValue findDeclaredAttributeValue(@NonNls String attributeName) {
        GrAnnotation stubbedPsi;
        PsiAnnotationMemberValue value;
        GrAnnotationStub stub = (GrAnnotationStub)this.getStub();
        if (stub != null && (value = PsiImplUtil.findDeclaredAttributeValue((PsiAnnotation)(stubbedPsi = stub.getPsiElement()), (String)attributeName)) == null) {
            return null;
        }
        return PsiImplUtil.findDeclaredAttributeValue((PsiAnnotation)this, (String)attributeName);
    }

    public <T extends PsiAnnotationMemberValue> T setDeclaredAttributeValue(@Nullable @NonNls String attributeName, T value) {
        return (T)PsiImplUtil.setDeclaredAttributeValue((PsiAnnotation)this, (String)attributeName, value, ANNOTATION_CREATOR);
    }

    @Nullable
    public PsiMetaData getMetaData() {
        return null;
    }

    @Override
    @NotNull
    public GrCodeReferenceElement getClassReference() {
        GrAnnotationStub stub = (GrAnnotationStub)this.getStub();
        if (stub != null) {
            GrCodeReferenceElement grCodeReferenceElement = stub.getPsiElement().getClassReference();
            if (grCodeReferenceElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationImpl", "getClassReference"));
            }
            return grCodeReferenceElement;
        }
        GrCodeReferenceElement grCodeReferenceElement = (GrCodeReferenceElement)this.findNotNullChildByClass(GrCodeReferenceElement.class);
        if (grCodeReferenceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationImpl", "getClassReference"));
        }
        return grCodeReferenceElement;
    }

    @Override
    @NotNull
    public String getShortName() {
        GrAnnotationStub stub = (GrAnnotationStub)this.getStub();
        if (stub != null) {
            String string = stub.getPsiElement().getShortName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationImpl", "getShortName"));
            }
            return string;
        }
        String referenceName = this.getClassReference().getReferenceName();
        assert (referenceName != null);
        String string = referenceName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationImpl", "getShortName"));
        }
        return string;
    }

    @Nullable
    public PsiAnnotationOwner getOwner() {
        PsiElement parent = this.getParent();
        return parent instanceof PsiAnnotationOwner ? (PsiAnnotationOwner)parent : null;
    }

    @NotNull
    public static PsiAnnotation.TargetType[] getApplicableElementTypeFields(PsiElement owner) {
        if (owner instanceof PsiClass) {
            PsiClass aClass = (PsiClass)owner;
            if (aClass.isAnnotationType()) {
                PsiAnnotation.TargetType[] targetTypeArray = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.ANNOTATION_TYPE, PsiAnnotation.TargetType.TYPE};
                if (targetTypeArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationImpl", "getApplicableElementTypeFields"));
                }
                return targetTypeArray;
            }
            if (aClass instanceof GrTypeParameter) {
                PsiAnnotation.TargetType[] targetTypeArray = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE_PARAMETER};
                if (targetTypeArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationImpl", "getApplicableElementTypeFields"));
                }
                return targetTypeArray;
            }
            PsiAnnotation.TargetType[] targetTypeArray = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE};
            if (targetTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationImpl", "getApplicableElementTypeFields"));
            }
            return targetTypeArray;
        }
        if (owner instanceof GrMethod) {
            if (((PsiMethod)owner).isConstructor()) {
                PsiAnnotation.TargetType[] targetTypeArray = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.CONSTRUCTOR};
                if (targetTypeArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationImpl", "getApplicableElementTypeFields"));
                }
                return targetTypeArray;
            }
            PsiAnnotation.TargetType[] targetTypeArray = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.METHOD};
            if (targetTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationImpl", "getApplicableElementTypeFields"));
            }
            return targetTypeArray;
        }
        if (owner instanceof GrVariableDeclaration) {
            GrVariable[] variables = ((GrVariableDeclaration)owner).getVariables();
            if (variables.length == 0) {
                if (PsiAnnotation.TargetType.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationImpl", "getApplicableElementTypeFields"));
                }
                return PsiAnnotation.TargetType.EMPTY_ARRAY;
            }
            if (variables[0] instanceof GrField || ResolveUtil.isScriptField(variables[0])) {
                PsiAnnotation.TargetType[] targetTypeArray = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.FIELD};
                if (targetTypeArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationImpl", "getApplicableElementTypeFields"));
                }
                return targetTypeArray;
            }
            PsiAnnotation.TargetType[] targetTypeArray = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.LOCAL_VARIABLE};
            if (targetTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationImpl", "getApplicableElementTypeFields"));
            }
            return targetTypeArray;
        }
        if (owner instanceof GrParameter) {
            PsiAnnotation.TargetType[] targetTypeArray = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.PARAMETER};
            if (targetTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationImpl", "getApplicableElementTypeFields"));
            }
            return targetTypeArray;
        }
        if (owner instanceof GrPackageDefinition) {
            PsiAnnotation.TargetType[] targetTypeArray = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.PACKAGE};
            if (targetTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationImpl", "getApplicableElementTypeFields"));
            }
            return targetTypeArray;
        }
        if (owner instanceof GrTypeElement) {
            PsiAnnotation.TargetType[] targetTypeArray = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE_USE};
            if (targetTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationImpl", "getApplicableElementTypeFields"));
            }
            return targetTypeArray;
        }
        if (PsiAnnotation.TargetType.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationImpl", "getApplicableElementTypeFields"));
        }
        return PsiAnnotation.TargetType.EMPTY_ARRAY;
    }

    public static boolean isAnnotationApplicableTo(GrAnnotation annotation, PsiAnnotation.TargetType ... elementTypeFields) {
        if (elementTypeFields == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementTypeFields", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationImpl", "isAnnotationApplicableTo"));
        }
        return elementTypeFields.length == 0 || AnnotationTargetUtil.findAnnotationTarget((PsiAnnotation)annotation, (PsiAnnotation.TargetType[])elementTypeFields) != null;
    }
}

