/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.stubs;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.indexing.IdFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAnnotationMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.search.GrSourceFilterScope;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnnotationMethodNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrFieldNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrFullClassNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrFullScriptNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrMethodNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrScriptClassNameIndex;

public class GroovyShortNamesCache
extends PsiShortNamesCache {
    private final Project myProject;

    public GroovyShortNamesCache(Project project) {
        this.myProject = project;
    }

    public static GroovyShortNamesCache getGroovyShortNamesCache(Project project) {
        return (GroovyShortNamesCache)((Object)ObjectUtils.assertNotNull((Object)ContainerUtil.findInstance((Object[])project.getExtensions(PsiShortNamesCache.EP_NAME), GroovyShortNamesCache.class)));
    }

    @NotNull
    public PsiClass[] getClassesByName(@NotNull @NonNls String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "getClassesByName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "getClassesByName"));
        }
        SmartList allClasses = new SmartList();
        this.processClassesWithName(name, (Processor<? super PsiClass>)new CommonProcessors.CollectProcessor((Collection)allClasses), scope, null);
        if (allClasses.isEmpty()) {
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "getClassesByName"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClass[] psiClassArray = allClasses.toArray(new PsiClass[allClasses.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "getClassesByName"));
        }
        return psiClassArray;
    }

    public List<PsiClass> getScriptClassesByFQName(String name, GlobalSearchScope scope, boolean srcOnly) {
        Object actualScope = srcOnly ? new GrSourceFilterScope(scope) : scope;
        Collection files = StubIndex.getElements(GrFullScriptNameIndex.KEY, (Object)name.hashCode(), (Project)this.myProject, (GlobalSearchScope)actualScope, GroovyFile.class);
        if (files.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        for (GroovyFile file : files) {
            PsiClass scriptClass;
            if (!file.isScript() || (scriptClass = file.getScriptClass()) == null || !name.equals(scriptClass.getQualifiedName())) continue;
            result.add(scriptClass);
        }
        return result;
    }

    @NotNull
    public List<PsiClass> getClassesByFQName(String name, GlobalSearchScope scope, boolean inSource) {
        ArrayList result = ContainerUtil.newArrayList();
        for (PsiElement psiClass : StubIndex.getElements(GrFullClassNameIndex.KEY, (Object)name.hashCode(), (Project)this.myProject, (GlobalSearchScope)(inSource ? new GrSourceFilterScope(scope) : scope), PsiClass.class)) {
            if (!name.equals(((PsiClass)psiClass).getQualifiedName())) continue;
            result.add((PsiClass)psiClass);
        }
        result.addAll(this.getScriptClassesByFQName(name, scope, inSource));
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "getClassesByFQName"));
        }
        return arrayList;
    }

    @NotNull
    public String[] getAllClassNames() {
        String[] stringArray = ArrayUtil.toStringArray((Collection)StubIndex.getInstance().getAllKeys(GrScriptClassNameIndex.KEY, this.myProject));
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "getAllClassNames"));
        }
        return stringArray;
    }

    public void getAllClassNames(@NotNull HashSet<String> dest) {
        if (dest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dest", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "getAllClassNames"));
        }
        dest.addAll(StubIndex.getInstance().getAllKeys(GrScriptClassNameIndex.KEY, this.myProject));
    }

    @NotNull
    public PsiMethod[] getMethodsByName(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "getMethodsByName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "getMethodsByName"));
        }
        Collection methods = StubIndex.getElements(GrMethodNameIndex.KEY, (Object)name, (Project)this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope), GrMethod.class);
        Collection annMethods = StubIndex.getElements(GrAnnotationMethodNameIndex.KEY, (Object)name, (Project)this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope), GrAnnotationMethod.class);
        if (methods.isEmpty() && annMethods.isEmpty()) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "getMethodsByName"));
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        PsiMethod[] psiMethodArray = (PsiMethod[])ArrayUtil.mergeCollections((Collection)annMethods, (Collection)methods, (ArrayFactory)PsiMethod.ARRAY_FACTORY);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "getMethodsByName"));
        }
        return psiMethodArray;
    }

    public boolean processMethodsWithName(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiMethod> processor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "processMethodsWithName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "processMethodsWithName"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "processMethodsWithName"));
        }
        return this.processMethodsWithName(name, processor, scope, null);
    }

    public boolean processMethodsWithName(@NonNls @NotNull String name, @NotNull Processor<? super PsiMethod> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "processMethodsWithName"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "processMethodsWithName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "processMethodsWithName"));
        }
        GrSourceFilterScope filterScope = new GrSourceFilterScope(scope);
        return StubIndex.getInstance().processElements(GrMethodNameIndex.KEY, (Object)name, this.myProject, (GlobalSearchScope)filterScope, filter, GrMethod.class, processor) && StubIndex.getInstance().processElements(GrAnnotationMethodNameIndex.KEY, (Object)name, this.myProject, (GlobalSearchScope)filterScope, filter, GrAnnotationMethod.class, processor);
    }

    @NotNull
    public PsiMethod[] getMethodsByNameIfNotMoreThan(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "getMethodsByNameIfNotMoreThan"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "getMethodsByNameIfNotMoreThan"));
        }
        PsiMethod[] psiMethodArray = this.getMethodsByName(name, scope);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "getMethodsByNameIfNotMoreThan"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiField[] getFieldsByNameIfNotMoreThan(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "getFieldsByNameIfNotMoreThan"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "getFieldsByNameIfNotMoreThan"));
        }
        PsiField[] psiFieldArray = this.getFieldsByName(name, scope);
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "getFieldsByNameIfNotMoreThan"));
        }
        return psiFieldArray;
    }

    @NotNull
    public String[] getAllMethodNames() {
        Collection keys = StubIndex.getInstance().getAllKeys(GrMethodNameIndex.KEY, this.myProject);
        keys.addAll(StubIndex.getInstance().getAllKeys(GrAnnotationMethodNameIndex.KEY, this.myProject));
        String[] stringArray = ArrayUtil.toStringArray((Collection)keys);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "getAllMethodNames"));
        }
        return stringArray;
    }

    public void getAllMethodNames(@NotNull HashSet<String> set) {
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "getAllMethodNames"));
        }
        set.addAll(StubIndex.getInstance().getAllKeys(GrMethodNameIndex.KEY, this.myProject));
    }

    @NotNull
    public PsiField[] getFieldsByName(@NotNull @NonNls String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "getFieldsByName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "getFieldsByName"));
        }
        Collection fields = StubIndex.getElements(GrFieldNameIndex.KEY, (Object)name, (Project)this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope), GrField.class);
        if (fields.isEmpty()) {
            if (PsiField.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "getFieldsByName"));
            }
            return PsiField.EMPTY_ARRAY;
        }
        PsiField[] psiFieldArray = fields.toArray(new PsiField[fields.size()]);
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "getFieldsByName"));
        }
        return psiFieldArray;
    }

    @NotNull
    public String[] getAllFieldNames() {
        Collection fields = StubIndex.getInstance().getAllKeys(GrFieldNameIndex.KEY, this.myProject);
        String[] stringArray = ArrayUtil.toStringArray((Collection)fields);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "getAllFieldNames"));
        }
        return stringArray;
    }

    public void getAllFieldNames(@NotNull HashSet<String> set) {
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "getAllFieldNames"));
        }
        set.addAll(StubIndex.getInstance().getAllKeys(GrFieldNameIndex.KEY, this.myProject));
    }

    public boolean processFieldsWithName(@NotNull String name, @NotNull Processor<? super PsiField> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "processFieldsWithName"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "processFieldsWithName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "processFieldsWithName"));
        }
        return StubIndex.getInstance().processElements(GrFieldNameIndex.KEY, (Object)name, this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope), filter, GrField.class, processor);
    }

    public boolean processClassesWithName(@NotNull String name, @NotNull Processor<? super PsiClass> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "processClassesWithName"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "processClassesWithName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache", "processClassesWithName"));
        }
        for (GroovyFile file : StubIndex.getElements(GrScriptClassNameIndex.KEY, (Object)name, (Project)this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope), (IdFilter)filter, GroovyFile.class)) {
            PsiClass aClass = file.getScriptClass();
            if (aClass == null || processor.process((Object)aClass)) continue;
            return true;
        }
        return true;
    }
}

