/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browserCache;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Queue;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.auth.SvnAuthenticationProvider;
import org.jetbrains.idea.svn.browse.DirectoryEntry;
import org.jetbrains.idea.svn.browse.DirectoryEntryConsumer;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.jetbrains.idea.svn.dialogs.browserCache.Expander;
import org.jetbrains.idea.svn.dialogs.browserCache.Loader;
import org.jetbrains.idea.svn.dialogs.browserCache.NodeLoadState;
import org.jetbrains.idea.svn.dialogs.browserCache.SvnRepositoryCache;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

class RepositoryLoader
extends Loader {
    @NotNull
    private final Queue<Pair<RepositoryTreeNode, Expander>> myLoadQueue;
    private boolean myQueueProcessorActive;

    RepositoryLoader(@NotNull SvnRepositoryCache cache) {
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "org/jetbrains/idea/svn/dialogs/browserCache/RepositoryLoader", "<init>"));
        }
        super(cache);
        this.myLoadQueue = ContainerUtil.newLinkedList();
        this.myQueueProcessorActive = false;
    }

    @Override
    public void load(@NotNull RepositoryTreeNode node, @NotNull Expander afterRefreshExpander) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/idea/svn/dialogs/browserCache/RepositoryLoader", "load"));
        }
        if (afterRefreshExpander == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterRefreshExpander", "org/jetbrains/idea/svn/dialogs/browserCache/RepositoryLoader", "load"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Pair data = Pair.create((Object)node, (Object)afterRefreshExpander);
        if (!this.myQueueProcessorActive) {
            this.startLoadTask((Pair<RepositoryTreeNode, Expander>)data);
            this.myQueueProcessorActive = true;
        } else {
            this.myLoadQueue.offer((Pair<RepositoryTreeNode, Expander>)data);
        }
    }

    private void setResults(@NotNull Pair<RepositoryTreeNode, Expander> data, @NotNull List<DirectoryEntry> children) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/idea/svn/dialogs/browserCache/RepositoryLoader", "setResults"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "org/jetbrains/idea/svn/dialogs/browserCache/RepositoryLoader", "setResults"));
        }
        this.myCache.put(((RepositoryTreeNode)data.first).getURL().toString(), children);
        this.refreshNode((RepositoryTreeNode)data.first, children, (Expander)data.second);
    }

    private void setError(@NotNull Pair<RepositoryTreeNode, Expander> data, @NotNull String message) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/idea/svn/dialogs/browserCache/RepositoryLoader", "setError"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/idea/svn/dialogs/browserCache/RepositoryLoader", "setError"));
        }
        this.myCache.put(((RepositoryTreeNode)data.first).getURL().toString(), message);
        this.refreshNodeError((RepositoryTreeNode)data.first, message);
    }

    private void startNext() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Pair<RepositoryTreeNode, Expander> data = this.myLoadQueue.poll();
        if (data == null) {
            this.myQueueProcessorActive = false;
            return;
        }
        if (((RepositoryTreeNode)data.first).isDisposed()) {
            this.startNext();
        } else {
            this.startLoadTask(data);
        }
    }

    private void startLoadTask(final @NotNull Pair<RepositoryTreeNode, Expander> data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/idea/svn/dialogs/browserCache/RepositoryLoader", "startLoadTask"));
        }
        final ModalityState state = ModalityState.current();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                ProgressManager.getInstance().runProcess((Runnable)new LoadTask(data), (ProgressIndicator)new EmptyProgressIndicator(){

                    @NotNull
                    public ModalityState getModalityState() {
                        ModalityState modalityState = state;
                        if (modalityState == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/browserCache/RepositoryLoader$1$1", "getModalityState"));
                        }
                        return modalityState;
                    }
                });
            }
        });
    }

    @Override
    @NotNull
    protected NodeLoadState getNodeLoadState() {
        NodeLoadState nodeLoadState = NodeLoadState.REFRESHED;
        if (nodeLoadState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/browserCache/RepositoryLoader", "getNodeLoadState"));
        }
        return nodeLoadState;
    }

    private class LoadTask
    implements Runnable {
        @NotNull
        private final Pair<RepositoryTreeNode, Expander> myData;

        private LoadTask(Pair<RepositoryTreeNode, Expander> data) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/idea/svn/dialogs/browserCache/RepositoryLoader$LoadTask", "<init>"));
            }
            this.myData = data;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            final TreeSet entries = new TreeSet();
            RepositoryTreeNode node = (RepositoryTreeNode)this.myData.first;
            SvnVcs vcs = node.getVcs();
            SvnAuthenticationProvider.forceInteractive();
            DirectoryEntryConsumer handler = new DirectoryEntryConsumer(){

                public void consume(DirectoryEntry entry) throws SVNException {
                    entries.add(entry);
                }
            };
            try {
                SvnTarget target = SvnTarget.fromURL((SVNURL)node.getURL());
                vcs.getFactoryFromSettings().createBrowseClient().list(target, SVNRevision.HEAD, Depth.IMMEDIATES, handler);
            }
            catch (VcsException e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RepositoryLoader.this.setError((Pair<RepositoryTreeNode, Expander>)LoadTask.this.myData, e.getMessage());
                        RepositoryLoader.this.startNext();
                    }
                });
                return;
            }
            finally {
                SvnAuthenticationProvider.clearInteractive();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RepositoryLoader.this.setResults((Pair<RepositoryTreeNode, Expander>)LoadTask.this.myData, ContainerUtil.newArrayList((Iterable)entries));
                    RepositoryLoader.this.startNext();
                }
            });
        }
    }
}

