/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.util.containers.ContainerUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.history.LogEntryPath;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;

public class LogEntry {
    public static final LogEntry EMPTY = new Builder().setRevision(-1L).setHasChildren(false).build();
    private final long myRevision;
    @Nullable
    private final Date myDate;
    private final String myMessage;
    private final String myAuthor;
    @NotNull
    private final Map<String, LogEntryPath> myChangedPaths;
    private boolean myHasChildren;

    @Nullable
    public static LogEntry create(@Nullable SVNLogEntry entry) {
        LogEntry result = null;
        if (entry != null) {
            Builder builder = new Builder();
            if (entry.getChangedPaths() != null) {
                for (SVNLogEntryPath path : entry.getChangedPaths().values()) {
                    builder.addPath(LogEntryPath.create(path));
                }
            }
            result = builder.setRevision(entry.getRevision()).setAuthor(entry.getAuthor()).setDate(entry.getDate()).setMessage(entry.getMessage()).setHasChildren(entry.hasChildren()).build();
        }
        return result;
    }

    public LogEntry(@NotNull Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/idea/svn/history/LogEntry", "<init>"));
        }
        this.myRevision = builder.revision;
        this.myChangedPaths = LogEntry.toImmutable(builder.changedPaths);
        this.myAuthor = builder.author;
        this.myDate = builder.date;
        this.myMessage = builder.message;
        this.myHasChildren = builder.hasChildren();
    }

    @NotNull
    private static Map<String, LogEntryPath> toImmutable(@NotNull List<LogEntryPath.Builder> paths) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "org/jetbrains/idea/svn/history/LogEntry", "toImmutable"));
        }
        ContainerUtil.ImmutableMapBuilder builder = ContainerUtil.immutableMapBuilder();
        for (LogEntryPath.Builder path : paths) {
            builder.put((Object)path.getPath(), (Object)path.build());
        }
        Map map = builder.build();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/LogEntry", "toImmutable"));
        }
        return map;
    }

    @NotNull
    public Map<String, LogEntryPath> getChangedPaths() {
        Map<String, LogEntryPath> map = this.myChangedPaths;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/LogEntry", "getChangedPaths"));
        }
        return map;
    }

    public String getAuthor() {
        return this.myAuthor;
    }

    @Nullable
    public Date getDate() {
        return this.myDate;
    }

    public String getMessage() {
        return this.myMessage;
    }

    public long getRevision() {
        return this.myRevision;
    }

    public boolean hasChildren() {
        return this.myHasChildren;
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    @XmlType(name="logentry")
    public static class Builder {
        @XmlAttribute(name="revision")
        private long revision;
        @XmlElement(name="author")
        private String author;
        @XmlElement(name="date")
        private Date date;
        @XmlElement(name="msg")
        private String message;
        @XmlElementWrapper(name="paths")
        @XmlElement(name="path")
        private List<LogEntryPath.Builder> changedPaths = ContainerUtil.newArrayList();
        @XmlElement(name="logentry")
        private List<Builder> childEntries = ContainerUtil.newArrayList();

        @NotNull
        public List<Builder> getChildEntries() {
            List<Builder> list = this.childEntries;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/LogEntry$Builder", "getChildEntries"));
            }
            return list;
        }

        public boolean hasChildren() {
            return !this.childEntries.isEmpty();
        }

        @NotNull
        public Builder setRevision(long revision) {
            this.revision = revision;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/LogEntry$Builder", "setRevision"));
            }
            return builder;
        }

        @NotNull
        public Builder setAuthor(String author) {
            this.author = author;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/LogEntry$Builder", "setAuthor"));
            }
            return builder;
        }

        @NotNull
        public Builder setDate(Date date) {
            this.date = date;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/LogEntry$Builder", "setDate"));
            }
            return builder;
        }

        @NotNull
        public Builder setMessage(String message) {
            this.message = message;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/LogEntry$Builder", "setMessage"));
            }
            return builder;
        }

        @NotNull
        public Builder setHasChildren(boolean hasChildren) {
            this.childEntries.clear();
            if (hasChildren) {
                this.childEntries.add(this);
            }
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/LogEntry$Builder", "setHasChildren"));
            }
            return builder;
        }

        @NotNull
        public Builder addPath(@NotNull LogEntryPath.Builder path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/history/LogEntry$Builder", "addPath"));
            }
            this.changedPaths.add(path);
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/LogEntry$Builder", "addPath"));
            }
            return builder;
        }

        @NotNull
        public LogEntry build() {
            LogEntry logEntry = new LogEntry(this);
            if (logEntry == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/LogEntry$Builder", "build"));
            }
            return logEntry;
        }
    }
}

