/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Map;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.LogEntryConsumer;
import org.jetbrains.idea.svn.history.LogEntryPath;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class SvnPathThroughHistoryCorrection
implements LogEntryConsumer {
    private String myBefore;
    private String myPath;
    private LogEntryPath myDirectlyMentioned;
    private boolean myRoot;

    public SvnPathThroughHistoryCorrection(String path) {
        this.myPath = path;
        this.myBefore = path;
        this.myRoot = StringUtil.isEmpty((String)path);
    }

    public void consume(LogEntry logEntry) throws SVNException {
        if (this.myRoot) {
            return;
        }
        this.myBefore = this.myPath;
        this.myDirectlyMentioned = null;
        Map<String, LogEntryPath> paths = logEntry.getChangedPaths();
        LogEntryPath entryPath = paths.get(this.myPath);
        if (entryPath != null) {
            this.myDirectlyMentioned = entryPath;
            if (entryPath.getCopyPath() != null) {
                this.myPath = entryPath.getCopyPath();
                return;
            }
        }
        for (LogEntryPath path : paths.values()) {
            String thisEntryPath;
            String copyPath = path.getCopyPath();
            if (copyPath == null || !this.parentPathChanged(copyPath, thisEntryPath = path.getPath())) continue;
            return;
        }
    }

    private boolean parentPathChanged(String copyPath, String thisEntryPath) throws SVNException {
        if (SVNPathUtil.isAncestor((String)thisEntryPath, (String)this.myPath)) {
            String relativePath = SVNPathUtil.getRelativePath((String)thisEntryPath, (String)this.myPath);
            this.myPath = SvnUtil.appendMultiParts(copyPath, relativePath);
            return true;
        }
        return false;
    }

    public String getBefore() {
        return this.myBefore;
    }

    public LogEntryPath getDirectlyMentioned() {
        return this.myDirectlyMentioned;
    }

    public String getCurrentPath() {
        return this.myPath;
    }

    public boolean isRoot() {
        return this.myRoot;
    }
}

