/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.ignore;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.idea.svn.SvnStatusUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.BasicAction;
import org.jetbrains.idea.svn.ignore.FileIterationListener;

public class IgnoreGroupHelperAction
extends BasicAction {
    private boolean myAllCanBeIgnored;
    private boolean myAllAreIgnored;
    private FileIterationListener myListener;

    @Override
    protected String getActionName(AbstractVcs vcs) {
        return null;
    }

    @Override
    public void update(AnActionEvent e) {
        this.myAllAreIgnored = true;
        this.myAllCanBeIgnored = true;
        super.update(e);
    }

    public void setFileIterationListener(FileIterationListener listener) {
        this.myListener = listener;
    }

    private boolean isEnabledImpl(SvnVcs vcs, VirtualFile file) {
        VirtualFile parent;
        ChangeListManager clManager = ChangeListManager.getInstance((Project)vcs.getProject());
        if (SvnStatusUtil.isIgnoredInAnySense(clManager, file)) {
            this.myAllCanBeIgnored = false;
            return this.myAllAreIgnored | this.myAllCanBeIgnored;
        }
        if (clManager.isUnversioned(file) && (parent = file.getParent()) != null && !SvnStatusUtil.isIgnoredInAnySense(clManager, parent) && !clManager.isUnversioned(parent)) {
            this.myAllAreIgnored = false;
            return this.myAllAreIgnored | this.myAllCanBeIgnored;
        }
        this.myAllCanBeIgnored = false;
        this.myAllAreIgnored = false;
        return false;
    }

    @Override
    protected boolean isEnabled(Project project, SvnVcs vcs, VirtualFile file) {
        boolean result = this.isEnabledImpl(vcs, file);
        if (result) {
            this.myListener.onFileEnabled(file);
        }
        return result;
    }

    public boolean allCanBeIgnored() {
        return this.myAllCanBeIgnored;
    }

    public boolean allAreIgnored() {
        return this.myAllAreIgnored;
    }

    @Override
    protected boolean needsFiles() {
        return true;
    }

    @Override
    protected void perform(Project project, SvnVcs activeVcs, VirtualFile file, DataContext context) throws VcsException {
    }

    @Override
    protected void batchPerform(Project project, SvnVcs activeVcs, VirtualFile[] file, DataContext context) throws VcsException {
    }

    @Override
    protected boolean isBatchAction() {
        return false;
    }
}

