/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.info;

import java.io.File;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseNodeDescription;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.conflict.TreeConflictDescription;
import org.jetbrains.idea.svn.lock.Lock;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class Info
extends BaseNodeDescription {
    public static final String SCHEDULE_ADD = "add";
    private final File myFile;
    private final String myPath;
    private final SVNURL myURL;
    @NotNull
    private final SVNRevision myRevision;
    private final SVNURL myRepositoryRootURL;
    private final String myRepositoryUUID;
    private final SVNRevision myCommittedRevision;
    private final Date myCommittedDate;
    private final String myAuthor;
    @Nullable
    private final Lock myLock;
    private final boolean myIsRemote;
    private final String mySchedule;
    private final SVNURL myCopyFromURL;
    private final SVNRevision myCopyFromRevision;
    @Nullable
    private final File myConflictOldFile;
    @Nullable
    private final File myConflictNewFile;
    @Nullable
    private final File myConflictWrkFile;
    @Nullable
    private final File myPropConflictFile;
    private final Depth myDepth;
    @Nullable
    private final TreeConflictDescription myTreeConflict;

    @NotNull
    public static Info create(@NotNull SVNInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/info/Info", "create"));
        }
        Info result = info.isRemote() ? new Info(info.getPath(), info.getURL(), info.getRevision(), NodeKind.from(info.getKind()), info.getRepositoryUUID(), info.getRepositoryRootURL(), info.getCommittedRevision().getNumber(), info.getCommittedDate(), info.getAuthor(), Lock.create(info.getLock()), Depth.from(info.getDepth())) : new Info(info.getFile(), info.getURL(), info.getRepositoryRootURL(), info.getRevision().getNumber(), NodeKind.from(info.getKind()), info.getRepositoryUUID(), info.getCommittedRevision().getNumber(), Info.toString(info.getCommittedDate()), info.getAuthor(), info.getSchedule(), info.getCopyFromURL(), info.getCopyFromRevision().getNumber(), Info.getName(info.getConflictOldFile()), Info.getName(info.getConflictNewFile()), Info.getName(info.getConflictWrkFile()), Info.getName(info.getPropConflictFile()), Lock.create(info.getLock()), Depth.from(info.getDepth()), TreeConflictDescription.create(info.getTreeConflict()));
        Info info2 = result;
        if (info2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/info/Info", "create"));
        }
        return info2;
    }

    /*
     * WARNING - void declaration
     */
    public Info(File file, SVNURL url, SVNURL rootURL, long revision, @NotNull NodeKind kind, String uuid, long committedRevision, String committedDate, String author, String schedule, SVNURL copyFromURL, long copyFromRevision, @Nullable String conflictOldFileName, @Nullable String conflictNewFileName, @Nullable String conflictWorkingFileName, @Nullable String propRejectFileName, @Nullable Lock lock, Depth depth, @Nullable TreeConflictDescription treeConflictDescription) {
        void depth2;
        void treeConflict;
        void lock2;
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/idea/svn/info/Info", "<init>"));
        }
        super(kind);
        this.myFile = file;
        this.myURL = url;
        this.myRevision = SVNRevision.create((long)revision);
        this.myRepositoryUUID = uuid;
        this.myRepositoryRootURL = rootURL;
        this.myCommittedRevision = SVNRevision.create((long)committedRevision);
        this.myCommittedDate = committedDate != null ? SVNDate.parseDate((String)committedDate) : null;
        this.myAuthor = author;
        this.mySchedule = schedule;
        this.myCopyFromURL = copyFromURL;
        this.myCopyFromRevision = SVNRevision.create((long)copyFromRevision);
        this.myLock = lock2;
        this.myTreeConflict = treeConflict;
        this.myConflictOldFile = Info.resolveConflictFile(file, conflictOldFileName);
        this.myConflictNewFile = Info.resolveConflictFile(file, conflictNewFileName);
        this.myConflictWrkFile = Info.resolveConflictFile(file, conflictWorkingFileName);
        this.myPropConflictFile = Info.resolveConflictFile(file, propRejectFileName);
        this.myIsRemote = false;
        this.myDepth = depth2;
        this.myPath = null;
    }

    /*
     * WARNING - void declaration
     */
    public Info(String path, SVNURL url, @NotNull SVNRevision revision, @NotNull NodeKind kind, String uuid, SVNURL reposRootURL, long committedRevision, Date date, String author, @Nullable Lock lock, Depth depth) {
        void depth2;
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "org/jetbrains/idea/svn/info/Info", "<init>"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/idea/svn/info/Info", "<init>"));
        }
        super(kind);
        this.myIsRemote = true;
        this.myURL = url;
        this.myRevision = revision;
        this.myRepositoryRootURL = reposRootURL;
        this.myRepositoryUUID = uuid;
        this.myCommittedDate = date;
        this.myCommittedRevision = SVNRevision.create((long)committedRevision);
        this.myAuthor = author;
        this.myLock = lock;
        this.myPath = path;
        this.myDepth = depth2;
        this.myFile = null;
        this.mySchedule = null;
        this.myCopyFromURL = null;
        this.myCopyFromRevision = null;
        this.myConflictOldFile = null;
        this.myConflictNewFile = null;
        this.myConflictWrkFile = null;
        this.myPropConflictFile = null;
        this.myTreeConflict = null;
    }

    public String getAuthor() {
        return this.myAuthor;
    }

    public Date getCommittedDate() {
        return this.myCommittedDate;
    }

    public SVNRevision getCommittedRevision() {
        return this.myCommittedRevision;
    }

    @Nullable
    public File getConflictNewFile() {
        return this.myConflictNewFile;
    }

    @Nullable
    public File getConflictOldFile() {
        return this.myConflictOldFile;
    }

    @Nullable
    public File getConflictWrkFile() {
        return this.myConflictWrkFile;
    }

    @Nullable
    public TreeConflictDescription getTreeConflict() {
        return this.myTreeConflict;
    }

    public SVNRevision getCopyFromRevision() {
        return this.myCopyFromRevision;
    }

    public SVNURL getCopyFromURL() {
        return this.myCopyFromURL;
    }

    public File getFile() {
        return this.myFile;
    }

    public boolean isRemote() {
        return this.myIsRemote;
    }

    @NotNull
    public NodeKind getKind() {
        NodeKind nodeKind = this.myKind;
        if (nodeKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/info/Info", "getKind"));
        }
        return nodeKind;
    }

    @Nullable
    public Lock getLock() {
        return this.myLock;
    }

    public String getPath() {
        return this.myPath;
    }

    @Nullable
    public File getPropConflictFile() {
        return this.myPropConflictFile;
    }

    public SVNURL getRepositoryRootURL() {
        return this.myRepositoryRootURL;
    }

    public String getRepositoryUUID() {
        return this.myRepositoryUUID;
    }

    @NotNull
    public SVNRevision getRevision() {
        SVNRevision sVNRevision = this.myRevision;
        if (sVNRevision == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/info/Info", "getRevision"));
        }
        return sVNRevision;
    }

    public String getSchedule() {
        return this.mySchedule;
    }

    public SVNURL getURL() {
        return this.myURL;
    }

    public Depth getDepth() {
        return this.myDepth;
    }

    @Nullable
    private static File resolveConflictFile(@Nullable File file, @Nullable String path) {
        return file != null && path != null ? new File(file.getParentFile(), path) : null;
    }

    @Nullable
    private static String getName(@Nullable File file) {
        return file != null ? file.getName() : null;
    }

    @Nullable
    private static String toString(@Nullable Date date) {
        return date != null ? date.toString() : null;
    }
}

