/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.execution.CantRunException;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.impl.AntBuildFileImpl;
import com.intellij.lang.ant.config.impl.AntConfigurationImpl;
import com.intellij.lang.ant.config.impl.AntInstallation;
import com.intellij.lang.ant.config.impl.GlobalAntConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.Externalizer;
import java.util.Comparator;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class AntReference {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.ant.config.impl.AntReference");
    @NonNls
    private static final String PROJECT_DEFAULT_ATTR = "projectDefault";
    @NonNls
    private static final String NAME_ATTR = "name";
    @NonNls
    private static final String BUNDLED_ANT_ATTR = "bundledAnt";
    public static final Externalizer<AntReference> EXTERNALIZER = new Externalizer<AntReference>(){

        public AntReference readValue(Element dataElement) {
            if (Boolean.valueOf(dataElement.getAttributeValue(AntReference.PROJECT_DEFAULT_ATTR)).booleanValue()) {
                return PROJECT_DEFAULT;
            }
            if (Boolean.valueOf(dataElement.getAttributeValue(AntReference.BUNDLED_ANT_ATTR)).booleanValue()) {
                return BUNDLED_ANT;
            }
            String name = dataElement.getAttributeValue(AntReference.NAME_ATTR);
            if (name == null) {
                throw new IllegalStateException("no name");
            }
            return new MissingAntReference(name);
        }

        public void writeValue(Element dataElement, AntReference antReference) {
            antReference.writeExternal(dataElement);
        }
    };
    public static final Comparator<AntReference> COMPARATOR = new Comparator<AntReference>(){

        @Override
        public int compare(AntReference reference, AntReference reference1) {
            if (reference.equals(reference1)) {
                return 0;
            }
            if (reference == BUNDLED_ANT) {
                return -1;
            }
            if (reference1 == BUNDLED_ANT) {
                return 1;
            }
            return reference.getName().compareToIgnoreCase(reference1.getName());
        }
    };
    public static final AntReference PROJECT_DEFAULT = new AntReference(){

        @Override
        protected void writeExternal(Element dataElement) {
            dataElement.setAttribute(AntReference.PROJECT_DEFAULT_ATTR, Boolean.TRUE.toString());
        }

        @Override
        public AntInstallation find(GlobalAntConfiguration ants) {
            throw new UnsupportedOperationException("Should not call");
        }

        @Override
        public AntReference bind(GlobalAntConfiguration antConfiguration) {
            return this;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException("Should not call");
        }

        @Override
        public String toString() {
            return "PROJECT_DEFAULT";
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }
    };
    public static final AntReference BUNDLED_ANT = new AntReference(){

        @Override
        protected void writeExternal(Element dataElement) {
            dataElement.setAttribute(AntReference.BUNDLED_ANT_ATTR, Boolean.TRUE.toString());
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }

        @Override
        public String getName() {
            return GlobalAntConfiguration.BUNDLED_ANT_NAME;
        }

        @Override
        public AntInstallation find(GlobalAntConfiguration antConfiguration) {
            return antConfiguration.getBundledAnt();
        }

        @Override
        public AntReference bind(GlobalAntConfiguration antConfiguration) {
            return this;
        }
    };

    protected abstract void writeExternal(Element var1);

    public String toString() {
        return this.getName();
    }

    public abstract String getName();

    public abstract AntInstallation find(GlobalAntConfiguration var1);

    public abstract AntReference bind(GlobalAntConfiguration var1);

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == PROJECT_DEFAULT) {
            return this == PROJECT_DEFAULT;
        }
        if (obj == BUNDLED_ANT) {
            return this == BUNDLED_ANT;
        }
        return obj instanceof AntReference && Comparing.equal((String)this.getName(), (String)((AntReference)obj).getName());
    }

    @Nullable
    public static AntInstallation findAnt(AbstractProperty<AntReference> property, AbstractProperty.AbstractPropertyContainer container) {
        GlobalAntConfiguration antConfiguration = (GlobalAntConfiguration)GlobalAntConfiguration.INSTANCE.get(container);
        LOG.assertTrue(antConfiguration != null);
        AntReference antReference = (AntReference)property.get(container);
        if (antReference == PROJECT_DEFAULT) {
            antReference = (AntReference)AntConfigurationImpl.DEFAULT_ANT.get(container);
        }
        if (antReference == null) {
            return null;
        }
        return antReference.find(antConfiguration);
    }

    public static AntInstallation findNotNullAnt(AbstractProperty<AntReference> property, AbstractProperty.AbstractPropertyContainer container, GlobalAntConfiguration antConfiguration) throws CantRunException {
        AntReference antReference = (AntReference)property.get(container);
        if (antReference == PROJECT_DEFAULT) {
            antReference = (AntReference)AntConfigurationImpl.DEFAULT_ANT.get(container);
        }
        if (antReference == null) {
            throw new CantRunException(AntBundle.message("cant.run.ant.no.ant.configured.error.message", new Object[0]));
        }
        AntInstallation antInstallation = antReference.find(antConfiguration);
        if (antInstallation == null) {
            throw new CantRunException(AntBundle.message("cant.run.ant.ant.reference.is.not.configured.error.message", antReference.getName()));
        }
        return antInstallation;
    }

    @Nullable
    public static AntInstallation findAntOrBundled(AbstractProperty.AbstractPropertyContainer container) {
        GlobalAntConfiguration antConfiguration = (GlobalAntConfiguration)GlobalAntConfiguration.INSTANCE.get(container);
        if (container.hasProperty(AntBuildFileImpl.ANT_REFERENCE)) {
            return AntReference.findAnt(AntBuildFileImpl.ANT_REFERENCE, container);
        }
        return antConfiguration.getBundledAnt();
    }

    static class BindedReference
    extends AntReference {
        private final AntInstallation myAnt;

        public BindedReference(AntInstallation ant) {
            this.myAnt = ant;
        }

        @Override
        public AntInstallation find(GlobalAntConfiguration antConfiguration) {
            return this.myAnt;
        }

        @Override
        public String getName() {
            return this.myAnt.getName();
        }

        @Override
        protected void writeExternal(Element dataElement) {
            dataElement.setAttribute(AntReference.NAME_ATTR, this.getName());
        }

        @Override
        public AntReference bind(GlobalAntConfiguration antConfiguration) {
            return this;
        }
    }

    static class MissingAntReference
    extends AntReference {
        private final String myName;

        public MissingAntReference(String name) {
            this.myName = name;
        }

        @Override
        protected void writeExternal(Element dataElement) {
            dataElement.setAttribute(AntReference.NAME_ATTR, this.myName);
        }

        @Override
        public String getName() {
            return this.myName;
        }

        @Override
        public AntInstallation find(GlobalAntConfiguration antConfiguration) {
            return antConfiguration.getConfiguredAnts().get(this);
        }

        @Override
        public AntReference bind(GlobalAntConfiguration antConfiguration) {
            AntInstallation antInstallation = this.find(antConfiguration);
            if (antInstallation != null) {
                return new BindedReference(antInstallation);
            }
            return this;
        }
    }
}

