/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.lang.ant.config.AntBuildTargetBase;
import com.intellij.lang.ant.dom.AntDomElement;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import org.jetbrains.annotations.Nullable;

public final class BuildTask {
    public static final BuildTask[] EMPTY_ARRAY = new BuildTask[0];
    private final AntBuildTargetBase myTarget;
    private final String myName;
    private final int myOffset;

    public BuildTask(AntBuildTargetBase target, AntDomElement task) {
        this.myTarget = target;
        this.myName = task.getXmlElementName();
        DomTarget domTarget = DomTarget.getTarget((DomElement)task);
        this.myOffset = domTarget != null ? domTarget.getTextOffset() : task.getXmlTag().getTextOffset();
    }

    public String getName() {
        return this.myName;
    }

    @Nullable
    public OpenFileDescriptor getOpenFileDescriptor() {
        VirtualFile vFile = this.myTarget.getContainingFile();
        return vFile != null ? new OpenFileDescriptor(this.myTarget.getProject(), vFile, this.myOffset) : null;
    }
}

