/*
 * Copyright 2010-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package kotlin.reflect.jvm.internal.impl.serialization.deserialization

import kotlin.reflect.jvm.internal.impl.types.DynamicTypeCapabilities
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypeCapabilities

interface FlexibleTypeCapabilitiesDeserializer {
    object ThrowException : FlexibleTypeCapabilitiesDeserializer {
        override fun capabilitiesById(id: String): FlexibleTypeCapabilities? {
            throw IllegalArgumentException("Capabilities not found by ThrowException manager: $id")
        }
    }

    object Dynamic : FlexibleTypeCapabilitiesDeserializer {
        override fun capabilitiesById(id: String): FlexibleTypeCapabilities? {
            return if (id == DynamicTypeCapabilities.id) DynamicTypeCapabilities else null
        }
    }


    fun capabilitiesById(id: String): FlexibleTypeCapabilities?
}
