/*
 * Decompiled with CFR 0.152.
 */
package java.awt.peer;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.peer.KeyboardFocusManagerPeer;
import java.lang.reflect.Field;

public class BDKeyboardFocusManagerPeer
implements KeyboardFocusManagerPeer {
    private static boolean java7 = false;
    static BDKeyboardFocusManagerPeer instance = null;
    private Component focusOwner = null;
    private Window window = null;
    private boolean disposed = false;

    public static KeyboardFocusManagerPeer getInstance() {
        java7 = true;
        if (instance == null) {
            instance = new BDKeyboardFocusManagerPeer();
        }
        return instance;
    }

    public static void shutdown() {
        if (instance != null) {
            instance.dispose();
            instance = null;
        }
    }

    public static void init(Window window) {
        Field kbPeer;
        if (java7) {
            return;
        }
        if (instance == null) {
            instance = new BDKeyboardFocusManagerPeer();
        }
        BDKeyboardFocusManagerPeer.instance.focusOwner = null;
        BDKeyboardFocusManagerPeer.instance.window = window;
        try {
            Class<?> c = Class.forName("java.awt.KeyboardFocusManager");
            kbPeer = c.getDeclaredField("peer");
            kbPeer.setAccessible(true);
        }
        catch (ClassNotFoundException e) {
            throw new Error("java.awt.KeyboardFocusManager not found");
        }
        catch (SecurityException e) {
            throw new Error("java.awt.KeyboardFocusManager not accessible");
        }
        catch (NoSuchFieldException e) {
            throw new Error("java.awt.KeyboardFocusManager.peer not found");
        }
        try {
            kbPeer.set(KeyboardFocusManager.getCurrentKeyboardFocusManager(), instance);
        }
        catch (IllegalAccessException e) {
            throw new Error("java.awt.KeyboardFocusManager.peer not accessible:" + e);
        }
    }

    public void dispose() {
        this.focusOwner = null;
        this.window = null;
        this.disposed = true;
    }

    private BDKeyboardFocusManagerPeer() {
    }

    public void clearGlobalFocusOwner(Window w) {
    }

    public Component getCurrentFocusOwner() {
        return this.focusOwner;
    }

    public void setCurrentFocusOwner(Component c) {
        if (!this.disposed) {
            this.focusOwner = c;
        }
    }

    public void setCurrentFocusedWindow(Window w) {
        if (!this.disposed) {
            this.window = w;
        }
    }

    public Window getCurrentFocusedWindow() {
        return this.window;
    }
}

