/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import sun.misc.Unsafe;

public class ConcurrentSkipListMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentNavigableMap<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -8627078645895051609L;
    private static final Object BASE_HEADER = new Object();
    private volatile transient HeadIndex<K, V> head;
    final Comparator<? super K> comparator;
    private transient KeySet<K> keySet;
    private transient EntrySet<K, V> entrySet;
    private transient Values<V> values;
    private transient ConcurrentNavigableMap<K, V> descendingMap;
    private static final int EQ = 1;
    private static final int LT = 2;
    private static final int GT = 0;
    private static final Unsafe UNSAFE;
    private static final long headOffset;
    private static final long SECONDARY;

    private void initialize() {
        this.keySet = null;
        this.entrySet = null;
        this.values = null;
        this.descendingMap = null;
        this.head = new HeadIndex(new Node(null, BASE_HEADER, null), null, null, 1);
    }

    private boolean casHead(HeadIndex<K, V> headIndex, HeadIndex<K, V> headIndex2) {
        return UNSAFE.compareAndSwapObject(this, headOffset, headIndex, headIndex2);
    }

    static final int cpr(Comparator comparator, Object object, Object object2) {
        return comparator != null ? comparator.compare(object, object2) : ((Comparable)object).compareTo(object2);
    }

    private Node<K, V> findPredecessor(Object object, Comparator<? super K> comparator) {
        if (object == null) {
            throw new NullPointerException();
        }
        block0: while (true) {
            Index index = this.head;
            Index index2 = index.right;
            while (true) {
                Index index3;
                if (index2 != null) {
                    Node node = index2.node;
                    Object k = node.key;
                    if (node.value == null) {
                        if (!index.unlink(index2)) continue block0;
                        index2 = index.right;
                        continue;
                    }
                    if (ConcurrentSkipListMap.cpr(comparator, object, k) > 0) {
                        index = index2;
                        index2 = index2.right;
                        continue;
                    }
                }
                if ((index3 = index.down) == null) {
                    return index.node;
                }
                index = index3;
                index2 = index3.right;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Node<K, V> findNode(Object var1_1) {
        if (var1_1 == null) {
            throw new NullPointerException();
        }
        var2_2 = this.comparator;
        block0: while (true) {
            var3_3 /* !! */  = this.findPredecessor(var1_1, var2_2);
            var4_4 = var3_3 /* !! */ .next;
            while (var4_4 != null) {
                var7_7 = var4_4.next;
                if (var4_4 != var3_3 /* !! */ .next) continue block0;
                var5_5 = var4_4.value;
                if (var5_5 == null) {
                    var4_4.helpDelete(var3_3 /* !! */ , var7_7);
                    continue block0;
                }
                if (var3_3 /* !! */ .value != null && var5_5 != var4_4) ** break;
                continue block0;
                var6_6 = ConcurrentSkipListMap.cpr(var2_2, var1_1, var4_4.key);
                if (var6_6 == 0) {
                    return var4_4;
                }
                if (var6_6 < 0) break block0;
                var3_3 /* !! */  = var4_4;
                var4_4 = var7_7;
            }
            break;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private V doGet(Object var1_1) {
        if (var1_1 == null) {
            throw new NullPointerException();
        }
        var2_2 = this.comparator;
        block0: while (true) {
            var3_3 /* !! */  = this.findPredecessor(var1_1, var2_2);
            var4_4 = var3_3 /* !! */ .next;
            while (var4_4 != null) {
                var7_7 = var4_4.next;
                if (var4_4 != var3_3 /* !! */ .next) continue block0;
                var5_5 = var4_4.value;
                if (var5_5 == null) {
                    var4_4.helpDelete(var3_3 /* !! */ , var7_7);
                    continue block0;
                }
                if (var3_3 /* !! */ .value != null && var5_5 != var4_4) ** break;
                continue block0;
                var6_6 = ConcurrentSkipListMap.cpr(var2_2, var1_1, var4_4.key);
                if (var6_6 == 0) {
                    var8_8 = var5_5;
                    return (V)var8_8;
                }
                if (var6_6 < 0) break block0;
                var3_3 /* !! */  = var4_4;
                var4_4 = var7_7;
            }
            break;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private V doPut(K var1_1, V var2_2, boolean var3_3) {
        if (var1_1 == null) {
            throw new NullPointerException();
        }
        var5_4 = this.comparator;
        block0: while (true) {
            var6_6 /* !! */  = this.findPredecessor(var1_1, var5_4);
            var7_8 = var6_6 /* !! */ .next;
            while (var7_8 != null) {
                var10_14 /* !! */  = var7_8.next;
                if (var7_8 != var6_6 /* !! */ .next) continue block0;
                var8_10 = var7_8.value;
                if (var8_10 == null) {
                    var7_8.helpDelete(var6_6 /* !! */ , var10_14 /* !! */ );
                    continue block0;
                }
                if (var6_6 /* !! */ .value == null || var8_10 == var7_8) continue block0;
                var9_12 = ConcurrentSkipListMap.cpr(var5_4, var1_1, var7_8.key);
                if (var9_12 > 0) {
                    var6_6 /* !! */  = var7_8;
                    var7_8 = var10_14 /* !! */ ;
                    continue;
                }
                if (var9_12 != 0) break;
                if (!var3_3 && !var7_8.casValue(var8_10, var2_2)) continue block0;
                var11_15 = var8_10;
                return (V)var11_15;
            }
            if (var6_6 /* !! */ .casNext(var7_8, var4_5 = new Node<K, V>(var1_1, var2_2, var7_8))) break;
        }
        var6_7 = ThreadLocalRandom.nextSecondarySeed();
        if ((var6_7 & -2147483647) == 0) {
            block21: {
                var7_9 = 1;
                while (((var6_7 >>>= 1) & 1) != 0) {
                    ++var7_9;
                }
                var9_13 = null;
                var10_14 /* !! */  = this.head;
                var8_11 = var10_14 /* !! */ .level;
                if (var7_9 <= var8_11) {
                    for (var11_16 = 1; var11_16 <= var7_9; ++var11_16) {
                        var9_13 = new Index(var4_5, var9_13, null);
                    }
                } else {
                    var7_9 = var8_11 + 1;
                    var11_17 = new Index[var7_9 + 1];
                    for (var12_19 = 1; var12_19 <= var7_9; ++var12_19) {
                        var9_13 = new Index<K, V>(var4_5, var9_13, null);
                        var11_17[var12_19] = var9_13;
                    }
                    do {
                        var10_14 /* !! */  = this.head;
                        var12_19 = var10_14 /* !! */ .level;
                        if (var7_9 <= var12_19) break block21;
                        var13_20 = var10_14 /* !! */ ;
                        var14_21 = var10_14 /* !! */ .node;
                        for (var15_22 = var12_19 + 1; var15_22 <= var7_9; ++var15_22) {
                            var13_20 = new HeadIndex<K, V>(var14_21, var13_20, var11_17[var15_22], var15_22);
                        }
                    } while (!this.casHead(var10_14 /* !! */ , (HeadIndex<K, V>)var13_20));
                    var10_14 /* !! */  = var13_20;
                    var7_9 = var12_19;
                    var9_13 = var11_17[var7_9];
                }
            }
            var11_18 = var7_9;
            block7: while (true) {
                var12_19 = var10_14 /* !! */ .level;
                var13_20 = var10_14 /* !! */ ;
                var14_21 = var13_20.right;
                var15_24 = var9_13;
                while (var13_20 != null && var15_24 != null) {
                    if (var14_21 != null) {
                        var16_25 = var14_21.node;
                        var17_26 = ConcurrentSkipListMap.cpr(var5_4, var1_1, var16_25.key);
                        if (var16_25.value == null) {
                            if (!var13_20.unlink(var14_21)) continue block7;
                            var14_21 = var13_20.right;
                            continue;
                        }
                        if (var17_26 > 0) {
                            var13_20 = var14_21;
                            var14_21 = var14_21.right;
                            continue;
                        }
                    }
                    if (var12_19 == var11_18) {
                        if (var13_20.link(var14_21, var15_24)) ** break;
                        continue block7;
                        if (var15_24.node.value == null) {
                            this.findNode(var1_1);
                            break block7;
                        }
                        if (--var11_18 == 0) break block7;
                    }
                    if (--var12_19 >= var11_18 && var12_19 < var7_9) {
                        var15_24 = var15_24.down;
                    }
                    var13_20 = var13_20.down;
                    var14_21 = var13_20.right;
                }
                break;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    final V doRemove(Object object, Object object2) {
        Object object3;
        Node node;
        Node node2;
        Node node3;
        if (object == null) {
            throw new NullPointerException();
        }
        Comparator<? super K> comparator = this.comparator;
        block0: while (true) {
            node3 = this.findPredecessor(object, comparator);
            node2 = node3.next;
            while (true) {
                if (node2 == null) {
                    return null;
                }
                node = node2.next;
                if (node2 != node3.next) continue block0;
                object3 = node2.value;
                if (object3 == null) {
                    node2.helpDelete(node3, node);
                    continue block0;
                }
                if (node3.value == null || object3 == node2) continue block0;
                int n = ConcurrentSkipListMap.cpr(comparator, object, node2.key);
                if (n < 0) {
                    return null;
                }
                if (n <= 0) break;
                node3 = node2;
                node2 = node;
            }
            if (object2 != null && !object2.equals(object3)) {
                return null;
            }
            if (node2.casValue(object3, null)) break;
        }
        if (!node2.appendMarker(node) || !node3.casNext(node2, node)) {
            this.findNode(object);
        } else {
            this.findPredecessor(object, comparator);
            if (this.head.right == null) {
                this.tryReduceLevel();
            }
        }
        Object object4 = object3;
        return (V)object4;
    }

    private void tryReduceLevel() {
        HeadIndex headIndex;
        HeadIndex headIndex2;
        HeadIndex<K, V> headIndex3 = this.head;
        if (headIndex3.level > 3 && (headIndex2 = (HeadIndex)headIndex3.down) != null && (headIndex = (HeadIndex)headIndex2.down) != null && headIndex.right == null && headIndex2.right == null && headIndex3.right == null && this.casHead(headIndex3, headIndex2) && headIndex3.right != null) {
            this.casHead(headIndex2, headIndex3);
        }
    }

    final Node<K, V> findFirst() {
        while (true) {
            Node node = this.head.node;
            Node node2 = node.next;
            if (node2 == null) {
                return null;
            }
            if (node2.value != null) {
                return node2;
            }
            node2.helpDelete(node, node2.next);
        }
    }

    private Map.Entry<K, V> doRemoveFirstEntry() {
        Object object;
        Node node;
        Node node2;
        Node node3;
        while (true) {
            node3 = this.head.node;
            node2 = node3.next;
            if (node2 == null) {
                return null;
            }
            node = node2.next;
            if (node2 != node3.next) continue;
            object = node2.value;
            if (object == null) {
                node2.helpDelete(node3, node);
                continue;
            }
            if (node2.casValue(object, null)) break;
        }
        if (!node2.appendMarker(node) || !node3.casNext(node2, node)) {
            this.findFirst();
        }
        this.clearIndexToFirst();
        Object object2 = object;
        return new AbstractMap.SimpleImmutableEntry(node2.key, object2);
    }

    private void clearIndexToFirst() {
        block0: while (true) {
            Index index = this.head;
            do {
                Index index2;
                if ((index2 = index.right) != null && index2.indexesDeletedNode() && !index.unlink(index2)) continue block0;
            } while ((index = index.down) != null);
            break;
        }
        if (this.head.right == null) {
            this.tryReduceLevel();
        }
    }

    private Map.Entry<K, V> doRemoveLastEntry() {
        Object object;
        Node node;
        Node node2;
        Node node3;
        block0: while (true) {
            node3 = this.findPredecessorOfLast();
            node2 = node3.next;
            if (node2 == null) {
                if (!node3.isBaseHeader()) continue;
                return null;
            }
            while (true) {
                node = node2.next;
                if (node2 != node3.next) continue block0;
                object = node2.value;
                if (object == null) {
                    node2.helpDelete(node3, node);
                    continue block0;
                }
                if (node3.value == null || object == node2) continue block0;
                if (node == null) break;
                node3 = node2;
                node2 = node;
            }
            if (node2.casValue(object, null)) break;
        }
        Object k = node2.key;
        if (!node2.appendMarker(node) || !node3.casNext(node2, node)) {
            this.findNode(k);
        } else {
            this.findPredecessor(k, this.comparator);
            if (this.head.right == null) {
                this.tryReduceLevel();
            }
        }
        Object object2 = object;
        return new AbstractMap.SimpleImmutableEntry(k, object2);
    }

    final Node<K, V> findLast() {
        Index index = this.head;
        while (true) {
            Index index2;
            if ((index2 = index.right) != null) {
                if (index2.indexesDeletedNode()) {
                    index.unlink(index2);
                    index = this.head;
                    continue;
                }
                index = index2;
                continue;
            }
            Index index3 = index.down;
            if (index3 != null) {
                index = index3;
                continue;
            }
            Node node = index.node;
            Node node2 = node.next;
            while (true) {
                if (node2 == null) {
                    return node.isBaseHeader() ? null : node;
                }
                Node node3 = node2.next;
                if (node2 != node.next) break;
                Object object = node2.value;
                if (object == null) {
                    node2.helpDelete(node, node3);
                    break;
                }
                if (node.value == null || object == node2) break;
                node = node2;
                node2 = node3;
            }
            index = this.head;
        }
    }

    private Node<K, V> findPredecessorOfLast() {
        Index index;
        block0: while (true) {
            index = this.head;
            while (true) {
                Index index2;
                Index index3;
                if ((index3 = index.right) != null) {
                    if (index3.indexesDeletedNode()) {
                        index.unlink(index3);
                        continue block0;
                    }
                    if (index3.node.next != null) {
                        index = index3;
                        continue;
                    }
                }
                if ((index2 = index.down) == null) break block0;
                index = index2;
            }
            break;
        }
        return index.node;
    }

    /*
     * Unable to fully structure code
     */
    final Node<K, V> findNear(K var1_1, int var2_2, Comparator<? super K> var3_3) {
        if (var1_1 == null) {
            throw new NullPointerException();
        }
        block0: while (true) {
            var4_4 = this.findPredecessor(var1_1, var3_3);
            var5_5 = var4_4.next;
            while (true) {
                if (var5_5 == null) {
                    return (var2_2 & 2) == 0 || var4_4.isBaseHeader() != false ? null : var4_4;
                }
                var7_7 = var5_5.next;
                if (var5_5 != var4_4.next) continue block0;
                var6_6 = var5_5.value;
                if (var6_6 == null) {
                    var5_5.helpDelete(var4_4, var7_7);
                    continue block0;
                }
                if (var4_4.value != null && var6_6 != var5_5) ** break;
                continue block0;
                var8_8 = ConcurrentSkipListMap.cpr(var3_3, var1_1, var5_5.key);
                if (var8_8 == 0 && (var2_2 & 1) != 0 || var8_8 < 0 && (var2_2 & 2) == 0) {
                    return var5_5;
                }
                if (var8_8 <= 0 && (var2_2 & 2) != 0) {
                    return var4_4.isBaseHeader() != false ? null : var4_4;
                }
                var4_4 = var5_5;
                var5_5 = var7_7;
            }
            break;
        }
    }

    final AbstractMap.SimpleImmutableEntry<K, V> getNear(K k, int n) {
        Node<K, V> node;
        AbstractMap.SimpleImmutableEntry<? super K, V> simpleImmutableEntry;
        Comparator<? super K> comparator = this.comparator;
        do {
            if ((node = this.findNear(k, n, comparator)) != null) continue;
            return null;
        } while ((simpleImmutableEntry = node.createSnapshot()) == null);
        return simpleImmutableEntry;
    }

    public ConcurrentSkipListMap() {
        this.comparator = null;
        this.initialize();
    }

    public ConcurrentSkipListMap(Comparator<? super K> comparator) {
        this.comparator = comparator;
        this.initialize();
    }

    public ConcurrentSkipListMap(Map<? extends K, ? extends V> map) {
        this.comparator = null;
        this.initialize();
        this.putAll(map);
    }

    public ConcurrentSkipListMap(SortedMap<K, ? extends V> sortedMap) {
        this.comparator = sortedMap.comparator();
        this.initialize();
        this.buildFromSorted(sortedMap);
    }

    @Override
    public ConcurrentSkipListMap<K, V> clone() {
        try {
            ConcurrentSkipListMap concurrentSkipListMap = (ConcurrentSkipListMap)super.clone();
            concurrentSkipListMap.initialize();
            concurrentSkipListMap.buildFromSorted(this);
            return concurrentSkipListMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    private void buildFromSorted(SortedMap<K, ? extends V> sortedMap) {
        if (sortedMap == null) {
            throw new NullPointerException();
        }
        HeadIndex<K, V> headIndex = this.head;
        Node node = headIndex.node;
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i <= headIndex.level; ++i) {
            arrayList.add(null);
        }
        Index index = headIndex;
        for (int i = headIndex.level; i > 0; --i) {
            arrayList.set(i, index);
            index = index.down;
        }
        for (Map.Entry<K, V> entry : sortedMap.entrySet()) {
            int n = ThreadLocalRandom.current().nextInt();
            int n2 = 0;
            if ((n & 0x80000001) == 0) {
                do {
                    ++n2;
                } while (((n >>>= 1) & 1) != 0);
                if (n2 > headIndex.level) {
                    n2 = headIndex.level + 1;
                }
            }
            K k = entry.getKey();
            V v = entry.getValue();
            if (k == null || v == null) {
                throw new NullPointerException();
            }
            Node node2 = new Node(k, v, null);
            node.next = node2;
            node = node2;
            if (n2 <= 0) continue;
            Index index2 = null;
            for (int i = 1; i <= n2; ++i) {
                index2 = new Index(node2, index2, null);
                if (i > headIndex.level) {
                    headIndex = new HeadIndex<K, V>(headIndex.node, headIndex, index2, i);
                }
                if (i < arrayList.size()) {
                    ((Index)arrayList.get((int)i)).right = index2;
                    arrayList.set(i, index2);
                    continue;
                }
                arrayList.add(index2);
            }
        }
        this.head = headIndex;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Node<K, V> node = this.findFirst();
        while (node != null) {
            V v = node.getValidValue();
            if (v != null) {
                objectOutputStream.writeObject(node.key);
                objectOutputStream.writeObject(v);
            }
            node = node.next;
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        this.initialize();
        HeadIndex<Object, V> headIndex = this.head;
        Node node = headIndex.node;
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i <= headIndex.level; ++i) {
            arrayList.add(null);
        }
        Index index = headIndex;
        for (int i = headIndex.level; i > 0; --i) {
            arrayList.set(i, index);
            index = index.down;
        }
        while ((object = objectInputStream.readObject()) != null) {
            Object object2 = objectInputStream.readObject();
            if (object2 == null) {
                throw new NullPointerException();
            }
            Object object3 = object;
            Object object4 = object2;
            int n = ThreadLocalRandom.current().nextInt();
            int n2 = 0;
            if ((n & 0x80000001) == 0) {
                do {
                    ++n2;
                } while (((n >>>= 1) & 1) != 0);
                if (n2 > headIndex.level) {
                    n2 = headIndex.level + 1;
                }
            }
            Node node2 = new Node(object3, object4, null);
            node.next = node2;
            node = node2;
            if (n2 <= 0) continue;
            Index index2 = null;
            for (int i = 1; i <= n2; ++i) {
                index2 = new Index(node2, index2, null);
                if (i > headIndex.level) {
                    headIndex = new HeadIndex<Object, V>(headIndex.node, headIndex, index2, i);
                }
                if (i < arrayList.size()) {
                    ((Index)arrayList.get((int)i)).right = index2;
                    arrayList.set(i, index2);
                    continue;
                }
                arrayList.add(index2);
            }
        }
        this.head = headIndex;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.doGet(object) != null;
    }

    @Override
    public V get(Object object) {
        return this.doGet(object);
    }

    @Override
    public V getOrDefault(Object object, V v) {
        V v2 = this.doGet(object);
        return v2 == null ? v : v2;
    }

    @Override
    public V put(K k, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        return this.doPut(k, v, false);
    }

    @Override
    public V remove(Object object) {
        return this.doRemove(object, null);
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Node<K, V> node = this.findFirst();
        while (node != null) {
            V v = node.getValidValue();
            if (v != null && object.equals(v)) {
                return true;
            }
            node = node.next;
        }
        return false;
    }

    @Override
    public int size() {
        long l = 0L;
        Node<K, V> node = this.findFirst();
        while (node != null) {
            if (node.getValidValue() != null) {
                ++l;
            }
            node = node.next;
        }
        return l >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
    }

    @Override
    public boolean isEmpty() {
        return this.findFirst() == null;
    }

    @Override
    public void clear() {
        this.initialize();
    }

    @Override
    public V computeIfAbsent(K k, Function<? super K, ? extends V> function) {
        V v;
        if (k == null || function == null) {
            throw new NullPointerException();
        }
        V v2 = this.doGet(k);
        if (v2 == null && (v = function.apply(k)) != null) {
            V v3 = this.doPut(k, v, true);
            v2 = v3 == null ? v : v3;
        }
        return v2;
    }

    @Override
    public V computeIfPresent(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        Node<K, V> node;
        if (k == null || biFunction == null) {
            throw new NullPointerException();
        }
        while ((node = this.findNode(k)) != null) {
            Object object = node.value;
            if (object == null) continue;
            Object object2 = object;
            V v = biFunction.apply(k, object2);
            if (v != null) {
                if (!node.casValue(object2, v)) continue;
                return v;
            }
            if (this.doRemove(k, object2) == null) continue;
            break;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public V compute(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        if (k == null || biFunction == null) {
            throw new NullPointerException();
        }
        while (true) {
            V v;
            Node<K, V> node;
            if ((node = this.findNode(k)) == null) {
                v = biFunction.apply(k, null);
                if (v == null) return null;
                if (this.doPut(k, v, true) != null) continue;
                return v;
            }
            Object object = node.value;
            if (object == null) continue;
            Object object2 = object;
            v = biFunction.apply(k, object2);
            if (v != null) {
                if (!node.casValue(object2, v)) continue;
                return v;
            }
            if (this.doRemove(k, object2) != null) return null;
        }
    }

    @Override
    public V merge(K k, V v, BiFunction<? super V, ? super V, ? extends V> biFunction) {
        if (k == null || v == null || biFunction == null) {
            throw new NullPointerException();
        }
        while (true) {
            Node<K, V> node;
            if ((node = this.findNode(k)) == null) {
                if (this.doPut(k, v, true) != null) continue;
                return v;
            }
            Object object = node.value;
            if (object == null) continue;
            Object object2 = object;
            V v2 = biFunction.apply(object2, v);
            if (v2 != null) {
                if (!node.casValue(object2, v2)) continue;
                return v2;
            }
            if (this.doRemove(k, object2) != null) break;
        }
        return null;
    }

    @Override
    public NavigableSet<K> keySet() {
        KeySet<K> keySet = this.keySet;
        return keySet != null ? keySet : (this.keySet = new KeySet(this));
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        KeySet<K> keySet = this.keySet;
        return keySet != null ? keySet : (this.keySet = new KeySet(this));
    }

    @Override
    public Collection<V> values() {
        Values<V> values = this.values;
        return values != null ? values : (this.values = new Values(this));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet<K, V> entrySet = this.entrySet;
        return entrySet != null ? entrySet : (this.entrySet = new EntrySet(this));
    }

    @Override
    public ConcurrentNavigableMap<K, V> descendingMap() {
        ConcurrentNavigableMap<K, V> concurrentNavigableMap = this.descendingMap;
        return concurrentNavigableMap != null ? concurrentNavigableMap : (this.descendingMap = new SubMap(this, null, false, null, false, true));
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        try {
            for (Map.Entry<K, V> entry : this.entrySet()) {
                if (entry.getValue().equals(map.get(entry.getKey()))) continue;
                return false;
            }
            for (Map.Entry<K, V> entry : map.entrySet()) {
                K k = entry.getKey();
                V v = entry.getValue();
                if (k != null && v != null && v.equals(this.get(k))) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    @Override
    public V putIfAbsent(K k, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        return this.doPut(k, v, true);
    }

    @Override
    public boolean remove(Object object, Object object2) {
        if (object == null) {
            throw new NullPointerException();
        }
        return object2 != null && this.doRemove(object, object2) != null;
    }

    @Override
    public boolean replace(K k, V v, V v2) {
        if (k == null || v == null || v2 == null) {
            throw new NullPointerException();
        }
        while (true) {
            Node<K, V> node;
            if ((node = this.findNode(k)) == null) {
                return false;
            }
            Object object = node.value;
            if (object == null) continue;
            if (!v.equals(object)) {
                return false;
            }
            if (node.casValue(object, v2)) break;
        }
        return true;
    }

    @Override
    public V replace(K k, V v) {
        Node<K, V> node;
        Object object;
        if (k == null || v == null) {
            throw new NullPointerException();
        }
        do {
            if ((node = this.findNode(k)) != null) continue;
            return null;
        } while ((object = node.value) == null || !node.casValue(object, v));
        Object object2 = object;
        return (V)object2;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    @Override
    public K firstKey() {
        Node<K, V> node = this.findFirst();
        if (node == null) {
            throw new NoSuchElementException();
        }
        return node.key;
    }

    @Override
    public K lastKey() {
        Node<K, V> node = this.findLast();
        if (node == null) {
            throw new NoSuchElementException();
        }
        return node.key;
    }

    @Override
    public ConcurrentNavigableMap<K, V> subMap(K k, boolean bl, K k2, boolean bl2) {
        if (k == null || k2 == null) {
            throw new NullPointerException();
        }
        return new SubMap(this, k, bl, k2, bl2, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> headMap(K k, boolean bl) {
        if (k == null) {
            throw new NullPointerException();
        }
        return new SubMap(this, null, false, k, bl, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> tailMap(K k, boolean bl) {
        if (k == null) {
            throw new NullPointerException();
        }
        return new SubMap(this, k, bl, null, false, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> subMap(K k, K k2) {
        return this.subMap((Object)k, true, (Object)k2, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> headMap(K k) {
        return this.headMap((Object)k, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> tailMap(K k) {
        return this.tailMap((Object)k, true);
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K k) {
        return this.getNear(k, 2);
    }

    @Override
    public K lowerKey(K k) {
        Node<? super K, V> node = this.findNear(k, 2, this.comparator);
        return node == null ? null : (K)node.key;
    }

    @Override
    public Map.Entry<K, V> floorEntry(K k) {
        return this.getNear(k, 3);
    }

    @Override
    public K floorKey(K k) {
        Node<? super K, V> node = this.findNear(k, 3, this.comparator);
        return node == null ? null : (K)node.key;
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K k) {
        return this.getNear(k, 1);
    }

    @Override
    public K ceilingKey(K k) {
        Node<? super K, V> node = this.findNear(k, 1, this.comparator);
        return node == null ? null : (K)node.key;
    }

    @Override
    public Map.Entry<K, V> higherEntry(K k) {
        return this.getNear(k, 0);
    }

    @Override
    public K higherKey(K k) {
        Node<? super K, V> node = this.findNear(k, 0, this.comparator);
        return node == null ? null : (K)node.key;
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        Node<K, V> node;
        AbstractMap.SimpleImmutableEntry<K, V> simpleImmutableEntry;
        do {
            if ((node = this.findFirst()) != null) continue;
            return null;
        } while ((simpleImmutableEntry = node.createSnapshot()) == null);
        return simpleImmutableEntry;
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        Node<K, V> node;
        AbstractMap.SimpleImmutableEntry<K, V> simpleImmutableEntry;
        do {
            if ((node = this.findLast()) != null) continue;
            return null;
        } while ((simpleImmutableEntry = node.createSnapshot()) == null);
        return simpleImmutableEntry;
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        return this.doRemoveFirstEntry();
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        return this.doRemoveLastEntry();
    }

    Iterator<K> keyIterator() {
        return new KeyIterator();
    }

    Iterator<V> valueIterator() {
        return new ValueIterator();
    }

    Iterator<Map.Entry<K, V>> entryIterator() {
        return new EntryIterator();
    }

    static final <E> List<E> toList(Collection<E> collection) {
        ArrayList<E> arrayList = new ArrayList<E>();
        for (E e : collection) {
            arrayList.add(e);
        }
        return arrayList;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        if (biConsumer == null) {
            throw new NullPointerException();
        }
        Node<K, V> node = this.findFirst();
        while (node != null) {
            V v = node.getValidValue();
            if (v != null) {
                biConsumer.accept(node.key, v);
            }
            node = node.next;
        }
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
        if (biFunction == null) {
            throw new NullPointerException();
        }
        Node<K, V> node = this.findFirst();
        while (node != null) {
            V v;
            while ((v = node.getValidValue()) != null) {
                V v2 = biFunction.apply(node.key, v);
                if (v2 == null) {
                    throw new NullPointerException();
                }
                if (!node.casValue(v, v2)) continue;
                break;
            }
            node = node.next;
        }
    }

    final KeySpliterator<K, V> keySpliterator() {
        Comparator<? super K> comparator = this.comparator;
        while (true) {
            HeadIndex<K, V> headIndex = this.head;
            Node node = headIndex.node;
            Node node2 = node.next;
            if (node2 == null || node2.value != null) {
                return new KeySpliterator<Object, V>(comparator, headIndex, node2, null, node2 == null ? 0 : Integer.MAX_VALUE);
            }
            node2.helpDelete(node, node2.next);
        }
    }

    final ValueSpliterator<K, V> valueSpliterator() {
        Comparator<? super K> comparator = this.comparator;
        while (true) {
            HeadIndex<K, V> headIndex = this.head;
            Node node = headIndex.node;
            Node node2 = node.next;
            if (node2 == null || node2.value != null) {
                return new ValueSpliterator<Object, V>(comparator, headIndex, node2, null, node2 == null ? 0 : Integer.MAX_VALUE);
            }
            node2.helpDelete(node, node2.next);
        }
    }

    final EntrySpliterator<K, V> entrySpliterator() {
        Comparator<? super K> comparator = this.comparator;
        while (true) {
            HeadIndex<K, V> headIndex = this.head;
            Node node = headIndex.node;
            Node node2 = node.next;
            if (node2 == null || node2.value != null) {
                return new EntrySpliterator<Object, V>(comparator, headIndex, node2, null, node2 == null ? 0 : Integer.MAX_VALUE);
            }
            node2.helpDelete(node, node2.next);
        }
    }

    static {
        try {
            UNSAFE = Unsafe.getUnsafe();
            Class<ConcurrentSkipListMap> clazz = ConcurrentSkipListMap.class;
            headOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("head"));
            Class<Thread> clazz2 = Thread.class;
            SECONDARY = UNSAFE.objectFieldOffset(clazz2.getDeclaredField("threadLocalRandomSecondarySeed"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    static final class EntrySpliterator<K, V>
    extends CSLMSpliterator<K, V>
    implements Spliterator<Map.Entry<K, V>> {
        EntrySpliterator(Comparator<? super K> comparator, Index<K, V> index, Node<K, V> node, K k, int n) {
            super(comparator, index, node, k, n);
        }

        @Override
        public Spliterator<Map.Entry<K, V>> trySplit() {
            Object k;
            Comparator comparator = this.comparator;
            Object object = this.fence;
            Node node = this.current;
            if (node != null && (k = node.key) != null) {
                Index index = this.row;
                while (index != null) {
                    Object k2;
                    Node node2;
                    Node node3;
                    Index index2 = index.right;
                    if (index2 != null && (node3 = index2.node) != null && (node2 = node3.next) != null && node2.value != null && (k2 = node2.key) != null && ConcurrentSkipListMap.cpr(comparator, k2, k) > 0 && (object == null || ConcurrentSkipListMap.cpr(comparator, k2, object) < 0)) {
                        this.current = node2;
                        Index index3 = index.down;
                        this.row = index2.right != null ? index2 : index2.down;
                        this.est -= this.est >>> 2;
                        return new EntrySpliterator(comparator, index3, node, k2, this.est);
                    }
                    index = this.row = index.down;
                }
            }
            return null;
        }

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<K, V>> consumer) {
            Object k;
            if (consumer == null) {
                throw new NullPointerException();
            }
            Comparator comparator = this.comparator;
            Object object = this.fence;
            Node node = this.current;
            this.current = null;
            while (node != null && ((k = node.key) == null || object == null || ConcurrentSkipListMap.cpr(comparator, object, k) > 0)) {
                Object object2 = node.value;
                if (object2 != null && object2 != node) {
                    Object object3 = object2;
                    consumer.accept(new AbstractMap.SimpleImmutableEntry(k, object3));
                }
                node = node.next;
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map.Entry<K, V>> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            Comparator comparator = this.comparator;
            Object object = this.fence;
            Node node = this.current;
            while (node != null) {
                Object k = node.key;
                if (k != null && object != null && ConcurrentSkipListMap.cpr(comparator, object, k) <= 0) {
                    node = null;
                    break;
                }
                Object object2 = node.value;
                if (object2 != null && object2 != node) {
                    this.current = node.next;
                    Object object3 = object2;
                    consumer.accept(new AbstractMap.SimpleImmutableEntry(k, object3));
                    return true;
                }
                node = node.next;
            }
            this.current = node;
            return false;
        }

        @Override
        public int characteristics() {
            return 4373;
        }

        @Override
        public final Comparator<Map.Entry<K, V>> getComparator() {
            if (this.comparator != null) {
                return Map.Entry.comparingByKey(this.comparator);
            }
            return (Comparator & Serializable)(entry, entry2) -> {
                Comparable comparable = (Comparable)entry.getKey();
                return comparable.compareTo(entry2.getKey());
            };
        }
    }

    static final class ValueSpliterator<K, V>
    extends CSLMSpliterator<K, V>
    implements Spliterator<V> {
        ValueSpliterator(Comparator<? super K> comparator, Index<K, V> index, Node<K, V> node, K k, int n) {
            super(comparator, index, node, k, n);
        }

        @Override
        public Spliterator<V> trySplit() {
            Object k;
            Comparator comparator = this.comparator;
            Object object = this.fence;
            Node node = this.current;
            if (node != null && (k = node.key) != null) {
                Index index = this.row;
                while (index != null) {
                    Object k2;
                    Node node2;
                    Node node3;
                    Index index2 = index.right;
                    if (index2 != null && (node3 = index2.node) != null && (node2 = node3.next) != null && node2.value != null && (k2 = node2.key) != null && ConcurrentSkipListMap.cpr(comparator, k2, k) > 0 && (object == null || ConcurrentSkipListMap.cpr(comparator, k2, object) < 0)) {
                        this.current = node2;
                        Index index3 = index.down;
                        this.row = index2.right != null ? index2 : index2.down;
                        this.est -= this.est >>> 2;
                        return new ValueSpliterator(comparator, index3, node, k2, this.est);
                    }
                    index = this.row = index.down;
                }
            }
            return null;
        }

        @Override
        public void forEachRemaining(Consumer<? super V> consumer) {
            Object k;
            if (consumer == null) {
                throw new NullPointerException();
            }
            Comparator comparator = this.comparator;
            Object object = this.fence;
            Node node = this.current;
            this.current = null;
            while (node != null && ((k = node.key) == null || object == null || ConcurrentSkipListMap.cpr(comparator, object, k) > 0)) {
                Object object2 = node.value;
                if (object2 != null && object2 != node) {
                    Object object3 = object2;
                    consumer.accept(object3);
                }
                node = node.next;
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super V> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            Comparator comparator = this.comparator;
            Object object = this.fence;
            Node node = this.current;
            while (node != null) {
                Object k = node.key;
                if (k != null && object != null && ConcurrentSkipListMap.cpr(comparator, object, k) <= 0) {
                    node = null;
                    break;
                }
                Object object2 = node.value;
                if (object2 != null && object2 != node) {
                    this.current = node.next;
                    Object object3 = object2;
                    consumer.accept(object3);
                    return true;
                }
                node = node.next;
            }
            this.current = node;
            return false;
        }

        @Override
        public int characteristics() {
            return 4368;
        }
    }

    static final class KeySpliterator<K, V>
    extends CSLMSpliterator<K, V>
    implements Spliterator<K> {
        KeySpliterator(Comparator<? super K> comparator, Index<K, V> index, Node<K, V> node, K k, int n) {
            super(comparator, index, node, k, n);
        }

        @Override
        public Spliterator<K> trySplit() {
            Object k;
            Comparator comparator = this.comparator;
            Object object = this.fence;
            Node node = this.current;
            if (node != null && (k = node.key) != null) {
                Index index = this.row;
                while (index != null) {
                    Object k2;
                    Node node2;
                    Node node3;
                    Index index2 = index.right;
                    if (index2 != null && (node3 = index2.node) != null && (node2 = node3.next) != null && node2.value != null && (k2 = node2.key) != null && ConcurrentSkipListMap.cpr(comparator, k2, k) > 0 && (object == null || ConcurrentSkipListMap.cpr(comparator, k2, object) < 0)) {
                        this.current = node2;
                        Index index3 = index.down;
                        this.row = index2.right != null ? index2 : index2.down;
                        this.est -= this.est >>> 2;
                        return new KeySpliterator(comparator, index3, node, k2, this.est);
                    }
                    index = this.row = index.down;
                }
            }
            return null;
        }

        @Override
        public void forEachRemaining(Consumer<? super K> consumer) {
            Object k;
            if (consumer == null) {
                throw new NullPointerException();
            }
            Comparator comparator = this.comparator;
            Object object = this.fence;
            Node node = this.current;
            this.current = null;
            while (node != null && ((k = node.key) == null || object == null || ConcurrentSkipListMap.cpr(comparator, object, k) > 0)) {
                Object object2 = node.value;
                if (object2 != null && object2 != node) {
                    consumer.accept(k);
                }
                node = node.next;
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            Comparator comparator = this.comparator;
            Object object = this.fence;
            Node node = this.current;
            while (node != null) {
                Object k = node.key;
                if (k != null && object != null && ConcurrentSkipListMap.cpr(comparator, object, k) <= 0) {
                    node = null;
                    break;
                }
                Object object2 = node.value;
                if (object2 != null && object2 != node) {
                    this.current = node.next;
                    consumer.accept(k);
                    return true;
                }
                node = node.next;
            }
            this.current = node;
            return false;
        }

        @Override
        public int characteristics() {
            return 4373;
        }

        @Override
        public final Comparator<? super K> getComparator() {
            return this.comparator;
        }
    }

    static abstract class CSLMSpliterator<K, V> {
        final Comparator<? super K> comparator;
        final K fence;
        Index<K, V> row;
        Node<K, V> current;
        int est;

        CSLMSpliterator(Comparator<? super K> comparator, Index<K, V> index, Node<K, V> node, K k, int n) {
            this.comparator = comparator;
            this.row = index;
            this.current = node;
            this.fence = k;
            this.est = n;
        }

        public final long estimateSize() {
            return this.est;
        }
    }

    static final class SubMap<K, V>
    extends AbstractMap<K, V>
    implements ConcurrentNavigableMap<K, V>,
    Cloneable,
    Serializable {
        private static final long serialVersionUID = -7647078645895051609L;
        private final ConcurrentSkipListMap<K, V> m;
        private final K lo;
        private final K hi;
        private final boolean loInclusive;
        private final boolean hiInclusive;
        private final boolean isDescending;
        private transient KeySet<K> keySetView;
        private transient Set<Map.Entry<K, V>> entrySetView;
        private transient Collection<V> valuesView;

        SubMap(ConcurrentSkipListMap<K, V> concurrentSkipListMap, K k, boolean bl, K k2, boolean bl2, boolean bl3) {
            Comparator comparator = concurrentSkipListMap.comparator;
            if (k != null && k2 != null && ConcurrentSkipListMap.cpr(comparator, k, k2) > 0) {
                throw new IllegalArgumentException("inconsistent range");
            }
            this.m = concurrentSkipListMap;
            this.lo = k;
            this.hi = k2;
            this.loInclusive = bl;
            this.hiInclusive = bl2;
            this.isDescending = bl3;
        }

        boolean tooLow(Object object, Comparator<? super K> comparator) {
            int n;
            return this.lo != null && ((n = ConcurrentSkipListMap.cpr(comparator, object, this.lo)) < 0 || n == 0 && !this.loInclusive);
        }

        boolean tooHigh(Object object, Comparator<? super K> comparator) {
            int n;
            return this.hi != null && ((n = ConcurrentSkipListMap.cpr(comparator, object, this.hi)) > 0 || n == 0 && !this.hiInclusive);
        }

        boolean inBounds(Object object, Comparator<? super K> comparator) {
            return !this.tooLow(object, comparator) && !this.tooHigh(object, comparator);
        }

        void checkKeyBounds(K k, Comparator<? super K> comparator) {
            if (k == null) {
                throw new NullPointerException();
            }
            if (!this.inBounds(k, comparator)) {
                throw new IllegalArgumentException("key out of range");
            }
        }

        boolean isBeforeEnd(Node<K, V> node, Comparator<? super K> comparator) {
            if (node == null) {
                return false;
            }
            if (this.hi == null) {
                return true;
            }
            Object k = node.key;
            if (k == null) {
                return true;
            }
            int n = ConcurrentSkipListMap.cpr(comparator, k, this.hi);
            return n <= 0 && (n != 0 || this.hiInclusive);
        }

        Node<K, V> loNode(Comparator<? super K> comparator) {
            if (this.lo == null) {
                return this.m.findFirst();
            }
            if (this.loInclusive) {
                return this.m.findNear((K)this.lo, 1, comparator);
            }
            return this.m.findNear((K)this.lo, 0, comparator);
        }

        Node<K, V> hiNode(Comparator<? super K> comparator) {
            if (this.hi == null) {
                return this.m.findLast();
            }
            if (this.hiInclusive) {
                return this.m.findNear((K)this.hi, 3, comparator);
            }
            return this.m.findNear((K)this.hi, 2, comparator);
        }

        K lowestKey() {
            Comparator comparator = this.m.comparator;
            Node node = this.loNode(comparator);
            if (this.isBeforeEnd(node, comparator)) {
                return node.key;
            }
            throw new NoSuchElementException();
        }

        K highestKey() {
            Object k;
            Comparator comparator = this.m.comparator;
            Node node = this.hiNode(comparator);
            if (node != null && this.inBounds(k = node.key, comparator)) {
                return k;
            }
            throw new NoSuchElementException();
        }

        Map.Entry<K, V> lowestEntry() {
            Node node;
            AbstractMap.SimpleImmutableEntry simpleImmutableEntry;
            Comparator comparator = this.m.comparator;
            do {
                if (this.isBeforeEnd(node = this.loNode(comparator), comparator)) continue;
                return null;
            } while ((simpleImmutableEntry = node.createSnapshot()) == null);
            return simpleImmutableEntry;
        }

        Map.Entry<K, V> highestEntry() {
            Node node;
            AbstractMap.SimpleImmutableEntry simpleImmutableEntry;
            Comparator comparator = this.m.comparator;
            do {
                if ((node = this.hiNode(comparator)) != null && this.inBounds(node.key, comparator)) continue;
                return null;
            } while ((simpleImmutableEntry = node.createSnapshot()) == null);
            return simpleImmutableEntry;
        }

        Map.Entry<K, V> removeLowest() {
            Object k;
            V v;
            Comparator comparator = this.m.comparator;
            do {
                Node node;
                if ((node = this.loNode(comparator)) == null) {
                    return null;
                }
                k = node.key;
                if (this.inBounds(k, comparator)) continue;
                return null;
            } while ((v = this.m.doRemove(k, null)) == null);
            return new AbstractMap.SimpleImmutableEntry(k, v);
        }

        Map.Entry<K, V> removeHighest() {
            Object k;
            V v;
            Comparator comparator = this.m.comparator;
            do {
                Node node;
                if ((node = this.hiNode(comparator)) == null) {
                    return null;
                }
                k = node.key;
                if (this.inBounds(k, comparator)) continue;
                return null;
            } while ((v = this.m.doRemove(k, null)) == null);
            return new AbstractMap.SimpleImmutableEntry(k, v);
        }

        Map.Entry<K, V> getNearEntry(K k, int n) {
            Object k2;
            Node node;
            V v;
            Comparator comparator = this.m.comparator;
            if (this.isDescending) {
                n = (n & 2) == 0 ? (n |= 2) : (n &= 0xFFFFFFFD);
            }
            if (this.tooLow(k, comparator)) {
                return (n & 2) != 0 ? null : this.lowestEntry();
            }
            if (this.tooHigh(k, comparator)) {
                return (n & 2) != 0 ? this.highestEntry() : null;
            }
            do {
                if ((node = this.m.findNear(k, n, comparator)) == null || !this.inBounds(node.key, comparator)) {
                    return null;
                }
                k2 = node.key;
            } while ((v = node.getValidValue()) == null);
            return new AbstractMap.SimpleImmutableEntry(k2, v);
        }

        K getNearKey(K k, int n) {
            Object k2;
            Node node;
            V v;
            Comparator comparator = this.m.comparator;
            if (this.isDescending) {
                n = (n & 2) == 0 ? (n |= 2) : (n &= 0xFFFFFFFD);
            }
            if (this.tooLow(k, comparator)) {
                Node node2;
                if ((n & 2) == 0 && this.isBeforeEnd(node2 = this.loNode(comparator), comparator)) {
                    return node2.key;
                }
                return null;
            }
            if (this.tooHigh(k, comparator)) {
                Object k3;
                Node node3;
                if ((n & 2) != 0 && (node3 = this.hiNode(comparator)) != null && this.inBounds(k3 = node3.key, comparator)) {
                    return k3;
                }
                return null;
            }
            do {
                if ((node = this.m.findNear(k, n, comparator)) == null || !this.inBounds(node.key, comparator)) {
                    return null;
                }
                k2 = node.key;
            } while ((v = node.getValidValue()) == null);
            return k2;
        }

        @Override
        public boolean containsKey(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            return this.inBounds(object, this.m.comparator) && this.m.containsKey(object);
        }

        @Override
        public V get(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            return !this.inBounds(object, this.m.comparator) ? null : (V)this.m.get(object);
        }

        @Override
        public V put(K k, V v) {
            this.checkKeyBounds(k, this.m.comparator);
            return this.m.put(k, v);
        }

        @Override
        public V remove(Object object) {
            return !this.inBounds(object, this.m.comparator) ? null : (V)this.m.remove(object);
        }

        @Override
        public int size() {
            Comparator comparator = this.m.comparator;
            long l = 0L;
            Node node = this.loNode(comparator);
            while (this.isBeforeEnd(node, comparator)) {
                if (node.getValidValue() != null) {
                    ++l;
                }
                node = node.next;
            }
            return l >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
        }

        @Override
        public boolean isEmpty() {
            Comparator comparator = this.m.comparator;
            return !this.isBeforeEnd(this.loNode(comparator), comparator);
        }

        @Override
        public boolean containsValue(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            Comparator comparator = this.m.comparator;
            Node node = this.loNode(comparator);
            while (this.isBeforeEnd(node, comparator)) {
                V v = node.getValidValue();
                if (v != null && object.equals(v)) {
                    return true;
                }
                node = node.next;
            }
            return false;
        }

        @Override
        public void clear() {
            Comparator comparator = this.m.comparator;
            Node node = this.loNode(comparator);
            while (this.isBeforeEnd(node, comparator)) {
                if (node.getValidValue() != null) {
                    this.m.remove(node.key);
                }
                node = node.next;
            }
        }

        @Override
        public V putIfAbsent(K k, V v) {
            this.checkKeyBounds(k, this.m.comparator);
            return this.m.putIfAbsent(k, v);
        }

        @Override
        public boolean remove(Object object, Object object2) {
            return this.inBounds(object, this.m.comparator) && this.m.remove(object, object2);
        }

        @Override
        public boolean replace(K k, V v, V v2) {
            this.checkKeyBounds(k, this.m.comparator);
            return this.m.replace(k, v, v2);
        }

        @Override
        public V replace(K k, V v) {
            this.checkKeyBounds(k, this.m.comparator);
            return this.m.replace(k, v);
        }

        @Override
        public Comparator<? super K> comparator() {
            Comparator<K> comparator = this.m.comparator();
            if (this.isDescending) {
                return Collections.reverseOrder(comparator);
            }
            return comparator;
        }

        SubMap<K, V> newSubMap(K k, boolean bl, K k2, boolean bl2) {
            Comparator comparator = this.m.comparator;
            if (this.isDescending) {
                K k3 = k;
                k = k2;
                k2 = k3;
                boolean bl3 = bl;
                bl = bl2;
                bl2 = bl3;
            }
            if (this.lo != null) {
                if (k == null) {
                    k = this.lo;
                    bl = this.loInclusive;
                } else {
                    int n = ConcurrentSkipListMap.cpr(comparator, k, this.lo);
                    if (n < 0 || n == 0 && !this.loInclusive && bl) {
                        throw new IllegalArgumentException("key out of range");
                    }
                }
            }
            if (this.hi != null) {
                if (k2 == null) {
                    k2 = this.hi;
                    bl2 = this.hiInclusive;
                } else {
                    int n = ConcurrentSkipListMap.cpr(comparator, k2, this.hi);
                    if (n > 0 || n == 0 && !this.hiInclusive && bl2) {
                        throw new IllegalArgumentException("key out of range");
                    }
                }
            }
            return new SubMap<K, V>(this.m, k, bl, k2, bl2, this.isDescending);
        }

        @Override
        public SubMap<K, V> subMap(K k, boolean bl, K k2, boolean bl2) {
            if (k == null || k2 == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(k, bl, k2, bl2);
        }

        @Override
        public SubMap<K, V> headMap(K k, boolean bl) {
            if (k == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(null, false, k, bl);
        }

        @Override
        public SubMap<K, V> tailMap(K k, boolean bl) {
            if (k == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(k, bl, null, false);
        }

        @Override
        public SubMap<K, V> subMap(K k, K k2) {
            return this.subMap((Object)k, true, (Object)k2, false);
        }

        @Override
        public SubMap<K, V> headMap(K k) {
            return this.headMap((Object)k, false);
        }

        @Override
        public SubMap<K, V> tailMap(K k) {
            return this.tailMap((Object)k, true);
        }

        @Override
        public SubMap<K, V> descendingMap() {
            return new SubMap<K, V>(this.m, this.lo, this.loInclusive, this.hi, this.hiInclusive, !this.isDescending);
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K k) {
            return this.getNearEntry(k, 1);
        }

        @Override
        public K ceilingKey(K k) {
            return this.getNearKey(k, 1);
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K k) {
            return this.getNearEntry(k, 2);
        }

        @Override
        public K lowerKey(K k) {
            return this.getNearKey(k, 2);
        }

        @Override
        public Map.Entry<K, V> floorEntry(K k) {
            return this.getNearEntry(k, 3);
        }

        @Override
        public K floorKey(K k) {
            return this.getNearKey(k, 3);
        }

        @Override
        public Map.Entry<K, V> higherEntry(K k) {
            return this.getNearEntry(k, 0);
        }

        @Override
        public K higherKey(K k) {
            return this.getNearKey(k, 0);
        }

        @Override
        public K firstKey() {
            return this.isDescending ? this.highestKey() : this.lowestKey();
        }

        @Override
        public K lastKey() {
            return this.isDescending ? this.lowestKey() : this.highestKey();
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            return this.isDescending ? this.highestEntry() : this.lowestEntry();
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            return this.isDescending ? this.lowestEntry() : this.highestEntry();
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            return this.isDescending ? this.removeHighest() : this.removeLowest();
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            return this.isDescending ? this.removeLowest() : this.removeHighest();
        }

        @Override
        public NavigableSet<K> keySet() {
            KeySet<K> keySet = this.keySetView;
            return keySet != null ? keySet : (this.keySetView = new KeySet(this));
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            KeySet<K> keySet = this.keySetView;
            return keySet != null ? keySet : (this.keySetView = new KeySet(this));
        }

        @Override
        public Collection<V> values() {
            Collection<V> collection = this.valuesView;
            return collection != null ? collection : (this.valuesView = new Values<V>(this));
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Set<Map.Entry<K, V>> set = this.entrySetView;
            return set != null ? set : (this.entrySetView = new EntrySet<K, V>(this));
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return ((SubMap)this.descendingMap()).navigableKeySet();
        }

        Iterator<K> keyIterator() {
            return new SubMapKeyIterator();
        }

        Iterator<V> valueIterator() {
            return new SubMapValueIterator();
        }

        Iterator<Map.Entry<K, V>> entryIterator() {
            return new SubMapEntryIterator();
        }

        final class SubMapEntryIterator
        extends SubMapIter<Map.Entry<K, V>> {
            SubMapEntryIterator() {
            }

            @Override
            public Map.Entry<K, V> next() {
                Node node = this.next;
                Object object = this.nextValue;
                this.advance();
                return new AbstractMap.SimpleImmutableEntry(node.key, object);
            }

            @Override
            public int characteristics() {
                return 1;
            }
        }

        final class SubMapKeyIterator
        extends SubMapIter<K> {
            SubMapKeyIterator() {
            }

            @Override
            public K next() {
                Node node = this.next;
                this.advance();
                return node.key;
            }

            @Override
            public int characteristics() {
                return 21;
            }

            @Override
            public final Comparator<? super K> getComparator() {
                return SubMap.this.comparator();
            }
        }

        final class SubMapValueIterator
        extends SubMapIter<V> {
            SubMapValueIterator() {
            }

            @Override
            public V next() {
                Object object = this.nextValue;
                this.advance();
                return object;
            }

            @Override
            public int characteristics() {
                return 0;
            }
        }

        abstract class SubMapIter<T>
        implements Iterator<T>,
        Spliterator<T> {
            Node<K, V> lastReturned;
            Node<K, V> next;
            V nextValue;

            SubMapIter() {
                block3: {
                    Object object;
                    Comparator comparator = ((SubMap)SubMap.this).m.comparator;
                    do {
                        Node node = this.next = SubMap.this.isDescending ? SubMap.this.hiNode(comparator) : SubMap.this.loNode(comparator);
                        if (this.next == null) break block3;
                    } while ((object = this.next.value) == null || object == this.next);
                    if (!SubMap.this.inBounds(this.next.key, comparator)) {
                        this.next = null;
                    } else {
                        Object object2 = object;
                        this.nextValue = object2;
                    }
                }
            }

            @Override
            public final boolean hasNext() {
                return this.next != null;
            }

            final void advance() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.next;
                if (SubMap.this.isDescending) {
                    this.descend();
                } else {
                    this.ascend();
                }
            }

            private void ascend() {
                block3: {
                    Object object;
                    Comparator comparator = ((SubMap)SubMap.this).m.comparator;
                    do {
                        this.next = this.next.next;
                        if (this.next == null) break block3;
                    } while ((object = this.next.value) == null || object == this.next);
                    if (SubMap.this.tooHigh(this.next.key, comparator)) {
                        this.next = null;
                    } else {
                        Object object2 = object;
                        this.nextValue = object2;
                    }
                }
            }

            private void descend() {
                block3: {
                    Object object;
                    Comparator comparator = ((SubMap)SubMap.this).m.comparator;
                    do {
                        this.next = SubMap.this.m.findNear(this.lastReturned.key, 2, comparator);
                        if (this.next == null) break block3;
                    } while ((object = this.next.value) == null || object == this.next);
                    if (SubMap.this.tooLow(this.next.key, comparator)) {
                        this.next = null;
                    } else {
                        Object object2 = object;
                        this.nextValue = object2;
                    }
                }
            }

            @Override
            public void remove() {
                Node node = this.lastReturned;
                if (node == null) {
                    throw new IllegalStateException();
                }
                SubMap.this.m.remove(node.key);
                this.lastReturned = null;
            }

            @Override
            public Spliterator<T> trySplit() {
                return null;
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> consumer) {
                if (this.hasNext()) {
                    consumer.accept(this.next());
                    return true;
                }
                return false;
            }

            @Override
            public void forEachRemaining(Consumer<? super T> consumer) {
                while (this.hasNext()) {
                    consumer.accept(this.next());
                }
            }

            @Override
            public long estimateSize() {
                return Long.MAX_VALUE;
            }
        }
    }

    static final class EntrySet<K1, V1>
    extends AbstractSet<Map.Entry<K1, V1>> {
        final ConcurrentNavigableMap<K1, V1> m;

        EntrySet(ConcurrentNavigableMap<K1, V1> concurrentNavigableMap) {
            this.m = concurrentNavigableMap;
        }

        @Override
        public Iterator<Map.Entry<K1, V1>> iterator() {
            if (this.m instanceof ConcurrentSkipListMap) {
                return ((ConcurrentSkipListMap)this.m).entryIterator();
            }
            return ((SubMap)this.m).entryIterator();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object v = this.m.get(entry.getKey());
            return v != null && v.equals(entry.getValue());
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return this.m.remove(entry.getKey(), entry.getValue());
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Set)) {
                return false;
            }
            Collection collection = (Collection)object;
            try {
                return this.containsAll(collection) && collection.containsAll(this);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }

        @Override
        public Object[] toArray() {
            return ConcurrentSkipListMap.toList(this).toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return ConcurrentSkipListMap.toList(this).toArray(TArray);
        }

        @Override
        public Spliterator<Map.Entry<K1, V1>> spliterator() {
            if (this.m instanceof ConcurrentSkipListMap) {
                return ((ConcurrentSkipListMap)this.m).entrySpliterator();
            }
            return (Spliterator)((Object)((SubMap)this.m).entryIterator());
        }
    }

    static final class Values<E>
    extends AbstractCollection<E> {
        final ConcurrentNavigableMap<?, E> m;

        Values(ConcurrentNavigableMap<?, E> concurrentNavigableMap) {
            this.m = concurrentNavigableMap;
        }

        @Override
        public Iterator<E> iterator() {
            if (this.m instanceof ConcurrentSkipListMap) {
                return ((ConcurrentSkipListMap)this.m).valueIterator();
            }
            return ((SubMap)this.m).valueIterator();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean contains(Object object) {
            return this.m.containsValue(object);
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public Object[] toArray() {
            return ConcurrentSkipListMap.toList(this).toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return ConcurrentSkipListMap.toList(this).toArray(TArray);
        }

        @Override
        public Spliterator<E> spliterator() {
            if (this.m instanceof ConcurrentSkipListMap) {
                return ((ConcurrentSkipListMap)this.m).valueSpliterator();
            }
            return (Spliterator)((Object)((SubMap)this.m).valueIterator());
        }
    }

    static final class KeySet<E>
    extends AbstractSet<E>
    implements NavigableSet<E> {
        final ConcurrentNavigableMap<E, ?> m;

        KeySet(ConcurrentNavigableMap<E, ?> concurrentNavigableMap) {
            this.m = concurrentNavigableMap;
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.m.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return this.m.remove(object) != null;
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public E lower(E e) {
            return this.m.lowerKey(e);
        }

        @Override
        public E floor(E e) {
            return this.m.floorKey(e);
        }

        @Override
        public E ceiling(E e) {
            return this.m.ceilingKey(e);
        }

        @Override
        public E higher(E e) {
            return this.m.higherKey(e);
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.m.comparator();
        }

        @Override
        public E first() {
            return (E)this.m.firstKey();
        }

        @Override
        public E last() {
            return (E)this.m.lastKey();
        }

        @Override
        public E pollFirst() {
            Map.Entry entry = this.m.pollFirstEntry();
            return entry == null ? null : (E)entry.getKey();
        }

        @Override
        public E pollLast() {
            Map.Entry entry = this.m.pollLastEntry();
            return entry == null ? null : (E)entry.getKey();
        }

        @Override
        public Iterator<E> iterator() {
            if (this.m instanceof ConcurrentSkipListMap) {
                return ((ConcurrentSkipListMap)this.m).keyIterator();
            }
            return ((SubMap)this.m).keyIterator();
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Set)) {
                return false;
            }
            Collection collection = (Collection)object;
            try {
                return this.containsAll(collection) && collection.containsAll(this);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }

        @Override
        public Object[] toArray() {
            return ConcurrentSkipListMap.toList(this).toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return ConcurrentSkipListMap.toList(this).toArray(TArray);
        }

        @Override
        public Iterator<E> descendingIterator() {
            return this.descendingSet().iterator();
        }

        @Override
        public NavigableSet<E> subSet(E e, boolean bl, E e2, boolean bl2) {
            return new KeySet<E>(this.m.subMap((Object)e, bl, (Object)e2, bl2));
        }

        @Override
        public NavigableSet<E> headSet(E e, boolean bl) {
            return new KeySet<E>(this.m.headMap((Object)e, bl));
        }

        @Override
        public NavigableSet<E> tailSet(E e, boolean bl) {
            return new KeySet<E>(this.m.tailMap((Object)e, bl));
        }

        @Override
        public NavigableSet<E> subSet(E e, E e2) {
            return this.subSet(e, true, e2, false);
        }

        @Override
        public NavigableSet<E> headSet(E e) {
            return this.headSet(e, false);
        }

        @Override
        public NavigableSet<E> tailSet(E e) {
            return this.tailSet(e, true);
        }

        @Override
        public NavigableSet<E> descendingSet() {
            return new KeySet<E>(this.m.descendingMap());
        }

        @Override
        public Spliterator<E> spliterator() {
            if (this.m instanceof ConcurrentSkipListMap) {
                return ((ConcurrentSkipListMap)this.m).keySpliterator();
            }
            return (Spliterator)((Object)((SubMap)this.m).keyIterator());
        }
    }

    final class EntryIterator
    extends Iter<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            Node node = this.next;
            Object object = this.nextValue;
            this.advance();
            return new AbstractMap.SimpleImmutableEntry(node.key, object);
        }
    }

    final class KeyIterator
    extends Iter<K> {
        KeyIterator() {
        }

        @Override
        public K next() {
            Node node = this.next;
            this.advance();
            return node.key;
        }
    }

    final class ValueIterator
    extends Iter<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            Object object = this.nextValue;
            this.advance();
            return object;
        }
    }

    abstract class Iter<T>
    implements Iterator<T> {
        Node<K, V> lastReturned;
        Node<K, V> next;
        V nextValue;

        Iter() {
            while ((this.next = ConcurrentSkipListMap.this.findFirst()) != null) {
                Object object = this.next.value;
                if (object == null || object == this.next) continue;
                Object object2 = object;
                this.nextValue = object2;
                break;
            }
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final void advance() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            while ((this.next = this.next.next) != null) {
                Object object = this.next.value;
                if (object == null || object == this.next) continue;
                Object object2 = object;
                this.nextValue = object2;
                break;
            }
        }

        @Override
        public void remove() {
            Node node = this.lastReturned;
            if (node == null) {
                throw new IllegalStateException();
            }
            ConcurrentSkipListMap.this.remove(node.key);
            this.lastReturned = null;
        }
    }

    static final class HeadIndex<K, V>
    extends Index<K, V> {
        final int level;

        HeadIndex(Node<K, V> node, Index<K, V> index, Index<K, V> index2, int n) {
            super(node, index, index2);
            this.level = n;
        }
    }

    static class Index<K, V> {
        final Node<K, V> node;
        final Index<K, V> down;
        volatile Index<K, V> right;
        private static final Unsafe UNSAFE;
        private static final long rightOffset;

        Index(Node<K, V> node, Index<K, V> index, Index<K, V> index2) {
            this.node = node;
            this.down = index;
            this.right = index2;
        }

        final boolean casRight(Index<K, V> index, Index<K, V> index2) {
            return UNSAFE.compareAndSwapObject(this, rightOffset, index, index2);
        }

        final boolean indexesDeletedNode() {
            return this.node.value == null;
        }

        final boolean link(Index<K, V> index, Index<K, V> index2) {
            Node<K, V> node = this.node;
            index2.right = index;
            return node.value != null && this.casRight(index, index2);
        }

        final boolean unlink(Index<K, V> index) {
            return this.node.value != null && this.casRight(index, index.right);
        }

        static {
            try {
                UNSAFE = Unsafe.getUnsafe();
                Class<Index> clazz = Index.class;
                rightOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("right"));
            }
            catch (Exception exception) {
                throw new Error(exception);
            }
        }
    }

    static final class Node<K, V> {
        final K key;
        volatile Object value;
        volatile Node<K, V> next;
        private static final Unsafe UNSAFE;
        private static final long valueOffset;
        private static final long nextOffset;

        Node(K k, Object object, Node<K, V> node) {
            this.key = k;
            this.value = object;
            this.next = node;
        }

        Node(Node<K, V> node) {
            this.key = null;
            this.value = this;
            this.next = node;
        }

        boolean casValue(Object object, Object object2) {
            return UNSAFE.compareAndSwapObject(this, valueOffset, object, object2);
        }

        boolean casNext(Node<K, V> node, Node<K, V> node2) {
            return UNSAFE.compareAndSwapObject(this, nextOffset, node, node2);
        }

        boolean isMarker() {
            return this.value == this;
        }

        boolean isBaseHeader() {
            return this.value == BASE_HEADER;
        }

        boolean appendMarker(Node<K, V> node) {
            return this.casNext(node, new Node<K, V>(node));
        }

        void helpDelete(Node<K, V> node, Node<K, V> node2) {
            if (node2 == this.next && this == node.next) {
                if (node2 == null || node2.value != node2) {
                    this.casNext(node2, new Node<K, V>(node2));
                } else {
                    node.casNext(this, node2.next);
                }
            }
        }

        V getValidValue() {
            Object object = this.value;
            if (object == this || object == BASE_HEADER) {
                return null;
            }
            Object object2 = object;
            return (V)object2;
        }

        AbstractMap.SimpleImmutableEntry<K, V> createSnapshot() {
            Object object = this.value;
            if (object == null || object == this || object == BASE_HEADER) {
                return null;
            }
            Object object2 = object;
            return new AbstractMap.SimpleImmutableEntry<K, Object>(this.key, object2);
        }

        static {
            try {
                UNSAFE = Unsafe.getUnsafe();
                Class<Node> clazz = Node.class;
                valueOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("value"));
                nextOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("next"));
            }
            catch (Exception exception) {
                throw new Error(exception);
            }
        }
    }
}

