/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.controlpanel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import net.sourceforge.jnlp.ShortcutDesc;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.controlpanel.ComboItem;
import net.sourceforge.jnlp.controlpanel.NamedBorderPanel;
import net.sourceforge.jnlp.controlpanel.desktopintegrationeditor.FreeDesktopIntegrationEditorFrame;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;

public class DesktopShortcutPanel
extends NamedBorderPanel
implements ItemListener {
    private final DeploymentConfiguration config;
    private FreeDesktopIntegrationEditorFrame integrationManagment;

    public DesktopShortcutPanel(DeploymentConfiguration config) {
        super(Translator.R("CPHeadDesktopIntegration"), new GridBagLayout());
        this.config = config;
        this.addComponents();
    }

    public static ComboItem deploymentJavawsShortcutToComboItem(String i) {
        return new ComboItem(ShortcutDesc.deploymentJavawsShortcutToString(i), i);
    }

    private void addComponents() {
        GridBagConstraints c = new GridBagConstraints();
        JLabel description = new JLabel("<html>" + Translator.R("CPDesktopIntegrationDescription") + "<hr /></html>");
        JComboBox<ComboItem> shortcutComboOptions = new JComboBox<ComboItem>();
        JButton manageIntegrationsButton = new JButton(Translator.R("CPDesktopIntegrationShowIntegrations"));
        if (JNLPRuntime.isWindows()) {
            manageIntegrationsButton.setToolTipText(Translator.R("CPDesktopIntegrationLinuxOnly"));
            manageIntegrationsButton.setEnabled(false);
        }
        manageIntegrationsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (DesktopShortcutPanel.this.integrationManagment == null) {
                            DesktopShortcutPanel.this.integrationManagment = new FreeDesktopIntegrationEditorFrame();
                        }
                        DesktopShortcutPanel.this.integrationManagment.setVisible(true);
                    }
                });
            }
        });
        ComboItem[] items = new ComboItem[]{DesktopShortcutPanel.deploymentJavawsShortcutToComboItem("NEVER"), DesktopShortcutPanel.deploymentJavawsShortcutToComboItem("ALWAYS"), DesktopShortcutPanel.deploymentJavawsShortcutToComboItem("ASK_USER"), DesktopShortcutPanel.deploymentJavawsShortcutToComboItem("ASK_IF_HINTED"), DesktopShortcutPanel.deploymentJavawsShortcutToComboItem("ALWAYS_IF_HINTED")};
        shortcutComboOptions.setActionCommand("deployment.javaws.shortcut");
        for (int j = 0; j < items.length; ++j) {
            shortcutComboOptions.addItem(items[j]);
            if (!this.config.getProperty("deployment.javaws.shortcut").equals(items[j].getValue())) continue;
            shortcutComboOptions.setSelectedIndex(j);
        }
        shortcutComboOptions.addItemListener(this);
        c.fill = 1;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)description, c);
        c.gridy = 1;
        this.add(shortcutComboOptions, c);
        c.gridy = 2;
        this.add((Component)manageIntegrationsButton, c);
        Component filler = Box.createRigidArea(new Dimension(1, 1));
        ++c.gridy;
        c.weighty = 1.0;
        this.add(filler, c);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ComboItem c = (ComboItem)e.getItem();
        this.config.setProperty(((JComboBox)e.getSource()).getActionCommand(), c.getValue());
    }
}

