/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.internal.classloader.CachingClassLoader;
import org.gradle.internal.classloader.ClassLoaderFactory;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.MutableURLClassLoader;
import org.gradle.internal.classpath.ClassPath;

public class DefaultClassLoaderRegistry
implements ClassLoaderRegistry {
    private final ClassLoader apiOnlyClassLoader;
    private final ClassLoader apiAndPluginsClassLoader;
    private final ClassLoader extensionsClassLoader;
    private final ClassLoaderFactory classLoaderFactory;

    public DefaultClassLoaderRegistry(ClassPathRegistry classPathRegistry, ClassLoaderFactory classLoaderFactory) {
        this.classLoaderFactory = classLoaderFactory;
        ClassLoader runtimeClassLoader = this.getClass().getClassLoader();
        this.apiOnlyClassLoader = this.restrictToGradleApi(runtimeClassLoader);
        ClassPath pluginsClassPath = classPathRegistry.getClassPath("GRADLE_EXTENSIONS");
        this.extensionsClassLoader = new MutableURLClassLoader(runtimeClassLoader, pluginsClassPath);
        this.apiAndPluginsClassLoader = this.restrictToGradleApi(this.extensionsClassLoader);
    }

    private ClassLoader restrictToGradleApi(ClassLoader classLoader) {
        FilteringClassLoader rootClassLoader = this.classLoaderFactory.createFilteringClassLoader(classLoader);
        rootClassLoader.allowPackage("org.gradle");
        rootClassLoader.allowResources("META-INF/gradle-plugins");
        rootClassLoader.allowPackage("org.apache.tools.ant");
        rootClassLoader.allowPackage("groovy");
        rootClassLoader.allowPackage("org.codehaus.groovy");
        rootClassLoader.allowPackage("groovyjarjarantlr");
        rootClassLoader.allowPackage("org.slf4j");
        rootClassLoader.allowPackage("org.apache.commons.logging");
        rootClassLoader.allowPackage("org.apache.log4j");
        rootClassLoader.allowPackage("javax.inject");
        return new CachingClassLoader((ClassLoader)rootClassLoader);
    }

    public ClassLoader getRuntimeClassLoader() {
        return this.getClass().getClassLoader();
    }

    public ClassLoader getGradleApiClassLoader() {
        return this.apiAndPluginsClassLoader;
    }

    public ClassLoader getPluginsClassLoader() {
        return this.extensionsClassLoader;
    }

    public ClassLoader getGradleCoreApiClassLoader() {
        return this.apiOnlyClassLoader;
    }
}

