/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging;

import org.gradle.api.Action;
import org.gradle.cli.CommandLineConverter;
import org.gradle.internal.Actions;
import org.gradle.internal.TimeProvider;
import org.gradle.internal.TrueTimeProvider;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.logging.LoggingConfiguration;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.logging.ProgressLoggerFactory;
import org.gradle.logging.StyledTextOutputFactory;
import org.gradle.logging.internal.ConsoleConfigureAction;
import org.gradle.logging.internal.DefaultLoggingConfigurer;
import org.gradle.logging.internal.DefaultLoggingManagerFactory;
import org.gradle.logging.internal.DefaultProgressLoggerFactory;
import org.gradle.logging.internal.DefaultStdErrLoggingSystem;
import org.gradle.logging.internal.DefaultStdOutLoggingSystem;
import org.gradle.logging.internal.DefaultStyledTextOutputFactory;
import org.gradle.logging.internal.JavaUtilLoggingSystem;
import org.gradle.logging.internal.LoggingCommandLineConverter;
import org.gradle.logging.internal.NoOpLoggingSystem;
import org.gradle.logging.internal.OutputEventListener;
import org.gradle.logging.internal.OutputEventRenderer;
import org.gradle.logging.internal.ProgressLoggingBridge;
import org.gradle.logging.internal.TextStreamOutputEventListener;
import org.gradle.logging.internal.slf4j.Slf4jLoggingConfigurer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LoggingServiceRegistry
extends DefaultServiceRegistry {
    private TextStreamOutputEventListener stdoutListener;

    public static LoggingServiceRegistry newCommandLineProcessLogging() {
        CommandLineLogging loggingServices = new CommandLineLogging();
        LoggingManagerInternal rootLoggingManager = ((DefaultLoggingManagerFactory)loggingServices.get(DefaultLoggingManagerFactory.class)).getRoot();
        rootLoggingManager.captureSystemSources();
        rootLoggingManager.attachSystemOutAndErr();
        return loggingServices;
    }

    public static LoggingServiceRegistry newEmbeddableLogging() {
        return new CommandLineLogging();
    }

    public static LoggingServiceRegistry newNestedLogging() {
        return new NestedLogging();
    }

    protected CommandLineConverter<LoggingConfiguration> createCommandLineConverter() {
        return new LoggingCommandLineConverter();
    }

    protected TimeProvider createTimeProvider() {
        return new TrueTimeProvider();
    }

    protected StyledTextOutputFactory createStyledTextOutputFactory() {
        return new DefaultStyledTextOutputFactory(this.getStdoutListener(), (TimeProvider)this.get(TimeProvider.class));
    }

    protected TextStreamOutputEventListener getStdoutListener() {
        if (this.stdoutListener == null) {
            this.stdoutListener = new TextStreamOutputEventListener((OutputEventListener)this.get(OutputEventListener.class));
        }
        return this.stdoutListener;
    }

    protected ProgressLoggerFactory createProgressLoggerFactory() {
        return new DefaultProgressLoggerFactory(new ProgressLoggingBridge((OutputEventListener)this.get(OutputEventListener.class)), (TimeProvider)this.get(TimeProvider.class));
    }

    protected abstract DefaultLoggingManagerFactory createLoggingManagerFactory();

    protected OutputEventRenderer createOutputEventRenderer() {
        return new OutputEventRenderer((Action<? super OutputEventRenderer>)Actions.doNothing());
    }

    private static class NestedLogging
    extends LoggingServiceRegistry {
        private NestedLogging() {
        }

        protected DefaultLoggingManagerFactory createLoggingManagerFactory() {
            OutputEventRenderer renderer = (OutputEventRenderer)this.get(OutputEventRenderer.class);
            return new DefaultLoggingManagerFactory(renderer, renderer, new NoOpLoggingSystem(), new NoOpLoggingSystem(), new NoOpLoggingSystem());
        }
    }

    private static class CommandLineLogging
    extends LoggingServiceRegistry {
        private CommandLineLogging() {
        }

        protected DefaultLoggingManagerFactory createLoggingManagerFactory() {
            OutputEventRenderer renderer = (OutputEventRenderer)this.get(OutputEventRenderer.class);
            DefaultStdOutLoggingSystem stdout = new DefaultStdOutLoggingSystem(this.getStdoutListener(), (TimeProvider)this.get(TimeProvider.class));
            DefaultStdErrLoggingSystem stderr = new DefaultStdErrLoggingSystem(new TextStreamOutputEventListener((OutputEventListener)this.get(OutputEventListener.class)), (TimeProvider)this.get(TimeProvider.class));
            return new DefaultLoggingManagerFactory(new DefaultLoggingConfigurer(renderer, new Slf4jLoggingConfigurer(renderer)), renderer, new JavaUtilLoggingSystem(), stdout, stderr);
        }

        protected OutputEventRenderer createOutputEventRenderer() {
            return new OutputEventRenderer(new ConsoleConfigureAction());
        }
    }
}

