/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.jetty;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.plugins.jetty.AbstractJettyRunTask;
import org.gradle.api.plugins.jetty.internal.Jetty6PluginServer;
import org.gradle.api.plugins.jetty.internal.JettyPluginServer;
import org.gradle.api.tasks.InputFile;
import org.mortbay.util.Scanner;
import org.mortbay.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyRunWar
extends AbstractJettyRunTask {
    private static Logger logger = LoggerFactory.getLogger(JettyRunWar.class);
    private File webApp;

    public void configureWebApplication() throws Exception {
        super.configureWebApplication();
        this.getWebAppConfig().setWar(this.getWebApp().getCanonicalPath());
        this.getWebAppConfig().configure();
    }

    public void validateConfiguration() {
    }

    public void configureScanner() {
        ArrayList<File> scanList = new ArrayList<File>();
        scanList.add(this.getProject().getBuildFile());
        scanList.add(this.getWebApp());
        this.getScanner().setScanDirs(scanList);
        ArrayList<Scanner.Listener> listeners = new ArrayList<Scanner.Listener>();
        listeners.add((Scanner.Listener)new Scanner.BulkListener(){

            public void filesChanged(List changes) {
                try {
                    boolean reconfigure = changes.contains(JettyRunWar.this.getProject().getBuildFile().getCanonicalPath());
                    JettyRunWar.this.restartWebApp(reconfigure);
                }
                catch (Exception e) {
                    logger.error("Error reconfiguring/restarting webapp after change in watched files", (Throwable)e);
                }
            }
        });
        this.setScannerListeners(listeners);
    }

    public void restartWebApp(boolean reconfigureScanner) throws Exception {
        logger.info("Restarting webapp ...");
        logger.debug("Stopping webapp ...");
        this.getWebAppConfig().stop();
        logger.debug("Reconfiguring webapp ...");
        this.validateConfiguration();
        if (reconfigureScanner) {
            logger.info("Reconfiguring scanner ...");
            ArrayList<File> scanList = new ArrayList<File>();
            scanList.add(this.getProject().getBuildFile());
            scanList.add(this.getWebApp());
            this.getScanner().setScanDirs(scanList);
        }
        logger.debug("Restarting webapp ...");
        this.getWebAppConfig().start();
        logger.info("Restart completed.");
    }

    public void finishConfigurationBeforeStart() {
    }

    @InputFile
    public File getWebApp() {
        return this.webApp;
    }

    public void setWebApp(File webApp) {
        this.webApp = webApp;
    }

    public void applyJettyXml() throws Exception {
        if (this.getJettyConfig() == null) {
            return;
        }
        logger.info("Configuring Jetty from xml configuration file = {}", (Object)this.getJettyConfig());
        XmlConfiguration xmlConfiguration = new XmlConfiguration(this.getJettyConfig().toURI().toURL());
        xmlConfiguration.configure(this.getServer().getProxiedObject());
    }

    public JettyPluginServer createServer() throws Exception {
        return new Jetty6PluginServer();
    }
}

