/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.results;

import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.tasks.testing.TestOutputEvent;

public class AttachParentTestResultProcessor
implements TestResultProcessor {
    private Object rootId;
    private final TestResultProcessor processor;

    public AttachParentTestResultProcessor(TestResultProcessor processor) {
        this.processor = processor;
    }

    public void started(TestDescriptorInternal test, TestStartEvent event) {
        if (this.rootId == null) {
            assert (test.isComposite());
            this.rootId = test.getId();
        } else if (event.getParentId() == null) {
            event = event.withParentId(this.rootId);
        }
        this.processor.started(test, event);
    }

    public void failure(Object testId, Throwable result) {
        this.processor.failure(testId, result);
    }

    public void output(Object testId, TestOutputEvent event) {
        this.processor.output(testId, event);
    }

    public void completed(Object testId, TestCompleteEvent event) {
        if (testId.equals(this.rootId)) {
            this.rootId = null;
        }
        this.processor.completed(testId, event);
    }
}

