/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import org.gradle.api.IllegalDependencyNotation;
import org.gradle.util.GUtil;

public class ParsedModuleStringNotation {
    private String group;
    private String name;
    private String version;
    private String classifier;
    private String artifactType;

    public ParsedModuleStringNotation(String moduleNotation, String artifactType) {
        this.assignValuesFromModuleNotation(moduleNotation);
        this.artifactType = artifactType;
    }

    private void assignValuesFromModuleNotation(String moduleNotation) {
        String[] moduleNotationParts = moduleNotation.split(":");
        if (moduleNotationParts.length < 2 || moduleNotationParts.length > 4) {
            throw new IllegalDependencyNotation("Supplied String module notation '" + moduleNotation + "' is invalid. Example notations: 'org.gradle:gradle-core:2.2', 'org.mockito:mockito-core:1.9.5:javadoc'.");
        }
        this.group = (String)GUtil.elvis((Object)moduleNotationParts[0], null);
        this.name = moduleNotationParts[1];
        String string = this.version = moduleNotationParts.length == 2 ? null : moduleNotationParts[2];
        if (moduleNotationParts.length == 4) {
            this.classifier = moduleNotationParts[3];
        }
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getArtifactType() {
        return this.artifactType;
    }
}

