/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.news;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import javax.inject.Named;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.news.FetchLatestNewsRequest;
import org.pdfsam.news.LatestNewsEvent;
import org.pdfsam.news.NewsData;
import org.pdfsam.news.NewsService;
import org.pdfsam.news.ShowNewsPanelRequest;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class LatestNewsController {
    private static final Logger LOG = LoggerFactory.getLogger(LatestNewsController.class);
    private NewsService service;
    private int currentLatest = -1;

    @Inject
    LatestNewsController(NewsService service) {
        this.service = service;
        StaticStudio.eventStudio().addAnnotatedListeners(this);
    }

    @EventListener
    public void fetchLatestNews(FetchLatestNewsRequest event) {
        LOG.debug(DefaultI18nContext.getInstance().i18n("Fetching latest news"));
        ((CompletableFuture)CompletableFuture.supplyAsync(this.service::getLatestNews).thenAccept(current -> {
            if (Objects.nonNull(current) && !current.isEmpty()) {
                this.currentLatest = ((NewsData)current.get(0)).getId();
                StaticStudio.eventStudio().broadcast(new LatestNewsEvent((List<NewsData>)current, this.service.getLatestNewsSeen() >= this.currentLatest));
            }
        })).whenComplete((r, e) -> {
            if (Objects.nonNull(e)) {
                LOG.warn(DefaultI18nContext.getInstance().i18n("Unable to retrieve the latest news"), (Throwable)e);
            }
        });
    }

    @EventListener
    public void onShowNewsPanel(ShowNewsPanelRequest req) {
        if (this.service.getLatestNewsSeen() < this.currentLatest) {
            this.service.setLatestNewsSeen(this.currentLatest);
        }
    }
}

