/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component.optimizaton;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.sejda.impl.sambox.component.optimizaton.DocumentOptimizer;
import org.sejda.impl.sambox.component.optimizaton.ImagesHitter;
import org.sejda.impl.sambox.component.optimizaton.ImagesOptimizer;
import org.sejda.impl.sambox.component.optimizaton.Optimizers;
import org.sejda.model.optimization.Optimization;
import org.sejda.model.parameter.OptimizeParameters;
import org.sejda.sambox.pdmodel.PDPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagesOptimizer
implements Consumer<PDPage> {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentOptimizer.class);
    private Consumer<PDPage> optimizer = p -> LOG.trace("Optimizing page");

    public PagesOptimizer(OptimizeParameters parameters) {
        Set<Optimization> optimizations = Optional.ofNullable(parameters).map(OptimizeParameters::getOptimizations).orElse(Collections.emptySet());
        optimizations.forEach(o -> Optional.ofNullable(Optimizers.pageOptimizer(o, parameters)).ifPresent(toAdd -> {
            this.optimizer = this.optimizer.andThen((Consumer<PDPage>)toAdd);
        }));
        if (optimizations.stream().anyMatch(ImagesOptimizer::canOptimizeFor)) {
            this.optimizer = this.optimizer.andThen(new ImagesOptimizer(parameters));
        }
        if (optimizations.contains(Optimization.DISCARD_UNUSED_IMAGES)) {
            this.optimizer = this.optimizer.andThen(new ImagesHitter());
        }
    }

    @Override
    public void accept(PDPage d) {
        this.optimizer.accept(d);
    }
}

