/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.userinterface.swing.generic.tabs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.foundation.CommandLineAssistant;
import org.gradle.foundation.ProjectView;
import org.gradle.foundation.TaskView;
import org.gradle.gradleplugin.foundation.GradlePluginLord;
import org.gradle.gradleplugin.foundation.filters.AllowAllProjectAndTaskFilter;
import org.gradle.gradleplugin.foundation.filters.BasicFilterEditor;
import org.gradle.gradleplugin.foundation.filters.BasicProjectAndTaskFilter;
import org.gradle.gradleplugin.foundation.request.ExecutionRequest;
import org.gradle.gradleplugin.foundation.request.RefreshTaskListRequest;
import org.gradle.gradleplugin.foundation.request.Request;
import org.gradle.gradleplugin.foundation.settings.SettingsNode;
import org.gradle.gradleplugin.userinterface.AlternateUIInteraction;
import org.gradle.gradleplugin.userinterface.swing.generic.SwingAddMultipleFavoritesInteraction;
import org.gradle.gradleplugin.userinterface.swing.generic.TaskTreeComponent;
import org.gradle.gradleplugin.userinterface.swing.generic.Utility;
import org.gradle.gradleplugin.userinterface.swing.generic.filter.ProjectAndTaskFilterDialog;
import org.gradle.gradleplugin.userinterface.swing.generic.tabs.GradleTab;

public class TaskTreeTab
implements GradleTab,
GradlePluginLord.GeneralPluginObserver,
GradlePluginLord.RequestObserver {
    private final Logger logger = Logging.getLogger(TaskTreeTab.class);
    private static final String SHOW_DESCRIPTION = "show-description";
    private static final String BLANK_PNG = "blank.png";
    private static final String EXECUTE_PNG = "execute.png";
    private JPanel mainPanel;
    private GradlePluginLord gradlePluginLord;
    private AlternateUIInteraction alternateUIInteraction;
    private TaskTreeComponent treeComponent;
    private JPopupMenu popupMenu;
    private JMenuItem addToFavoritesMenuItem;
    private JMenuItem executeMenuItem;
    private JMenuItem executeOnlyThisMenuItem;
    private JMenuItem filterOutMenuItem;
    private JMenuItem editFileMenuItem;
    private JMenuItem copyTaskNameMenuItem;
    private JButton refreshButton;
    private JButton executeButton;
    private JToggleButton toggleFilterButton;
    private JButton editFilterButton;
    private JCheckBox showDescriptionCheckBox;
    private BasicFilterEditor editor;
    private boolean isRefreshing;
    private Color defaultTreeBackground;
    private Color workingBackgroundColor = UIManager.getDefaults().getColor("Panel.background");
    private JScrollPane treeScrollPane;
    private SettingsNode settingsNode;

    public TaskTreeTab(GradlePluginLord gradlePluginLord, SettingsNode settingsNode, AlternateUIInteraction alternateUIInteraction) {
        this.gradlePluginLord = gradlePluginLord;
        this.settingsNode = settingsNode;
        this.alternateUIInteraction = alternateUIInteraction;
        gradlePluginLord.addGeneralPluginObserver(this, true);
        gradlePluginLord.addRequestObserver(this, true);
        this.initializeFilterEditor();
    }

    private void initializeFilterEditor() {
        BasicProjectAndTaskFilter filter = new BasicProjectAndTaskFilter();
        filter.serializeIn(this.settingsNode);
        this.editor = new BasicFilterEditor(filter);
        this.editor.addFilterEditorObserver(new BasicFilterEditor.FilterEditorObserver(){

            public void filterChanged() {
                TaskTreeTab.this.editor.createFilter().serializeOut(TaskTreeTab.this.settingsNode);
            }
        }, false);
    }

    public String getName() {
        return "Task Tree";
    }

    public Component createComponent() {
        this.setupUI();
        this.enableThingsAppropriately();
        return this.mainPanel;
    }

    public void aboutToShow() {
        this.resetShowDescription();
        this.refresh();
    }

    public void setupUI() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add(this.createTopPanel(), "North");
        this.mainPanel.add(this.createTreePanel(), "Center");
        this.setupPopupMenu();
    }

    private Component createTopPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.refreshButton = Utility.createButton(this.getClass(), "refresh.png", "Refreshes the task tree", new AbstractAction("Refresh"){

            public void actionPerformed(ActionEvent e) {
                TaskTreeTab.this.refresh();
            }
        });
        this.executeButton = Utility.createButton(this.getClass(), EXECUTE_PNG, "Execute the selected tasks", new AbstractAction("Execute"){

            public void actionPerformed(ActionEvent e) {
                TaskTreeTab.this.executeSelectedTasks(new String[0]);
            }
        });
        this.toggleFilterButton = Utility.createToggleButton(this.getClass(), "filter.png", "Toggles the view to show either everything or only the filtered items", new AbstractAction("Filter"){

            public void actionPerformed(ActionEvent e) {
                TaskTreeTab.this.populate();
            }
        });
        this.toggleFilterButton.setSelected(true);
        this.editFilterButton = Utility.createButton(this.getClass(), "edit-filter.png", "Edits the filter to control what is visible", new AbstractAction("Edit Filter..."){

            public void actionPerformed(ActionEvent e) {
                TaskTreeTab.this.configureFilter();
            }
        });
        this.showDescriptionCheckBox = new JCheckBox("Description", true);
        this.showDescriptionCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TaskTreeTab.this.resetShowDescription();
            }
        });
        this.showDescriptionCheckBox.setSelected(this.settingsNode.getValueOfChildAsBoolean(SHOW_DESCRIPTION, this.showDescriptionCheckBox.isSelected()));
        panel.add(this.refreshButton);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(this.executeButton);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(this.toggleFilterButton);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(this.showDescriptionCheckBox);
        panel.add(Box.createHorizontalGlue());
        panel.add(this.editFilterButton);
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return panel;
    }

    private Component createTreePanel() {
        this.treeComponent = new TaskTreeComponent(this.gradlePluginLord, new TaskTreeComponent.Interaction(){

            public void rightClick(JTree tree, int x, int y) {
                TaskTreeTab.this.enableThingsAppropriately();
                TaskTreeTab.this.popupMenu.show(tree, x, y);
            }

            public void taskInvoked(TaskView task, boolean isCtrlKeyDown) {
                if (isCtrlKeyDown) {
                    TaskTreeTab.this.gradlePluginLord.addExecutionRequestToQueue(task, false, "-a");
                } else {
                    TaskTreeTab.this.gradlePluginLord.addExecutionRequestToQueue(task, false, new String[0]);
                }
            }

            public void projectInvoked(ProjectView project) {
                TaskTreeTab.this.executeDefaultTasksInProject(project);
            }
        });
        this.treeComponent.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                TaskTreeTab.this.enableThingsAppropriately();
            }
        });
        this.defaultTreeBackground = this.treeComponent.getTree().getBackground();
        this.treeScrollPane = new JScrollPane();
        this.treeComponent.getTree().setBackground(this.workingBackgroundColor);
        this.showTextInViewport("Has not built projects/tasks yet.");
        return this.treeScrollPane;
    }

    private void showTextInViewport(String text) {
        this.treeScrollPane.getViewport().removeAll();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createHorizontalGlue());
        panel.add(new JLabel(text));
        panel.add(Box.createHorizontalGlue());
        this.treeScrollPane.getViewport().add(panel);
        this.treeScrollPane.revalidate();
    }

    private void showTreeInViewport() {
        this.treeScrollPane.getViewport().removeAll();
        this.treeScrollPane.getViewport().add(this.treeComponent.getTree());
        this.treeScrollPane.revalidate();
    }

    public void executionRequestAdded(ExecutionRequest request) {
    }

    public void refreshRequestAdded(RefreshTaskListRequest request) {
        this.isRefreshing = true;
        this.enableThingsAppropriately();
        this.treeComponent.getTree().setBackground(this.workingBackgroundColor);
        this.showTextInViewport("Refreshing projects and tasks.");
    }

    public void aboutToExecuteRequest(Request request) {
    }

    public void requestExecutionComplete(Request request, int result, String output) {
        if (request instanceof RefreshTaskListRequest) {
            this.isRefreshing = false;
            this.enableThingsAppropriately();
            if (result != 0) {
                this.showTextInViewport("Error");
            }
        }
    }

    private void refresh() {
        this.gradlePluginLord.addRefreshRequestToQueue();
    }

    private void populate() {
        if (this.toggleFilterButton.isSelected()) {
            this.treeComponent.populate(this.editor.createFilter());
        } else {
            this.treeComponent.populate(new AllowAllProjectAndTaskFilter());
        }
        this.treeComponent.getTree().setBackground(this.defaultTreeBackground);
        this.showTreeInViewport();
    }

    private void executeSelectedTasks(String ... additionCommandLineOptions) {
        List<TaskView> taskViews = this.treeComponent.getSelectedTasks();
        String singleCommandLine = CommandLineAssistant.combineTasks(taskViews, additionCommandLineOptions);
        if (singleCommandLine == null) {
            return;
        }
        this.gradlePluginLord.addExecutionRequestToQueue(singleCommandLine, singleCommandLine, false);
    }

    public void startingProjectsAndTasksReload() {
        this.treeComponent.getTree().setBackground(this.workingBackgroundColor);
        this.showTextInViewport("Building projects/tasks.");
    }

    public void projectsAndTasksReloaded(boolean wasSuccessful) {
        this.isRefreshing = false;
        this.enableThingsAppropriately();
        if (!wasSuccessful) {
            this.showTextInViewport("Error");
        } else {
            this.populate();
        }
    }

    private void setupPopupMenu() {
        this.popupMenu = new JPopupMenu();
        this.executeMenuItem = Utility.createMenuItem(this.getClass(), "Execute", EXECUTE_PNG, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TaskTreeTab.this.executeSelectedTasks(new String[0]);
            }
        });
        this.popupMenu.add(this.executeMenuItem);
        this.executeOnlyThisMenuItem = Utility.createMenuItem(this.getClass(), "Execute Ignoring Dependencies (-a)", BLANK_PNG, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TaskTreeTab.this.executeSelectedTasks(new String[]{"-a"});
            }
        });
        this.popupMenu.add(this.executeOnlyThisMenuItem);
        this.popupMenu.addSeparator();
        this.addToFavoritesMenuItem = Utility.createMenuItem(this.getClass(), "Add To Favorites", BLANK_PNG, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TaskTreeTab.this.addSelectedToFavorites();
            }
        });
        this.popupMenu.add(this.addToFavoritesMenuItem);
        this.filterOutMenuItem = Utility.createMenuItem(this.getClass(), "Hide", BLANK_PNG, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TaskTreeTab.this.hideSelection();
            }
        });
        this.popupMenu.add(this.filterOutMenuItem);
        this.editFileMenuItem = Utility.createMenuItem(this.getClass(), "Edit File", BLANK_PNG, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TaskTreeTab.this.editSelectedFiles();
            }
        });
        this.popupMenu.add(this.editFileMenuItem);
        this.copyTaskNameMenuItem = Utility.createMenuItem(this.getClass(), "Copy Task Name", BLANK_PNG, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TaskTreeTab.this.copySelectedTaskNames();
            }
        });
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.copyTaskNameMenuItem);
    }

    private void enableThingsAppropriately() {
        boolean hasSelection = this.treeComponent.getTree().getSelectionPath() != null;
        boolean hasTaskSelection = this.treeComponent.hasTasksSelected();
        boolean canDoThings = !this.isRefreshing && this.treeComponent.isPopulated() && hasSelection;
        this.refreshButton.setEnabled(!this.isRefreshing);
        this.addToFavoritesMenuItem.setEnabled(canDoThings);
        this.executeMenuItem.setEnabled(canDoThings);
        this.executeOnlyThisMenuItem.setEnabled(canDoThings);
        this.executeButton.setEnabled(canDoThings);
        if (this.alternateUIInteraction.doesSupportEditingOpeningFiles()) {
            this.editFileMenuItem.setVisible(true);
            boolean hasProjectsSelected = this.treeComponent.hasProjectsSelected();
            this.editFileMenuItem.setEnabled(hasProjectsSelected && canDoThings);
        } else {
            this.editFileMenuItem.setVisible(false);
        }
        this.copyTaskNameMenuItem.setVisible(!this.isRefreshing && hasTaskSelection);
    }

    private void addSelectedToFavorites() {
        List<TaskView> tasks = this.treeComponent.getSelectedTasks();
        this.gradlePluginLord.getFavoritesEditor().addMutlipleFavorites(tasks, false, new SwingAddMultipleFavoritesInteraction(SwingUtilities.getWindowAncestor(this.mainPanel)));
    }

    private void configureFilter() {
        ProjectAndTaskFilterDialog dialog = new ProjectAndTaskFilterDialog(SwingUtilities.getWindowAncestor(this.mainPanel), this.gradlePluginLord);
        BasicProjectAndTaskFilter newFilter = dialog.show(this.editor.createFilter());
        if (newFilter != null) {
            this.editor.initializeFromFilter(newFilter);
            this.populate();
        }
    }

    private void hideSelection() {
        TaskTreeComponent.MultipleSelection multipleSelection = this.treeComponent.getSelectedProjectsAndTasks();
        if (!multipleSelection.projects.isEmpty() || !multipleSelection.tasks.isEmpty()) {
            this.editor.hideProjects(multipleSelection.projects);
            this.editor.hideTasks(multipleSelection.tasks);
            this.populate();
        }
    }

    private void resetShowDescription() {
        this.settingsNode.setValueOfChildAsBoolean(SHOW_DESCRIPTION, this.showDescriptionCheckBox.isSelected());
        this.treeComponent.setShowDescription(this.showDescriptionCheckBox.isSelected());
    }

    private void editSelectedFiles() {
        TaskTreeComponent.MultipleSelection tasks = this.treeComponent.getSelectedProjectsAndTasks();
        for (ProjectView projectView : tasks.projects) {
            File file = projectView.getBuildFile();
            if (file == null) continue;
            this.alternateUIInteraction.editFile(file, -1);
        }
    }

    private void executeDefaultTasksInProject(ProjectView project) {
        for (TaskView task : project.getDefaultTasks()) {
            this.gradlePluginLord.addExecutionRequestToQueue(task, false, new String[0]);
        }
    }

    private void copySelectedTaskNames() {
        String names = this.getSelectedTaskNames();
        if (names.length() == 0) {
            return;
        }
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(names), null);
    }

    private String getSelectedTaskNames() {
        List<TaskView> tasks = this.treeComponent.getSelectedTasks();
        if (tasks.isEmpty()) {
            return null;
        }
        StringBuilder taskString = new StringBuilder();
        Iterator<TaskView> iterator = tasks.iterator();
        while (iterator.hasNext()) {
            TaskView taskView = iterator.next();
            taskString.append(taskView.getFullTaskName());
            if (!iterator.hasNext()) continue;
            taskString.append(' ');
        }
        return taskString.toString();
    }
}

