/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.globals;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objectstorage.WriteHeadObjectFieldNode;
import org.jruby.truffle.nodes.objectstorage.WriteHeadObjectFieldNodeGen;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.StringOperations;

public class WriteGlobalVariableNode
extends RubyNode {
    private final DynamicObject globalVariablesObject;
    @Node.Child
    private RubyNode rhs;
    @Node.Child
    private WriteHeadObjectFieldNode writeNode;

    public WriteGlobalVariableNode(RubyContext context, SourceSection sourceSection, String name, RubyNode rhs) {
        super(context, sourceSection);
        this.globalVariablesObject = context.getCoreLibrary().getGlobalVariablesObject();
        this.rhs = rhs;
        this.writeNode = WriteHeadObjectFieldNodeGen.create(name);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object value = this.rhs.execute(frame);
        this.writeNode.execute(this.globalVariablesObject, value);
        return value;
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        return this.create7BitString(StringOperations.encodeByteList("assignment", (Encoding)UTF8Encoding.INSTANCE));
    }
}

