(function() {
  var escope, expect, harmony;

  expect = require('chai').expect;

  harmony = require('../third_party/esprima');

  escope = require('..');

  describe('ES6 catch', function() {
    return it('takes binding pattern', function() {
      var ast, scope, scopeManager;
      ast = harmony.parse("try {\n} catch ({ a, b, c, d }) {\n    let e = 20;\n    a;\n    b;\n    let c = 30;\n    c;\n    d;\n}");
      scopeManager = escope.analyze(ast, {
        ecmaVersion: 6
      });
      expect(scopeManager.scopes).to.have.length(4);
      scope = scopeManager.scopes[0];
      expect(scope.type).to.be.equal('global');
      expect(scope.block.type).to.be.equal('Program');
      expect(scope.isStrict).to.be["false"];
      expect(scope.variables).to.have.length(0);
      expect(scope.references).to.have.length(0);
      scope = scopeManager.scopes[1];
      expect(scope.type).to.be.equal('block');
      expect(scope.block.type).to.be.equal('BlockStatement');
      expect(scope.isStrict).to.be["false"];
      expect(scope.variables).to.have.length(0);
      expect(scope.references).to.have.length(0);
      scope = scopeManager.scopes[2];
      expect(scope.type).to.be.equal('catch');
      expect(scope.block.type).to.be.equal('CatchClause');
      return expect(scope.isStrict).to.be["false"];
    });
  });

}).call(this);

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImVzNi1jYXRjaC5jb2ZmZWUiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBc0JBO0FBQUEsTUFBQSx1QkFBQTs7QUFBQSxFQUFBLE1BQUEsR0FBUyxPQUFBLENBQVMsTUFBVCxDQUFlLENBQUMsTUFBekIsQ0FBQTs7QUFBQSxFQUNBLE9BQUEsR0FBVSxPQUFBLENBQVMsd0JBQVQsQ0FEVixDQUFBOztBQUFBLEVBRUEsTUFBQSxHQUFTLE9BQUEsQ0FBUyxJQUFULENBRlQsQ0FBQTs7QUFBQSxFQUlBLFFBQUEsQ0FBVSxXQUFWLEVBQXNCLFNBQUEsR0FBQTtXQUNsQixFQUFBLENBQUksdUJBQUosRUFBNEIsU0FBQSxHQUFBO0FBQ3hCLFVBQUEsd0JBQUE7QUFBQSxNQUFBLEdBQUEsR0FBTSxPQUFPLENBQUMsS0FBUixDQUFpQix3R0FBakIsQ0FBTixDQUFBO0FBQUEsTUFXQSxZQUFBLEdBQWUsTUFBTSxDQUFDLE9BQVAsQ0FBZSxHQUFmLEVBQW9CO0FBQUEsUUFBQSxXQUFBLEVBQWEsQ0FBYjtPQUFwQixDQVhmLENBQUE7QUFBQSxNQVlBLE1BQUEsQ0FBTyxZQUFZLENBQUMsTUFBcEIsQ0FBMkIsQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLE1BQXBDLENBQTJDLENBQTNDLENBWkEsQ0FBQTtBQUFBLE1BY0EsS0FBQSxHQUFRLFlBQVksQ0FBQyxNQUFPLENBQUEsQ0FBQSxDQWQ1QixDQUFBO0FBQUEsTUFlQSxNQUFBLENBQU8sS0FBSyxDQUFDLElBQWIsQ0FBa0IsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEtBQXpCLENBQWdDLFFBQWhDLENBZkEsQ0FBQTtBQUFBLE1BZ0JBLE1BQUEsQ0FBTyxLQUFLLENBQUMsS0FBSyxDQUFDLElBQW5CLENBQXdCLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxLQUEvQixDQUFzQyxTQUF0QyxDQWhCQSxDQUFBO0FBQUEsTUFpQkEsTUFBQSxDQUFPLEtBQUssQ0FBQyxRQUFiLENBQXNCLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxPQUFELENBakI1QixDQUFBO0FBQUEsTUFrQkEsTUFBQSxDQUFPLEtBQUssQ0FBQyxTQUFiLENBQXVCLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxNQUFoQyxDQUF1QyxDQUF2QyxDQWxCQSxDQUFBO0FBQUEsTUFtQkEsTUFBQSxDQUFPLEtBQUssQ0FBQyxVQUFiLENBQXdCLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxNQUFqQyxDQUF3QyxDQUF4QyxDQW5CQSxDQUFBO0FBQUEsTUFxQkEsS0FBQSxHQUFRLFlBQVksQ0FBQyxNQUFPLENBQUEsQ0FBQSxDQXJCNUIsQ0FBQTtBQUFBLE1Bc0JBLE1BQUEsQ0FBTyxLQUFLLENBQUMsSUFBYixDQUFrQixDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBekIsQ0FBZ0MsT0FBaEMsQ0F0QkEsQ0FBQTtBQUFBLE1BdUJBLE1BQUEsQ0FBTyxLQUFLLENBQUMsS0FBSyxDQUFDLElBQW5CLENBQXdCLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxLQUEvQixDQUFzQyxnQkFBdEMsQ0F2QkEsQ0FBQTtBQUFBLE1Bd0JBLE1BQUEsQ0FBTyxLQUFLLENBQUMsUUFBYixDQUFzQixDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsT0FBRCxDQXhCNUIsQ0FBQTtBQUFBLE1BeUJBLE1BQUEsQ0FBTyxLQUFLLENBQUMsU0FBYixDQUF1QixDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsTUFBaEMsQ0FBdUMsQ0FBdkMsQ0F6QkEsQ0FBQTtBQUFBLE1BMEJBLE1BQUEsQ0FBTyxLQUFLLENBQUMsVUFBYixDQUF3QixDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsTUFBakMsQ0FBd0MsQ0FBeEMsQ0ExQkEsQ0FBQTtBQUFBLE1BNEJBLEtBQUEsR0FBUSxZQUFZLENBQUMsTUFBTyxDQUFBLENBQUEsQ0E1QjVCLENBQUE7QUFBQSxNQTZCQSxNQUFBLENBQU8sS0FBSyxDQUFDLElBQWIsQ0FBa0IsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEtBQXpCLENBQWdDLE9BQWhDLENBN0JBLENBQUE7QUFBQSxNQThCQSxNQUFBLENBQU8sS0FBSyxDQUFDLEtBQUssQ0FBQyxJQUFuQixDQUF3QixDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsS0FBL0IsQ0FBc0MsYUFBdEMsQ0E5QkEsQ0FBQTthQStCQSxNQUFBLENBQU8sS0FBSyxDQUFDLFFBQWIsQ0FBc0IsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLE9BQUQsRUFoQ0o7SUFBQSxDQUE1QixFQURrQjtFQUFBLENBQXRCLENBSkEsQ0FBQTtBQUFBIiwiZmlsZSI6ImVzNi1jYXRjaC5qcyIsInNvdXJjZVJvb3QiOiIvc291cmNlLyIsInNvdXJjZXNDb250ZW50IjpbIiMgLSotIGNvZGluZzogdXRmLTggLSotXG4jICBDb3B5cmlnaHQgKEMpIDIwMTQgWXVzdWtlIFN1enVraSA8dXRhdGFuZS50ZWFAZ21haWwuY29tPlxuI1xuIyAgUmVkaXN0cmlidXRpb24gYW5kIHVzZSBpbiBzb3VyY2UgYW5kIGJpbmFyeSBmb3Jtcywgd2l0aCBvciB3aXRob3V0XG4jICBtb2RpZmljYXRpb24sIGFyZSBwZXJtaXR0ZWQgcHJvdmlkZWQgdGhhdCB0aGUgZm9sbG93aW5nIGNvbmRpdGlvbnMgYXJlIG1ldDpcbiNcbiMgICAgKiBSZWRpc3RyaWJ1dGlvbnMgb2Ygc291cmNlIGNvZGUgbXVzdCByZXRhaW4gdGhlIGFib3ZlIGNvcHlyaWdodFxuIyAgICAgIG5vdGljZSwgdGhpcyBsaXN0IG9mIGNvbmRpdGlvbnMgYW5kIHRoZSBmb2xsb3dpbmcgZGlzY2xhaW1lci5cbiMgICAgKiBSZWRpc3RyaWJ1dGlvbnMgaW4gYmluYXJ5IGZvcm0gbXVzdCByZXByb2R1Y2UgdGhlIGFib3ZlIGNvcHlyaWdodFxuIyAgICAgIG5vdGljZSwgdGhpcyBsaXN0IG9mIGNvbmRpdGlvbnMgYW5kIHRoZSBmb2xsb3dpbmcgZGlzY2xhaW1lciBpbiB0aGVcbiMgICAgICBkb2N1bWVudGF0aW9uIGFuZC9vciBvdGhlciBtYXRlcmlhbHMgcHJvdmlkZWQgd2l0aCB0aGUgZGlzdHJpYnV0aW9uLlxuI1xuIyAgVEhJUyBTT0ZUV0FSRSBJUyBQUk9WSURFRCBCWSBUSEUgQ09QWVJJR0hUIEhPTERFUlMgQU5EIENPTlRSSUJVVE9SUyBcIkFTIElTXCJcbiMgIEFORCBBTlkgRVhQUkVTUyBPUiBJTVBMSUVEIFdBUlJBTlRJRVMsIElOQ0xVRElORywgQlVUIE5PVCBMSU1JVEVEIFRPLCBUSEVcbiMgIElNUExJRUQgV0FSUkFOVElFUyBPRiBNRVJDSEFOVEFCSUxJVFkgQU5EIEZJVE5FU1MgRk9SIEEgUEFSVElDVUxBUiBQVVJQT1NFXG4jICBBUkUgRElTQ0xBSU1FRC4gSU4gTk8gRVZFTlQgU0hBTEwgPENPUFlSSUdIVCBIT0xERVI+IEJFIExJQUJMRSBGT1IgQU5ZXG4jICBESVJFQ1QsIElORElSRUNULCBJTkNJREVOVEFMLCBTUEVDSUFMLCBFWEVNUExBUlksIE9SIENPTlNFUVVFTlRJQUwgREFNQUdFU1xuIyAgKElOQ0xVRElORywgQlVUIE5PVCBMSU1JVEVEIFRPLCBQUk9DVVJFTUVOVCBPRiBTVUJTVElUVVRFIEdPT0RTIE9SIFNFUlZJQ0VTO1xuIyAgTE9TUyBPRiBVU0UsIERBVEEsIE9SIFBST0ZJVFM7IE9SIEJVU0lORVNTIElOVEVSUlVQVElPTikgSE9XRVZFUiBDQVVTRUQgQU5EXG4jICBPTiBBTlkgVEhFT1JZIE9GIExJQUJJTElUWSwgV0hFVEhFUiBJTiBDT05UUkFDVCwgU1RSSUNUIExJQUJJTElUWSwgT1IgVE9SVFxuIyAgKElOQ0xVRElORyBORUdMSUdFTkNFIE9SIE9USEVSV0lTRSkgQVJJU0lORyBJTiBBTlkgV0FZIE9VVCBPRiBUSEUgVVNFIE9GXG4jICBUSElTIFNPRlRXQVJFLCBFVkVOIElGIEFEVklTRUQgT0YgVEhFIFBPU1NJQklMSVRZIE9GIFNVQ0ggREFNQUdFLlxuZXhwZWN0ID0gcmVxdWlyZSgnY2hhaScpLmV4cGVjdFxuaGFybW9ueSA9IHJlcXVpcmUgJy4uL3RoaXJkX3BhcnR5L2VzcHJpbWEnXG5lc2NvcGUgPSByZXF1aXJlICcuLidcblxuZGVzY3JpYmUgJ0VTNiBjYXRjaCcsIC0+XG4gICAgaXQgJ3Rha2VzIGJpbmRpbmcgcGF0dGVybicsIC0+XG4gICAgICAgIGFzdCA9IGhhcm1vbnkucGFyc2UgXCJcIlwiXG4gICAgICAgIHRyeSB7XG4gICAgICAgIH0gY2F0Y2ggKHsgYSwgYiwgYywgZCB9KSB7XG4gICAgICAgICAgICBsZXQgZSA9IDIwO1xuICAgICAgICAgICAgYTtcbiAgICAgICAgICAgIGI7XG4gICAgICAgICAgICBsZXQgYyA9IDMwO1xuICAgICAgICAgICAgYztcbiAgICAgICAgICAgIGQ7XG4gICAgICAgIH1cbiAgICAgICAgXCJcIlwiXG4gICAgICAgIHNjb3BlTWFuYWdlciA9IGVzY29wZS5hbmFseXplIGFzdCwgZWNtYVZlcnNpb246IDZcbiAgICAgICAgZXhwZWN0KHNjb3BlTWFuYWdlci5zY29wZXMpLnRvLmhhdmUubGVuZ3RoIDRcblxuICAgICAgICBzY29wZSA9IHNjb3BlTWFuYWdlci5zY29wZXNbMF1cbiAgICAgICAgZXhwZWN0KHNjb3BlLnR5cGUpLnRvLmJlLmVxdWFsICdnbG9iYWwnXG4gICAgICAgIGV4cGVjdChzY29wZS5ibG9jay50eXBlKS50by5iZS5lcXVhbCAnUHJvZ3JhbSdcbiAgICAgICAgZXhwZWN0KHNjb3BlLmlzU3RyaWN0KS50by5iZS5mYWxzZVxuICAgICAgICBleHBlY3Qoc2NvcGUudmFyaWFibGVzKS50by5oYXZlLmxlbmd0aCAwXG4gICAgICAgIGV4cGVjdChzY29wZS5yZWZlcmVuY2VzKS50by5oYXZlLmxlbmd0aCAwXG5cbiAgICAgICAgc2NvcGUgPSBzY29wZU1hbmFnZXIuc2NvcGVzWzFdXG4gICAgICAgIGV4cGVjdChzY29wZS50eXBlKS50by5iZS5lcXVhbCAnYmxvY2snXG4gICAgICAgIGV4cGVjdChzY29wZS5ibG9jay50eXBlKS50by5iZS5lcXVhbCAnQmxvY2tTdGF0ZW1lbnQnXG4gICAgICAgIGV4cGVjdChzY29wZS5pc1N0cmljdCkudG8uYmUuZmFsc2VcbiAgICAgICAgZXhwZWN0KHNjb3BlLnZhcmlhYmxlcykudG8uaGF2ZS5sZW5ndGggMFxuICAgICAgICBleHBlY3Qoc2NvcGUucmVmZXJlbmNlcykudG8uaGF2ZS5sZW5ndGggMFxuXG4gICAgICAgIHNjb3BlID0gc2NvcGVNYW5hZ2VyLnNjb3Blc1syXVxuICAgICAgICBleHBlY3Qoc2NvcGUudHlwZSkudG8uYmUuZXF1YWwgJ2NhdGNoJ1xuICAgICAgICBleHBlY3Qoc2NvcGUuYmxvY2sudHlwZSkudG8uYmUuZXF1YWwgJ0NhdGNoQ2xhdXNlJ1xuICAgICAgICBleHBlY3Qoc2NvcGUuaXNTdHJpY3QpLnRvLmJlLmZhbHNlXG5cbiAgICAgICAgIyBGSVhNRSBBZnRlciBFc3ByaW1hJ3MgYnVnIGlzIGZpeGVkLCBJJ2xsIGFkZCB0ZXN0cyAjMzNcbiAgICAgICAgIyBodHRwczovL2dpdGh1Yi5jb20vZXN0b29scy9lc2NvcGUvaXNzdWVzLzMzI2lzc3VlY29tbWVudC02NDEzNTgzMlxuICAgICAgICAjXG4gICAgICAgICMgZXhwZWN0KHNjb3BlLnZhcmlhYmxlcykudG8uaGF2ZS5sZW5ndGggNFxuICAgICAgICAjIGV4cGVjdChzY29wZS52YXJpYWJsZXNbMF0ubmFtZSkudG8uYmUuZXF1YWwgJ2EnXG4gICAgICAgICMgZXhwZWN0KHNjb3BlLnZhcmlhYmxlc1sxXS5uYW1lKS50by5iZS5lcXVhbCAnYidcbiAgICAgICAgIyBleHBlY3Qoc2NvcGUudmFyaWFibGVzWzJdLm5hbWUpLnRvLmJlLmVxdWFsICdjJ1xuICAgICAgICAjIGV4cGVjdChzY29wZS52YXJpYWJsZXNbM10ubmFtZSkudG8uYmUuZXF1YWwgJ2QnXG4gICAgICAgICMgZXhwZWN0KHNjb3BlLnJlZmVyZW5jZXMpLnRvLmhhdmUubGVuZ3RoIDBcblxuIyB2aW06IHNldCBzdz00IHRzPTQgZXQgdHc9ODAgOlxuIl19