/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.languagemodel;

import java.util.List;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.ngrams.Probability;

public abstract class BaseLanguageModel
implements LanguageModel {
    private static final boolean DEBUG = false;
    private Long totalTokenCount;

    @Override
    public Probability getPseudoProbability(List<String> context) {
        if (this.totalTokenCount == null) {
            this.totalTokenCount = this.getTotalTokenCount();
        }
        int maxCoverage = 0;
        int coverage = 0;
        long firstWordCount = this.getCount(context.get(0));
        ++maxCoverage;
        if (firstWordCount > 0L) {
            ++coverage;
        }
        double p = (double)(firstWordCount + 1L) / (double)(this.totalTokenCount + 1L);
        this.debug("    P for %s: %.20f (%d)\n", context.get(0), p, firstWordCount);
        long totalCount = 0L;
        for (int i = 2; i <= context.size(); ++i) {
            List<String> subList = context.subList(0, i);
            long phraseCount = this.getCount(subList);
            if (subList.size() == 3) {
                totalCount = phraseCount;
            }
            double thisP = (double)(phraseCount + 1L) / (double)(firstWordCount + 1L);
            ++maxCoverage;
            this.debug("    P for " + subList + ": %.20f (%d)\n", thisP, phraseCount);
            if (phraseCount > 0L) {
                ++coverage;
            }
            p *= thisP;
        }
        this.debug("  " + String.join((CharSequence)" ", context) + " => %.20f\n", p);
        return new Probability(p, (float)coverage / (float)maxCoverage, totalCount);
    }

    abstract long getCount(String var1);

    abstract long getCount(List<String> var1);

    abstract long getTotalTokenCount();

    private void debug(String message, Object ... vars) {
    }
}

