/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import junit.framework.TestCase;
import org.languagetool.tools.ContextTools;

public class ContextToolsTest
extends TestCase {
    public void testGetContext() throws Exception {
        ContextTools contextTools = new ContextTools();
        String context = contextTools.getContext(4, 8, "Hi, this is some nice text waiting for its error markers.");
        ContextToolsTest.assertEquals((String)"Hi, <b><font bgcolor=\"#ff8b8b\">this</font></b> is some nice text waiting for its error...", (String)context);
        String context2 = contextTools.getContext(3, 5, "xxx\n \nyyy");
        ContextToolsTest.assertEquals((String)"xxx<b><font bgcolor=\"#ff8b8b\">&nbsp;&nbsp;</font></b> yyy", (String)context2);
    }

    public void testPlainTextContext() throws Exception {
        ContextTools contextTools = new ContextTools();
        contextTools.setContextSize(5);
        String input = "This is a test sentence. Here's another sentence with more text.";
        String result = contextTools.getPlainTextContext(8, 14, "This is a test sentence. Here's another sentence with more text.");
        ContextToolsTest.assertEquals((String)"...s is a test sent...\n        ^^^^^^     ", (String)result);
    }

    public void testPlainTextContextWithLineBreaks() throws Exception {
        ContextTools contextTools = new ContextTools();
        contextTools.setContextSize(5);
        String input = "One.\nThis is a test sentence.\nHere's another sentence.";
        String result = contextTools.getPlainTextContext(15, 19, "One.\nThis is a test sentence.\nHere's another sentence.");
        ContextToolsTest.assertEquals((String)"...is a test sent...\n        ^^^^     ", (String)result);
    }

    public void testPlainTextContextWithDosLineBreaks() throws Exception {
        ContextTools contextTools = new ContextTools();
        contextTools.setContextSize(5);
        String input = "One.\r\nThis is a test sentence.\r\nHere's another sentence.";
        String result = contextTools.getPlainTextContext(16, 20, "One.\r\nThis is a test sentence.\r\nHere's another sentence.");
        ContextToolsTest.assertEquals((String)"...is a test sent...\n        ^^^^     ", (String)result);
    }

    public void testLargerContext() throws Exception {
        ContextTools contextTools = new ContextTools();
        contextTools.setContextSize(100);
        String context = contextTools.getContext(4, 8, "Hi, this is some nice text waiting for its error markers.");
        ContextToolsTest.assertEquals((String)"Hi, <b><font bgcolor=\"#ff8b8b\">this</font></b> is some nice text waiting for its error markers.", (String)context);
    }

    public void testHtmlEscape() throws Exception {
        ContextTools contextTools = new ContextTools();
        String context1 = contextTools.getContext(0, 2, "Hi, this is <html>.");
        ContextToolsTest.assertEquals((String)"<b><font bgcolor=\"#ff8b8b\">Hi</font></b>, this is &lt;html&gt;.", (String)context1);
        contextTools.setEscapeHtml(false);
        String context2 = contextTools.getContext(0, 2, "Hi, this is <html>.");
        ContextToolsTest.assertEquals((String)"<b><font bgcolor=\"#ff8b8b\">Hi</font></b>, this is <html>.", (String)context2);
    }

    public void testMarkers() throws Exception {
        ContextTools contextTools = new ContextTools();
        contextTools.setErrorMarkerStart("<X>");
        contextTools.setErrorMarkerEnd("</X>");
        String context = contextTools.getContext(0, 2, "Hi, this is it.");
        ContextToolsTest.assertEquals((String)"<X>Hi</X>, this is it.", (String)context);
    }
}

