/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen.trie;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.BitSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrieBuilder {
    private RandomAccessFile trieFile;
    private MappedByteBuffer byteBuffer = null;
    private IntBuffer trieDataBuffer = null;
    private BitSet used = new BitSet();
    private int nextCheckPosition = 0;
    private String[] keys;
    private int[] values;
    private int size;

    private void resize(int newSize) throws IOException {
        if (this.byteBuffer != null) {
            this.byteBuffer.force();
        }
        this.trieFile.setLength(newSize * 8);
        FileChannel indexChannel = this.trieFile.getChannel();
        this.byteBuffer = indexChannel.map(FileChannel.MapMode.READ_WRITE, 0L, newSize * 8);
        this.trieDataBuffer = this.byteBuffer.asIntBuffer();
    }

    private Vector<TrieNode> fetch(TrieNode parent) {
        int prev = 0;
        Vector<TrieNode> siblings = new Vector<TrieNode>();
        for (int i = parent.left; i < parent.right; ++i) {
            if (this.keys[i].length() < parent.depth) continue;
            String tmp = this.keys[i];
            int cur = 0;
            if (this.keys[i].length() != parent.depth) {
                cur = tmp.charAt(parent.depth) + '\u0001';
            }
            if (prev > cur) {
                throw new RuntimeException("Fatal: Keys are not sorted");
            }
            if (cur != prev || siblings.size() == 0) {
                TrieNode tempNode = new TrieNode(cur, parent.depth + 1, i, 0);
                if (siblings.size() != 0) {
                    TrieNode lastSibling = siblings.lastElement();
                    lastSibling.right = i;
                }
                siblings.add(tempNode);
            }
            prev = cur;
        }
        if (siblings.size() != 0) {
            TrieNode lastSibling = (TrieNode)siblings.lastElement();
            lastSibling.right = parent.right;
        }
        return siblings;
    }

    private int findInsertionPoint(Vector<TrieNode> siblings) throws IOException {
        int begin = 0;
        int nonZeroNum = 0;
        boolean first = false;
        int position = siblings.get((int)0).code + 1 > this.nextCheckPosition ? siblings.get((int)0).code : this.nextCheckPosition - 1;
        while (true) {
            int t;
            if (++position > this.trieDataBuffer.limit() >> 1) {
                this.resize((int)((double)position * 1.05));
            }
            if (this.trieDataBuffer.get((position << 1) + 1) != 0) {
                ++nonZeroNum;
                continue;
            }
            if (!first) {
                this.nextCheckPosition = position;
                first = true;
            }
            if ((t = (begin = position - siblings.get((int)0).code) + siblings.get((int)(siblings.size() - 1)).code) > this.trieDataBuffer.limit() >> 1) {
                this.resize((int)((double)t * 1.05));
            }
            if (this.used.get(begin)) continue;
            boolean flag = false;
            for (int i = 1; i < siblings.size(); ++i) {
                if (this.trieDataBuffer.get((begin + siblings.get((int)i).code << 1) + 1) == 0) continue;
                flag = true;
                break;
            }
            if (!flag) break;
        }
        if (1.0 * (double)nonZeroNum / (double)(position - this.nextCheckPosition + 1) >= 0.95) {
            this.nextCheckPosition = position;
        }
        this.used.set(begin);
        return begin;
    }

    private int insert(Vector<TrieNode> siblings) throws IOException {
        int i;
        int begin = this.findInsertionPoint(siblings);
        for (i = 0; i < siblings.size(); ++i) {
            this.trieDataBuffer.put((begin + siblings.get((int)i).code << 1) + 1, begin);
        }
        for (i = 0; i < siblings.size(); ++i) {
            int value;
            int position = begin + siblings.get((int)i).code << 1;
            Vector<TrieNode> newSiblings = this.fetch(siblings.get(i));
            if (newSiblings.size() == 0) {
                if (this.values == null) {
                    value = -siblings.get((int)i).left - 1;
                } else {
                    value = -this.values[siblings.get((int)i).left] - 1;
                    if (value >= 0) {
                        throw new RuntimeException("Fatal: Negative value assigned");
                    }
                }
            } else {
                value = this.insert(newSiblings);
            }
            this.trieDataBuffer.put(position, value);
        }
        return begin;
    }

    public void build(String filename) throws IOException {
        this.trieFile = new RandomAccessFile(filename, "rw");
        this.trieFile.setLength(0L);
        this.resize(10240);
        this.trieDataBuffer.put(0, 1);
        TrieNode rootNode = new TrieNode(0, 0, 0, this.size);
        Vector<TrieNode> siblings = this.fetch(rootNode);
        this.insert(siblings);
        this.byteBuffer.force();
        this.trieFile.close();
    }

    public TrieBuilder(String[] keys, int[] values, int size) {
        this.keys = keys;
        this.values = values;
        this.size = size;
    }

    private static class TrieNode {
        int code;
        int depth;
        int left;
        int right;

        public TrieNode(int code, int depth, int left, int right) {
            this.code = code;
            this.depth = depth;
            this.left = left;
            this.right = right;
        }
    }
}

