/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.util;

import org.codehaus.groovy.util.AbstractConcurrentMapBase;

public abstract class AbstractConcurrentDoubleKeyMap<K1, K2, V>
extends AbstractConcurrentMapBase {
    public AbstractConcurrentDoubleKeyMap(Object segmentInfo) {
        super(segmentInfo);
    }

    static <K1, K2> int hash(K1 key1, K2 key2) {
        int h = 31 * key1.hashCode() + key2.hashCode();
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    public V get(K1 key1, K2 key2) {
        int hash = AbstractConcurrentDoubleKeyMap.hash(key1, key2);
        return ((Segment)this.segmentFor(hash)).get(key1, key2, hash);
    }

    public Entry<K1, K2, V> getOrPut(K1 key1, K2 key2, V value) {
        int hash = AbstractConcurrentDoubleKeyMap.hash(key1, key2);
        return ((Segment)this.segmentFor(hash)).getOrPut(key1, key2, hash, value);
    }

    public void put(K1 key1, K2 key2, V value) {
        int hash = AbstractConcurrentDoubleKeyMap.hash(key1, key2);
        ((Segment)this.segmentFor(hash)).put(key1, key2, hash).setValue(value);
    }

    public void remove(K1 key1, K2 key2) {
        int hash = AbstractConcurrentDoubleKeyMap.hash(key1, key2);
        ((Segment)this.segmentFor(hash)).remove(key1, key2, hash);
    }

    @Override
    public final Segment<K1, K2, V> segmentFor(int hash) {
        return (Segment)this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    static interface Entry<K1, K2, V>
    extends AbstractConcurrentMapBase.Entry<V> {
        public boolean isEqual(K1 var1, K2 var2, int var3);
    }

    static abstract class Segment<K1, K2, V>
    extends AbstractConcurrentMapBase.Segment {
        Segment(int initialCapacity) {
            super(initialCapacity);
        }

        V get(K1 key1, K2 key2, int hash) {
            Object[] tab = this.table;
            Object o = tab[hash & tab.length - 1];
            if (o != null) {
                if (o instanceof Entry) {
                    Entry e = (Entry)o;
                    if (e.isEqual(key1, key2, hash)) {
                        return e.getValue();
                    }
                } else {
                    Object[] arr = (Object[])o;
                    for (int i = 0; i != arr.length; ++i) {
                        Entry e = (Entry)arr[i];
                        if (e == null || !e.isEqual(key1, key2, hash)) continue;
                        return e.getValue();
                    }
                }
            }
            return null;
        }

        Entry<K1, K2, V> getOrPut(K1 key1, K2 key2, int hash, V value) {
            Object[] tab = this.table;
            Object o = tab[hash & tab.length - 1];
            if (o != null) {
                if (o instanceof Entry) {
                    Entry e = (Entry)o;
                    if (e.isEqual(key1, key2, hash)) {
                        return e;
                    }
                } else {
                    Object[] arr = (Object[])o;
                    for (int i = 0; i != arr.length; ++i) {
                        Entry e = (Entry)arr[i];
                        if (e == null || !e.isEqual(key1, key2, hash)) continue;
                        return e;
                    }
                }
            }
            Entry<K1, K2, V> kvEntry = this.put(key1, key2, hash);
            kvEntry.setValue(value);
            return kvEntry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Entry<K1, K2, V> put(K1 key1, K2 key2, int hash) {
            this.lock();
            try {
                Entry<K1, K2, V> res;
                this.rehashIfThresholdExceeded();
                Object[] tab = this.table;
                int index = hash & tab.length - 1;
                Object o = tab[index];
                if (o != null) {
                    Entry<K1, K2, V> res2;
                    if (o instanceof Entry) {
                        Entry e = (Entry)o;
                        if (e.isEqual(key1, key2, hash)) {
                            Entry entry = e;
                            return entry;
                        }
                        Entry<K1, K2, V> res3 = this.createEntry(key1, key2, hash);
                        Object[] arr = new Object[]{res3, e};
                        tab[index] = arr;
                        ++this.count;
                        Entry<K1, K2, V> entry = res3;
                        return entry;
                    }
                    Object[] arr = (Object[])o;
                    for (int i = 0; i != arr.length; ++i) {
                        Entry e = (Entry)arr[i];
                        if (e == null || !e.isEqual(key1, key2, hash)) continue;
                        Entry entry = e;
                        return entry;
                    }
                    Object[] newArr = new Object[arr.length + 1];
                    arr[0] = res2 = this.createEntry(key1, key2, hash);
                    System.arraycopy(arr, 0, newArr, 1, arr.length);
                    tab[index] = arr;
                    ++this.count;
                    Entry<K1, K2, V> entry = res2;
                    return entry;
                }
                tab[index] = res = this.createEntry(key1, key2, hash);
                ++this.count;
                Entry<K1, K2, V> entry = res;
                return entry;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(K1 key1, K2 key2, int hash) {
            block6: {
                this.lock();
                try {
                    int c = this.count - 1;
                    Object[] tab = this.table;
                    int index = hash & tab.length - 1;
                    Object o = tab[index];
                    if (o == null) break block6;
                    if (o instanceof Entry) {
                        if (((Entry)o).isEqual(key1, key2, hash)) {
                            tab[index] = null;
                            this.count = c;
                        }
                        break block6;
                    }
                    Object[] arr = (Object[])o;
                    for (int i = 0; i < arr.length; ++i) {
                        Entry e = (Entry)arr[i];
                        if (e == null || !e.isEqual(key1, key2, hash)) continue;
                        arr[i] = null;
                        this.count = c;
                        break;
                    }
                }
                finally {
                    this.unlock();
                }
            }
        }

        protected abstract Entry<K1, K2, V> createEntry(K1 var1, K2 var2, int var3);
    }
}

