/*
 * Decompiled with CFR 0.152.
 */
package org.grails.config;

import grails.util.GrailsStringUtils;
import groovy.util.ConfigObject;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.grails.config.EnvironmentAwarePropertySource;
import org.grails.config.NavigableMap;
import org.grails.config.NavigableMapConfig;
import org.grails.config.NavigableMapPropertySource;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;

public class PropertySourcesConfig
extends NavigableMapConfig {
    protected PropertySources propertySources;
    protected PropertySourcesPropertyResolver propertySourcesPropertyResolver;

    public PropertySourcesConfig(PropertySources propertySources) {
        this.propertySources = propertySources;
        this.propertySourcesPropertyResolver = new PropertySourcesPropertyResolver(propertySources);
        this.initializeFromPropertySources(propertySources);
    }

    public PropertySourcesConfig() {
        this.propertySources = new MutablePropertySources();
        this.propertySourcesPropertyResolver = new PropertySourcesPropertyResolver(this.propertySources);
    }

    public PropertySourcesConfig(Map<String, Object> mapPropertySource) {
        MutablePropertySources mutablePropertySources = new MutablePropertySources();
        NavigableMap map = new NavigableMap();
        map.merge(mapPropertySource, true);
        mutablePropertySources.addFirst((PropertySource)new MapPropertySource("config", (Map)map));
        this.propertySources = mutablePropertySources;
        this.propertySourcesPropertyResolver = new PropertySourcesPropertyResolver(this.propertySources);
        this.initializeFromPropertySources(this.propertySources);
    }

    public PropertySourcesConfig(PropertySource propertySource) {
        MutablePropertySources mutablePropertySources = new MutablePropertySources();
        mutablePropertySources.addFirst(propertySource);
        this.propertySources = mutablePropertySources;
        this.propertySourcesPropertyResolver = new PropertySourcesPropertyResolver(this.propertySources);
        this.initializeFromPropertySources(this.propertySources);
    }

    public PropertySources getPropertySources() {
        return this.propertySources;
    }

    public void refresh() {
        this.initializeFromPropertySources(this.propertySources);
    }

    protected void initializeFromPropertySources(PropertySources propertySources) {
        List propertySourceList = DefaultGroovyMethods.toList((Iterable)propertySources);
        Collections.reverse(propertySourceList);
        for (PropertySource propertySource : propertySourceList) {
            if (!(propertySource instanceof EnumerablePropertySource)) continue;
            EnumerablePropertySource enumerablePropertySource = (EnumerablePropertySource)propertySource;
            this.mergeEnumerablePropertySource(enumerablePropertySource);
        }
        EnvironmentAwarePropertySource environmentAwarePropertySource = new EnvironmentAwarePropertySource(propertySources);
        this.mergeEnumerablePropertySource(environmentAwarePropertySource);
        if (propertySources instanceof MutablePropertySources) {
            ((MutablePropertySources)propertySources).addLast((PropertySource)environmentAwarePropertySource);
        }
    }

    private void mergeEnumerablePropertySource(EnumerablePropertySource enumerablePropertySource) {
        if (enumerablePropertySource instanceof NavigableMapPropertySource) {
            this.configMap.merge((Map)((NavigableMapPropertySource)enumerablePropertySource).getSource(), false);
        } else {
            String[] propertyNames;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (String propertyName : propertyNames = enumerablePropertySource.getPropertyNames()) {
                Object value = enumerablePropertySource.getProperty(propertyName);
                if (value instanceof ConfigObject && ((ConfigObject)value).isEmpty()) continue;
                if (value instanceof CharSequence) {
                    value = this.resolvePlaceholders(value.toString());
                }
                map.put(propertyName, value);
            }
            this.configMap.merge(map, true);
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setConversionService(ConfigurableConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public String resolvePlaceholders(String text) {
        if (!GrailsStringUtils.isBlank(text)) {
            return this.propertySourcesPropertyResolver.resolvePlaceholders(text);
        }
        return text;
    }

    public String resolveRequiredPlaceholders(String text) throws IllegalArgumentException {
        return this.propertySourcesPropertyResolver.resolveRequiredPlaceholders(text);
    }
}

