/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.el.ELContext;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.VariableResolver;
import org.springframework.mock.web.MockExpressionEvaluator;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockJspWriter;
import org.springframework.mock.web.MockServletConfig;
import org.springframework.mock.web.MockServletContext;
import org.springframework.util.Assert;

public class MockPageContext
extends PageContext {
    private final ServletContext servletContext;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final ServletConfig servletConfig;
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private JspWriter out;

    public MockPageContext() {
        this(null, null, null, null);
    }

    public MockPageContext(ServletContext servletContext) {
        this(servletContext, null, null, null);
    }

    public MockPageContext(ServletContext servletContext, HttpServletRequest request) {
        this(servletContext, request, null, null);
    }

    public MockPageContext(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
        this(servletContext, request, response, null);
    }

    public MockPageContext(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, ServletConfig servletConfig) {
        this.servletContext = servletContext != null ? servletContext : new MockServletContext();
        this.request = request != null ? request : new MockHttpServletRequest(servletContext);
        this.response = response != null ? response : new MockHttpServletResponse();
        this.servletConfig = servletConfig != null ? servletConfig : new MockServletConfig(servletContext);
    }

    public void initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoFlush) {
        throw new UnsupportedOperationException("Use appropriate constructor");
    }

    public void release() {
    }

    public void setAttribute(String name, Object value) {
        Assert.notNull((Object)name, (String)"Attribute name must not be null");
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    public void setAttribute(String name, Object value, int scope) {
        Assert.notNull((Object)name, (String)"Attribute name must not be null");
        switch (scope) {
            case 1: {
                this.setAttribute(name, value);
                break;
            }
            case 2: {
                this.request.setAttribute(name, value);
                break;
            }
            case 3: {
                this.request.getSession().setAttribute(name, value);
                break;
            }
            case 4: {
                this.servletContext.setAttribute(name, value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid scope: " + scope);
            }
        }
    }

    public Object getAttribute(String name) {
        Assert.notNull((Object)name, (String)"Attribute name must not be null");
        return this.attributes.get(name);
    }

    public Object getAttribute(String name, int scope) {
        Assert.notNull((Object)name, (String)"Attribute name must not be null");
        switch (scope) {
            case 1: {
                return this.getAttribute(name);
            }
            case 2: {
                return this.request.getAttribute(name);
            }
            case 3: {
                HttpSession session = this.request.getSession(false);
                return session != null ? session.getAttribute(name) : null;
            }
            case 4: {
                return this.servletContext.getAttribute(name);
            }
        }
        throw new IllegalArgumentException("Invalid scope: " + scope);
    }

    public Object findAttribute(String name) {
        Object value = this.getAttribute(name);
        if (value == null && (value = this.getAttribute(name, 2)) == null && (value = this.getAttribute(name, 3)) == null) {
            value = this.getAttribute(name, 4);
        }
        return value;
    }

    public void removeAttribute(String name) {
        Assert.notNull((Object)name, (String)"Attribute name must not be null");
        this.removeAttribute(name, 1);
        this.removeAttribute(name, 2);
        this.removeAttribute(name, 3);
        this.removeAttribute(name, 4);
    }

    public void removeAttribute(String name, int scope) {
        Assert.notNull((Object)name, (String)"Attribute name must not be null");
        switch (scope) {
            case 1: {
                this.attributes.remove(name);
                break;
            }
            case 2: {
                this.request.removeAttribute(name);
                break;
            }
            case 3: {
                this.request.getSession().removeAttribute(name);
                break;
            }
            case 4: {
                this.servletContext.removeAttribute(name);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid scope: " + scope);
            }
        }
    }

    public int getAttributesScope(String name) {
        if (this.getAttribute(name) != null) {
            return 1;
        }
        if (this.getAttribute(name, 2) != null) {
            return 2;
        }
        if (this.getAttribute(name, 3) != null) {
            return 3;
        }
        if (this.getAttribute(name, 4) != null) {
            return 4;
        }
        return 0;
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(new LinkedHashSet<String>(this.attributes.keySet()));
    }

    public Enumeration<String> getAttributeNamesInScope(int scope) {
        switch (scope) {
            case 1: {
                return this.getAttributeNames();
            }
            case 2: {
                return this.request.getAttributeNames();
            }
            case 3: {
                HttpSession session = this.request.getSession(false);
                return session != null ? session.getAttributeNames() : null;
            }
            case 4: {
                return this.servletContext.getAttributeNames();
            }
        }
        throw new IllegalArgumentException("Invalid scope: " + scope);
    }

    public JspWriter getOut() {
        if (this.out == null) {
            this.out = new MockJspWriter(this.response);
        }
        return this.out;
    }

    @Deprecated
    public ExpressionEvaluator getExpressionEvaluator() {
        return new MockExpressionEvaluator(this);
    }

    public ELContext getELContext() {
        return null;
    }

    @Deprecated
    public VariableResolver getVariableResolver() {
        return null;
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public Object getPage() {
        return this;
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public Exception getException() {
        return null;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void forward(String path) throws ServletException, IOException {
        this.request.getRequestDispatcher(path).forward((ServletRequest)this.request, (ServletResponse)this.response);
    }

    public void include(String path) throws ServletException, IOException {
        this.request.getRequestDispatcher(path).include((ServletRequest)this.request, (ServletResponse)this.response);
    }

    public void include(String path, boolean flush) throws ServletException, IOException {
        this.request.getRequestDispatcher(path).include((ServletRequest)this.request, (ServletResponse)this.response);
        if (flush) {
            this.response.flushBuffer();
        }
    }

    public byte[] getContentAsByteArray() {
        Assert.isTrue((boolean)(this.response instanceof MockHttpServletResponse));
        return ((MockHttpServletResponse)this.response).getContentAsByteArray();
    }

    public String getContentAsString() throws UnsupportedEncodingException {
        Assert.isTrue((boolean)(this.response instanceof MockHttpServletResponse));
        return ((MockHttpServletResponse)this.response).getContentAsString();
    }

    public void handlePageException(Exception ex) throws ServletException, IOException {
        throw new ServletException("Page exception", (Throwable)ex);
    }

    public void handlePageException(Throwable ex) throws ServletException, IOException {
        throw new ServletException("Page exception", ex);
    }
}

