/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.transaction;

import org.springframework.core.NamedInheritableThreadLocal;
import org.springframework.test.context.transaction.TransactionContext;

class TransactionContextHolder {
    private static final ThreadLocal<TransactionContext> currentTransactionContext = new NamedInheritableThreadLocal("Test Transaction Context");

    TransactionContextHolder() {
    }

    static TransactionContext getCurrentTransactionContext() {
        return currentTransactionContext.get();
    }

    static void setCurrentTransactionContext(TransactionContext transactionContext) {
        currentTransactionContext.set(transactionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TransactionContext removeCurrentTransactionContext() {
        ThreadLocal<TransactionContext> threadLocal = currentTransactionContext;
        synchronized (threadLocal) {
            TransactionContext transactionContext = currentTransactionContext.get();
            currentTransactionContext.remove();
            return transactionContext;
        }
    }
}

