/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded.agent;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springsource.loaded.FileChangeListener;
import org.springsource.loaded.GlobalConfiguration;
import org.springsource.loaded.TypeRegistry;

class Watcher
implements Runnable {
    private static Logger log = Logger.getLogger(Watcher.class.getName());
    long lastScanTime;
    private static long interval = 1100L;
    List<File> watchListFiles = new ArrayList<File>();
    List<Long> watchListLMTs = new ArrayList<Long>();
    FileChangeListener listener;
    private boolean timeToStop = false;
    public boolean paused = false;
    private Thread thread = null;
    private int typeRegistryId;
    private String classloadername;
    private int registryLivenessCount = 0;
    private static int registryLivenessCountInterval = 300;

    public Watcher(FileChangeListener listener, int typeRegistryId, String classloadername) {
        this.listener = listener;
        this.typeRegistryId = typeRegistryId;
        this.classloadername = classloadername;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addFile(File fileToWatch) {
        if (!fileToWatch.exists()) {
            return false;
        }
        Watcher watcher = this;
        synchronized (watcher) {
            int insertionPos;
            if (GlobalConfiguration.verboseMode && log.isLoggable(Level.INFO)) {
                log.info("Now watching " + fileToWatch);
            }
            if ((insertionPos = this.findPosition(fileToWatch)) == -1) {
                this.watchListFiles.add(fileToWatch);
                this.watchListLMTs.add(fileToWatch.lastModified());
            } else {
                this.watchListFiles.add(insertionPos, fileToWatch);
                this.watchListLMTs.add(insertionPos, fileToWatch.lastModified());
            }
            return true;
        }
    }

    public void updateName() {
        if (this.thread != null) {
            this.thread.setName("FileSystemWatcher: files=#" + this.watchListFiles.size() + " cl=" + this.classloadername);
        }
    }

    private int findPosition(File file) {
        String filename = file.getName();
        int len = this.watchListFiles.size();
        if (len == 0) {
            return 0;
        }
        for (int f = 0; f < len; ++f) {
            File file2 = this.watchListFiles.get(f);
            int cmp = file2.getName().compareTo(filename);
            if (cmp > 0) {
                return f;
            }
            if (!GlobalConfiguration.assertsMode || cmp != 0 || !file2.getAbsoluteFile().toString().equals(file.getAbsoluteFile().toString())) continue;
            log.severe("Watching the same file twice: " + file.getAbsoluteFile().toString());
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.timeToStop) {
            ++this.registryLivenessCount;
            if (this.registryLivenessCount % registryLivenessCountInterval == 0) {
                if (!TypeRegistry.typeRegistryExistsForId(this.typeRegistryId)) {
                    if (GlobalConfiguration.verboseMode && log.isLoggable(Level.INFO)) {
                        log.info("TypeRegistry " + this.typeRegistryId + " gone, no point in thread continuing!");
                    }
                    return;
                }
                this.registryLivenessCount = 0;
            }
            try {
                Thread.sleep(interval);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.paused) continue;
            ArrayList<File> changedFiles = new ArrayList<File>();
            Watcher watcher = this;
            synchronized (watcher) {
                int len = this.watchListFiles.size();
                for (int f = 0; f < len; ++f) {
                    File file = this.watchListFiles.get(f);
                    long lastModTime = file.lastModified();
                    if (lastModTime <= this.watchListLMTs.get(f)) continue;
                    if (GlobalConfiguration.verboseMode && log.isLoggable(Level.INFO)) {
                        log.info("Observed last modification time change for " + file + " (lastScanTime=" + this.lastScanTime + ")");
                    }
                    this.watchListLMTs.set(f, lastModTime);
                    changedFiles.add(file);
                }
                this.lastScanTime = System.currentTimeMillis();
            }
            for (File changedFile : changedFiles) {
                this.determineChangesSince(changedFile, this.lastScanTime);
            }
        }
    }

    private void determineChangesSince(File file, long lastScanTime) {
        block7: {
            try {
                if (GlobalConfiguration.verboseMode && log.isLoggable(Level.INFO)) {
                    log.info("Firing file changed event " + file);
                }
                this.listener.fileChanged(file);
                if (file.isDirectory()) {
                    File[] filesOfInterest;
                    for (File f : filesOfInterest = file.listFiles(new RecentChangeFilter(lastScanTime))) {
                        if (f.isDirectory()) {
                            this.determineChangesSince(f, lastScanTime);
                            continue;
                        }
                        if (GlobalConfiguration.verboseMode && log.isLoggable(Level.INFO)) {
                            log.info("Observed last modification time change for " + f + "  (lastScanTime=" + lastScanTime + ")");
                            log.info("Firing file changed event " + file);
                        }
                        this.listener.fileChanged(f);
                    }
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(Level.SEVERE)) break block7;
                log.log(Level.SEVERE, "FileWatcher caught serious error, see cause", t);
            }
        }
    }

    public void timeToStop() {
        this.timeToStop = true;
    }

    static class RecentChangeFilter
    implements FileFilter {
        private long lastScanTime;

        public RecentChangeFilter(long lastScanTime) {
            this.lastScanTime = lastScanTime;
        }

        public boolean accept(File pathname) {
            return pathname.lastModified() > this.lastScanTime;
        }
    }
}

