/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah.benchmark;

import com.googlecode.javaewah.benchmark.UniformDataGenerator;

public class ClusteredDataGenerator {
    UniformDataGenerator unidg;

    public ClusteredDataGenerator() {
        this.unidg = new UniformDataGenerator();
    }

    public ClusteredDataGenerator(int seed) {
        this.unidg = new UniformDataGenerator(seed);
    }

    public int[] generateClustered(int N, int Max) {
        int[] array = new int[N];
        this.fillClustered(array, 0, N, 0, Max);
        return array;
    }

    void fillClustered(int[] array, int offset, int length, int Min, int Max) {
        int range = Max - Min;
        if (range == length || length <= 10) {
            this.fillUniform(array, offset, length, Min, Max);
            return;
        }
        int cut = length / 2 + (range - length - 1 > 0 ? this.unidg.rand.nextInt(range - length - 1) : 0);
        double p = this.unidg.rand.nextDouble();
        if (p < 0.25) {
            this.fillUniform(array, offset, length / 2, Min, Min + cut);
            this.fillClustered(array, offset + length / 2, length - length / 2, Min + cut, Max);
        } else if (p < 0.5) {
            this.fillClustered(array, offset, length / 2, Min, Min + cut);
            this.fillUniform(array, offset + length / 2, length - length / 2, Min + cut, Max);
        } else {
            this.fillClustered(array, offset, length / 2, Min, Min + cut);
            this.fillClustered(array, offset + length / 2, length - length / 2, Min + cut, Max);
        }
    }

    void fillUniform(int[] array, int offset, int length, int Min, int Max) {
        int[] v = this.unidg.generateUniform(length, Max - Min);
        for (int k = 0; k < v.length; ++k) {
            array[k + offset] = Min + v[k];
        }
    }
}

